/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.SocketAppender$Builder;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.net.AbstractSocketManager;
import org.apache.logging.log4j.core.net.Advertiser;
import org.apache.logging.log4j.core.net.DatagramSocketManager;
import org.apache.logging.log4j.core.net.Protocol;
import org.apache.logging.log4j.core.net.SocketOptions;
import org.apache.logging.log4j.core.net.SslSocketManager;
import org.apache.logging.log4j.core.net.TcpSocketManager;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.core.util.Booleans;

@Plugin(name="Socket", category="Core", elementType="appender", printObject=true)
public class SocketAppender
extends AbstractOutputStreamAppender<AbstractSocketManager> {
    private final Object advertisement;
    private final Advertiser advertiser;

    @PluginBuilderFactory
    public static SocketAppender$Builder newBuilder() {
        return new SocketAppender$Builder();
    }

    protected SocketAppender(String string, Layout<? extends Serializable> layout, Filter filter, AbstractSocketManager abstractSocketManager, boolean bl, boolean bl2, Advertiser advertiser, Property[] propertyArray) {
        super(string, layout, filter, bl, bl2, propertyArray, abstractSocketManager);
        if (advertiser != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>(layout.getContentFormat());
            hashMap.putAll(abstractSocketManager.getContentFormat());
            hashMap.put("contentType", layout.getContentType());
            hashMap.put("name", string);
            this.advertisement = advertiser.advertise(hashMap);
        } else {
            this.advertisement = null;
        }
        this.advertiser = advertiser;
    }

    @Deprecated
    protected SocketAppender(String string, Layout<? extends Serializable> layout, Filter filter, AbstractSocketManager abstractSocketManager, boolean bl, boolean bl2, Advertiser advertiser) {
        this(string, layout, filter, abstractSocketManager, bl, bl2, advertiser, Property.EMPTY_ARRAY);
    }

    @Override
    public boolean stop(long l, TimeUnit timeUnit) {
        this.setStopping();
        super.stop(l, timeUnit, false);
        if (this.advertiser != null) {
            this.advertiser.unadvertise(this.advertisement);
        }
        this.setStopped();
        return true;
    }

    @Deprecated
    @PluginFactory
    public static SocketAppender createAppender(String string, int n, Protocol protocol, SslConfiguration sslConfiguration, int n2, int n3, boolean bl, String string2, boolean bl2, boolean bl3, Layout<? extends Serializable> layout, Filter filter, boolean bl4, Configuration configuration) {
        return ((SocketAppender$Builder)((SocketAppender$Builder)((SocketAppender$Builder)((SocketAppender$Builder)((SocketAppender$Builder)((SocketAppender$Builder)((SocketAppender$Builder)((SocketAppender$Builder)((SocketAppender$Builder)((SocketAppender$Builder)((SocketAppender$Builder)((SocketAppender$Builder)((SocketAppender$Builder)SocketAppender.newBuilder().setAdvertise(bl4)).setConfiguration(configuration)).setConnectTimeoutMillis(n2)).setFilter(filter)).setHost(string)).setIgnoreExceptions(bl3)).setImmediateFail(bl)).setLayout(layout)).setName(string2)).setPort(n)).setProtocol(protocol)).setReconnectDelayMillis(n3)).setSslConfiguration(sslConfiguration)).build();
    }

    @Deprecated
    public static SocketAppender createAppender(String string, String string2, String string3, SslConfiguration sslConfiguration, int n, String string4, String string5, String string6, String string7, String string8, Layout<? extends Serializable> layout, Filter filter, String string9, Configuration configuration) {
        boolean bl = Booleans.parseBoolean(string7, true);
        boolean bl2 = Boolean.parseBoolean(string9);
        boolean bl3 = Booleans.parseBoolean(string8, true);
        boolean bl4 = Booleans.parseBoolean(string5, true);
        int n2 = AbstractAppender.parseInt(string4, 0);
        int n3 = AbstractAppender.parseInt(string2, 0);
        Protocol protocol = string3 == null ? Protocol.UDP : Protocol.valueOf(string3);
        return SocketAppender.createAppender(string, n3, protocol, sslConfiguration, n, n2, bl4, string6, bl, bl3, layout, filter, bl2, configuration);
    }

    @Deprecated
    protected static AbstractSocketManager createSocketManager(String string, Protocol protocol, String string2, int n, int n2, SslConfiguration sslConfiguration, int n3, boolean bl, Layout<? extends Serializable> layout, int n4) {
        return SocketAppender.createSocketManager(string, protocol, string2, n, n2, sslConfiguration, n3, bl, layout, n4, null);
    }

    protected static AbstractSocketManager createSocketManager(String string, Protocol protocol, String string2, int n, int n2, SslConfiguration sslConfiguration, int n3, boolean bl, Layout<? extends Serializable> layout, int n4, SocketOptions socketOptions) {
        if (protocol == Protocol.TCP && sslConfiguration != null) {
            protocol = Protocol.SSL;
        }
        if (protocol != Protocol.SSL && sslConfiguration != null) {
            LOGGER.info("Appender {} ignoring SSL configuration for {} protocol", (Object)string, (Object)protocol);
        }
        switch (protocol) {
            case TCP: {
                return TcpSocketManager.getSocketManager(string2, n, n2, n3, bl, layout, n4, socketOptions);
            }
            case UDP: {
                return DatagramSocketManager.getSocketManager(string2, n, layout, n4);
            }
            case SSL: {
                return SslSocketManager.getSocketManager(sslConfiguration, string2, n, n2, n3, bl, layout, n4, socketOptions);
            }
        }
        throw new IllegalArgumentException(protocol.toString());
    }

    @Override
    protected void directEncodeEvent(LogEvent logEvent) {
        this.writeByteArrayToManager(logEvent);
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }
}

