/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.HttpAppender$1;
import org.apache.logging.log4j.core.appender.HttpAppender$Builder;
import org.apache.logging.log4j.core.appender.HttpManager;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;

@Plugin(name="Http", category="Core", elementType="appender", printObject=true)
public final class HttpAppender
extends AbstractAppender {
    private final HttpManager manager;

    @PluginBuilderFactory
    public static <B extends HttpAppender$Builder<B>> B newBuilder() {
        return (B)((HttpAppender$Builder)new HttpAppender$Builder().asBuilder());
    }

    private HttpAppender(String string, Layout<? extends Serializable> layout, Filter filter, boolean bl, HttpManager httpManager, Property[] propertyArray) {
        super(string, filter, layout, bl, propertyArray);
        Objects.requireNonNull(layout, "layout");
        this.manager = Objects.requireNonNull(httpManager, "manager");
    }

    @Override
    public void start() {
        super.start();
        this.manager.startup();
    }

    @Override
    public void append(LogEvent logEvent) {
        try {
            this.manager.send(this.getLayout(), logEvent);
        }
        catch (Exception exception) {
            this.error("Unable to send HTTP in appender [" + this.getName() + "]", logEvent, exception);
        }
    }

    @Override
    public boolean stop(long l, TimeUnit timeUnit) {
        this.setStopping();
        boolean bl = super.stop(l, timeUnit, false);
        this.setStopped();
        return bl &= this.manager.stop(l, timeUnit);
    }

    @Override
    public String toString() {
        return "HttpAppender{name=" + this.getName() + ", state=" + (Object)((Object)this.getState()) + '}';
    }

    /* synthetic */ HttpAppender(String string, Layout layout, Filter filter, boolean bl, HttpManager httpManager, Property[] propertyArray, HttpAppender$1 httpAppender$1) {
        this(string, layout, filter, bl, httpManager, propertyArray);
    }
}

