/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.FileManager$FactoryData;
import org.apache.logging.log4j.core.appender.FileManager$FileManagerFactory;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.util.FileUtils;

public class FileManager
extends OutputStreamManager {
    private static final FileManager$FileManagerFactory FACTORY = new FileManager$FileManagerFactory(null);
    private final boolean isAppend;
    private final boolean createOnDemand;
    private final boolean isLocking;
    private final String advertiseURI;
    private final int bufferSize;
    private final Set<PosixFilePermission> filePermissions;
    private final String fileOwner;
    private final String fileGroup;
    private final boolean attributeViewEnabled;

    @Deprecated
    protected FileManager(String string, OutputStream outputStream, boolean bl, boolean bl2, String string2, Layout<? extends Serializable> layout, int n, boolean bl3) {
        this(string, outputStream, bl, bl2, string2, layout, bl3, ByteBuffer.wrap(new byte[n]));
    }

    @Deprecated
    protected FileManager(String string, OutputStream outputStream, boolean bl, boolean bl2, String string2, Layout<? extends Serializable> layout, boolean bl3, ByteBuffer byteBuffer) {
        super(outputStream, string, layout, bl3, byteBuffer);
        this.isAppend = bl;
        this.createOnDemand = false;
        this.isLocking = bl2;
        this.advertiseURI = string2;
        this.bufferSize = byteBuffer.capacity();
        this.filePermissions = null;
        this.fileOwner = null;
        this.fileGroup = null;
        this.attributeViewEnabled = false;
    }

    @Deprecated
    protected FileManager(LoggerContext loggerContext, String string, OutputStream outputStream, boolean bl, boolean bl2, boolean bl3, String string2, Layout<? extends Serializable> layout, boolean bl4, ByteBuffer byteBuffer) {
        super(loggerContext, outputStream, string, bl3, layout, bl4, byteBuffer);
        this.isAppend = bl;
        this.createOnDemand = bl3;
        this.isLocking = bl2;
        this.advertiseURI = string2;
        this.bufferSize = byteBuffer.capacity();
        this.filePermissions = null;
        this.fileOwner = null;
        this.fileGroup = null;
        this.attributeViewEnabled = false;
    }

    protected FileManager(LoggerContext loggerContext, String string, OutputStream outputStream, boolean bl, boolean bl2, boolean bl3, String string2, Layout<? extends Serializable> layout, String string3, String string4, String string5, boolean bl4, ByteBuffer byteBuffer) {
        super(loggerContext, outputStream, string, bl3, layout, bl4, byteBuffer);
        this.isAppend = bl;
        this.createOnDemand = bl3;
        this.isLocking = bl2;
        this.advertiseURI = string2;
        this.bufferSize = byteBuffer.capacity();
        Set<String> set = FileSystems.getDefault().supportedFileAttributeViews();
        if (set.contains("posix")) {
            this.filePermissions = string3 != null ? PosixFilePermissions.fromString(string3) : null;
            this.fileGroup = string5;
        } else {
            this.filePermissions = null;
            this.fileGroup = null;
            if (string3 != null) {
                LOGGER.warn("Posix file attribute permissions defined but it is not supported by this files system.");
            }
            if (string5 != null) {
                LOGGER.warn("Posix file attribute group defined but it is not supported by this files system.");
            }
        }
        if (set.contains("owner")) {
            this.fileOwner = string4;
        } else {
            this.fileOwner = null;
            if (string4 != null) {
                LOGGER.warn("Owner file attribute defined but it is not supported by this files system.");
            }
        }
        this.attributeViewEnabled = this.filePermissions != null || this.fileOwner != null || this.fileGroup != null;
    }

    public static FileManager getFileManager(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string2, Layout<? extends Serializable> layout, int n, String string3, String string4, String string5, Configuration configuration) {
        if (bl2 && bl3) {
            bl2 = false;
        }
        return FileManager.narrow(FileManager.class, FileManager.getManager(string, new FileManager$FactoryData(bl, bl2, bl3, n, bl4, string2, layout, string3, string4, string5, configuration), FACTORY));
    }

    @Override
    protected OutputStream createOutputStream() {
        String string = this.getFileName();
        LOGGER.debug("Now writing to {} at {}", (Object)string, (Object)new Date());
        File file = new File(string);
        this.createParentDir(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file, this.isAppend);
        if (file.exists() && file.length() == 0L) {
            try {
                FileTime fileTime = FileTime.fromMillis(System.currentTimeMillis());
                Files.setAttribute(file.toPath(), "creationTime", fileTime, new LinkOption[0]);
            }
            catch (Exception exception) {
                LOGGER.warn("Unable to set current file time for {}", (Object)string);
            }
            this.writeHeader(fileOutputStream);
        }
        this.defineAttributeView(Paths.get(string, new String[0]));
        return fileOutputStream;
    }

    protected void createParentDir(File file) {
    }

    protected void defineAttributeView(Path path) {
        if (this.attributeViewEnabled) {
            try {
                path.toFile().createNewFile();
                FileUtils.defineFilePosixAttributeView(path, this.filePermissions, this.fileOwner, this.fileGroup);
            }
            catch (Exception exception) {
                LOGGER.error("Could not define attribute view on path \"{}\" got {}", (Object)path, (Object)exception.getMessage(), (Object)exception);
            }
        }
    }

    @Override
    protected synchronized void write(byte[] byArray, int n, int n2, boolean bl) {
        block15: {
            if (this.isLocking) {
                try {
                    FileChannel fileChannel = ((FileOutputStream)this.getOutputStream()).getChannel();
                    try (FileLock fileLock = fileChannel.lock(0L, Long.MAX_VALUE, false);){
                        super.write(byArray, n, n2, bl);
                        break block15;
                    }
                }
                catch (IOException iOException) {
                    throw new AppenderLoggingException("Unable to obtain lock on " + this.getName(), iOException);
                }
            }
            super.write(byArray, n, n2, bl);
        }
    }

    @Override
    protected synchronized void writeToDestination(byte[] byArray, int n, int n2) {
        block15: {
            if (this.isLocking) {
                try {
                    FileChannel fileChannel = ((FileOutputStream)this.getOutputStream()).getChannel();
                    try (FileLock fileLock = fileChannel.lock(0L, Long.MAX_VALUE, false);){
                        super.writeToDestination(byArray, n, n2);
                        break block15;
                    }
                }
                catch (IOException iOException) {
                    throw new AppenderLoggingException("Unable to obtain lock on " + this.getName(), iOException);
                }
            }
            super.writeToDestination(byArray, n, n2);
        }
    }

    public String getFileName() {
        return this.getName();
    }

    public boolean isAppend() {
        return this.isAppend;
    }

    public boolean isCreateOnDemand() {
        return this.createOnDemand;
    }

    public boolean isLocking() {
        return this.isLocking;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public Set<PosixFilePermission> getFilePermissions() {
        return this.filePermissions;
    }

    public String getFileOwner() {
        return this.fileOwner;
    }

    public String getFileGroup() {
        return this.fileGroup;
    }

    public boolean isAttributeViewEnabled() {
        return this.attributeViewEnabled;
    }

    @Override
    public Map<String, String> getContentFormat() {
        HashMap<String, String> hashMap = new HashMap<String, String>(super.getContentFormat());
        hashMap.put("fileURI", this.advertiseURI);
        return hashMap;
    }

    static /* synthetic */ boolean access$1100(FileManager fileManager) {
        return fileManager.attributeViewEnabled;
    }
}

