/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender$Builder;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.FileManager;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.util.Builder;

public class FileAppender$Builder<B extends FileAppender$Builder<B>>
extends AbstractOutputStreamAppender$Builder<B>
implements Builder<FileAppender> {
    @PluginBuilderAttribute
    @Required
    private String fileName;
    @PluginBuilderAttribute
    private boolean append = true;
    @PluginBuilderAttribute
    private boolean locking;
    @PluginBuilderAttribute
    private boolean advertise;
    @PluginBuilderAttribute
    private String advertiseUri;
    @PluginBuilderAttribute
    private boolean createOnDemand;
    @PluginBuilderAttribute
    private String filePermissions;
    @PluginBuilderAttribute
    private String fileOwner;
    @PluginBuilderAttribute
    private String fileGroup;

    @Override
    public FileAppender build() {
        Layout<Serializable> layout;
        FileManager fileManager;
        if (!this.isValid()) {
            return null;
        }
        boolean bl = this.isBufferedIo();
        int n = this.getBufferSize();
        if (this.locking && bl) {
            FileAppender.access$000().warn("Locking and buffering are mutually exclusive. No buffering will occur for {}", (Object)this.fileName);
            bl = false;
        }
        if (!bl && n > 0) {
            FileAppender.access$100().warn("The bufferSize is set to {} but bufferedIo is false: {}", (Object)n, (Object)bl);
        }
        if ((fileManager = FileManager.getFileManager(this.fileName, this.append, this.locking, bl, this.createOnDemand, this.advertiseUri, layout = this.getOrCreateLayout(), n, this.filePermissions, this.fileOwner, this.fileGroup, this.getConfiguration())) == null) {
            return null;
        }
        return new FileAppender(this.getName(), layout, this.getFilter(), fileManager, this.fileName, this.isIgnoreExceptions(), !bl || this.isImmediateFlush(), this.advertise ? this.getConfiguration().getAdvertiser() : null, this.getPropertyArray(), null);
    }

    public String getAdvertiseUri() {
        return this.advertiseUri;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isAdvertise() {
        return this.advertise;
    }

    public boolean isAppend() {
        return this.append;
    }

    public boolean isCreateOnDemand() {
        return this.createOnDemand;
    }

    public boolean isLocking() {
        return this.locking;
    }

    public String getFilePermissions() {
        return this.filePermissions;
    }

    public String getFileOwner() {
        return this.fileOwner;
    }

    public String getFileGroup() {
        return this.fileGroup;
    }

    public B withAdvertise(boolean bl) {
        this.advertise = bl;
        return (B)((FileAppender$Builder)this.asBuilder());
    }

    public B withAdvertiseUri(String string) {
        this.advertiseUri = string;
        return (B)((FileAppender$Builder)this.asBuilder());
    }

    public B withAppend(boolean bl) {
        this.append = bl;
        return (B)((FileAppender$Builder)this.asBuilder());
    }

    public B withFileName(String string) {
        this.fileName = string;
        return (B)((FileAppender$Builder)this.asBuilder());
    }

    public B withCreateOnDemand(boolean bl) {
        this.createOnDemand = bl;
        return (B)((FileAppender$Builder)this.asBuilder());
    }

    public B withLocking(boolean bl) {
        this.locking = bl;
        return (B)((FileAppender$Builder)this.asBuilder());
    }

    public B withFilePermissions(String string) {
        this.filePermissions = string;
        return (B)((FileAppender$Builder)this.asBuilder());
    }

    public B withFileOwner(String string) {
        this.fileOwner = string;
        return (B)((FileAppender$Builder)this.asBuilder());
    }

    public B withFileGroup(String string) {
        this.fileGroup = string;
        return (B)((FileAppender$Builder)this.asBuilder());
    }
}

