/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TransferQueue;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AsyncAppender$1;
import org.apache.logging.log4j.core.appender.AsyncAppender$Builder;
import org.apache.logging.log4j.core.appender.AsyncAppenderEventDispatcher;
import org.apache.logging.log4j.core.async.ArrayBlockingQueueFactory;
import org.apache.logging.log4j.core.async.AsyncQueueFullMessageUtil;
import org.apache.logging.log4j.core.async.AsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.AsyncQueueFullPolicyFactory;
import org.apache.logging.log4j.core.async.BlockingQueueFactory;
import org.apache.logging.log4j.core.async.DiscardingAsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.EventRoute;
import org.apache.logging.log4j.core.async.InternalAsyncUtil;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.spi.AbstractLogger;

@Plugin(name="Async", category="Core", elementType="appender", printObject=true)
public final class AsyncAppender
extends AbstractAppender {
    private static final int DEFAULT_QUEUE_SIZE = 1024;
    private final BlockingQueue<LogEvent> queue;
    private final int queueSize;
    private final boolean blocking;
    private final long shutdownTimeout;
    private final Configuration config;
    private final AppenderRef[] appenderRefs;
    private final String errorRef;
    private final boolean includeLocation;
    private AppenderControl errorAppender;
    private AsyncAppenderEventDispatcher dispatcher;
    private AsyncQueueFullPolicy asyncQueueFullPolicy;

    private AsyncAppender(String string, Filter filter, AppenderRef[] appenderRefArray, String string2, int n, boolean bl, boolean bl2, long l, Configuration configuration, boolean bl3, BlockingQueueFactory<LogEvent> blockingQueueFactory, Property[] propertyArray) {
        super(string, filter, null, bl2, propertyArray);
        this.queue = blockingQueueFactory.create(n);
        this.queueSize = n;
        this.blocking = bl;
        this.shutdownTimeout = l;
        this.config = configuration;
        this.appenderRefs = appenderRefArray;
        this.errorRef = string2;
        this.includeLocation = bl3;
    }

    @Override
    public void start() {
        Map<String, Appender> map = this.config.getAppenders();
        ArrayList<AppenderControl> arrayList = new ArrayList<AppenderControl>();
        for (AppenderRef appenderRef : this.appenderRefs) {
            Appender appender = map.get(appenderRef.getRef());
            if (appender != null) {
                arrayList.add(new AppenderControl(appender, appenderRef.getLevel(), appenderRef.getFilter()));
                continue;
            }
            LOGGER.error("No appender named {} was configured", (Object)appenderRef);
        }
        if (this.errorRef != null) {
            Appender appender = map.get(this.errorRef);
            if (appender != null) {
                this.errorAppender = new AppenderControl(appender, null, null);
            } else {
                LOGGER.error("Unable to set up error Appender. No appender named {} was configured", (Object)this.errorRef);
            }
        }
        if (arrayList.size() > 0) {
            this.dispatcher = new AsyncAppenderEventDispatcher(this.getName(), this.errorAppender, arrayList, this.queue);
        } else if (this.errorRef == null) {
            throw new ConfigurationException("No appenders are available for AsyncAppender " + this.getName());
        }
        this.asyncQueueFullPolicy = AsyncQueueFullPolicyFactory.create();
        this.dispatcher.start();
        super.start();
    }

    @Override
    public boolean stop(long l, TimeUnit timeUnit) {
        this.setStopping();
        super.stop(l, timeUnit, false);
        LOGGER.trace("AsyncAppender stopping. Queue still has {} events.", (Object)this.queue.size());
        try {
            this.dispatcher.stop(this.shutdownTimeout);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            LOGGER.warn("Interrupted while stopping AsyncAppender {}", (Object)this.getName());
        }
        LOGGER.trace("AsyncAppender stopped. Queue has {} events.", (Object)this.queue.size());
        if (DiscardingAsyncQueueFullPolicy.getDiscardCount(this.asyncQueueFullPolicy) > 0L) {
            LOGGER.trace("AsyncAppender: {} discarded {} events.", (Object)this.asyncQueueFullPolicy, (Object)DiscardingAsyncQueueFullPolicy.getDiscardCount(this.asyncQueueFullPolicy));
        }
        this.setStopped();
        return true;
    }

    @Override
    public void append(LogEvent logEvent) {
        if (!this.isStarted()) {
            throw new IllegalStateException("AsyncAppender " + this.getName() + " is not active");
        }
        Log4jLogEvent log4jLogEvent = Log4jLogEvent.createMemento(logEvent, this.includeLocation);
        InternalAsyncUtil.makeMessageImmutable(logEvent.getMessage());
        if (!this.transfer(log4jLogEvent)) {
            if (this.blocking) {
                if (AbstractLogger.getRecursionDepth() > 1) {
                    AsyncQueueFullMessageUtil.logWarningToStatusLogger();
                    this.logMessageInCurrentThread(logEvent);
                } else {
                    EventRoute eventRoute = this.asyncQueueFullPolicy.getRoute(this.dispatcher.getId(), log4jLogEvent.getLevel());
                    eventRoute.logMessage(this, (LogEvent)log4jLogEvent);
                }
            } else {
                this.error("Appender " + this.getName() + " is unable to write primary appenders. queue is full");
                this.logToErrorAppenderIfNecessary(false, log4jLogEvent);
            }
        }
    }

    private boolean transfer(LogEvent logEvent) {
        return this.queue instanceof TransferQueue ? ((TransferQueue)this.queue).tryTransfer(logEvent) : this.queue.offer(logEvent);
    }

    public void logMessageInCurrentThread(LogEvent logEvent) {
        logEvent.setEndOfBatch(this.queue.isEmpty());
        this.dispatcher.dispatch(logEvent);
    }

    public void logMessageInBackgroundThread(LogEvent logEvent) {
        try {
            this.queue.put(logEvent);
        }
        catch (InterruptedException interruptedException) {
            boolean bl = this.handleInterruptedException(logEvent);
            this.logToErrorAppenderIfNecessary(bl, logEvent);
        }
    }

    private boolean handleInterruptedException(LogEvent logEvent) {
        boolean bl = this.queue.offer(logEvent);
        if (!bl) {
            LOGGER.warn("Interrupted while waiting for a free slot in the AsyncAppender LogEvent-queue {}", (Object)this.getName());
        }
        Thread.currentThread().interrupt();
        return bl;
    }

    private void logToErrorAppenderIfNecessary(boolean bl, LogEvent logEvent) {
        if (!bl && this.errorAppender != null) {
            this.errorAppender.callAppender(logEvent);
        }
    }

    @Deprecated
    public static AsyncAppender createAppender(AppenderRef[] appenderRefArray, String string, boolean bl, long l, int n, String string2, boolean bl2, Filter filter, Configuration configuration, boolean bl3) {
        if (string2 == null) {
            LOGGER.error("No name provided for AsyncAppender");
            return null;
        }
        if (appenderRefArray == null) {
            LOGGER.error("No appender references provided to AsyncAppender {}", (Object)string2);
        }
        return new AsyncAppender(string2, filter, appenderRefArray, string, n, bl, bl3, l, configuration, bl2, new ArrayBlockingQueueFactory<LogEvent>(), null);
    }

    @PluginBuilderFactory
    public static AsyncAppender$Builder newBuilder() {
        return new AsyncAppender$Builder();
    }

    public String[] getAppenderRefStrings() {
        String[] stringArray = new String[this.appenderRefs.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.appenderRefs[i].getRef();
        }
        return stringArray;
    }

    public boolean isIncludeLocation() {
        return this.includeLocation;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public List<Appender> getAppenders() {
        return this.dispatcher.getAppenders();
    }

    public String getErrorRef() {
        return this.errorRef;
    }

    public int getQueueCapacity() {
        return this.queueSize;
    }

    public int getQueueRemainingCapacity() {
        return this.queue.remainingCapacity();
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    /* synthetic */ AsyncAppender(String string, Filter filter, AppenderRef[] appenderRefArray, String string2, int n, boolean bl, boolean bl2, long l, Configuration configuration, boolean bl3, BlockingQueueFactory blockingQueueFactory, Property[] propertyArray, AsyncAppender$1 asyncAppender$1) {
        this(string, filter, appenderRefArray, string2, n, bl, bl2, l, configuration, bl3, blockingQueueFactory, propertyArray);
    }
}

