/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.ThreadContext$ContextStack;
import org.apache.logging.log4j.ThreadContext$EmptyThreadContextStack;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.spi.CleanableThreadContextMap;
import org.apache.logging.log4j.spi.DefaultThreadContextMap;
import org.apache.logging.log4j.spi.DefaultThreadContextStack;
import org.apache.logging.log4j.spi.NoOpThreadContextMap;
import org.apache.logging.log4j.spi.ReadOnlyThreadContextMap;
import org.apache.logging.log4j.spi.ThreadContextMap;
import org.apache.logging.log4j.spi.ThreadContextMap2;
import org.apache.logging.log4j.spi.ThreadContextMapFactory;
import org.apache.logging.log4j.spi.ThreadContextStack;
import org.apache.logging.log4j.util.PropertiesUtil;

public final class ThreadContext {
    public static final Map<String, String> EMPTY_MAP = Collections.emptyMap();
    public static final ThreadContextStack EMPTY_STACK = new ThreadContext$EmptyThreadContextStack(null);
    private static final String DISABLE_MAP = "disableThreadContextMap";
    private static final String DISABLE_STACK = "disableThreadContextStack";
    private static final String DISABLE_ALL = "disableThreadContext";
    private static boolean useStack;
    private static ThreadContextMap contextMap;
    private static ThreadContextStack contextStack;
    private static ReadOnlyThreadContextMap readOnlyContextMap;

    private ThreadContext() {
    }

    public static void init() {
        ThreadContextMapFactory.init();
        contextMap = null;
        PropertiesUtil propertiesUtil = PropertiesUtil.getProperties();
        boolean bl = propertiesUtil.getBooleanProperty(DISABLE_ALL);
        useStack = !propertiesUtil.getBooleanProperty(DISABLE_STACK) && !bl;
        boolean bl2 = !propertiesUtil.getBooleanProperty(DISABLE_MAP) && !bl;
        contextStack = new DefaultThreadContextStack(useStack);
        contextMap = !bl2 ? new NoOpThreadContextMap() : ThreadContextMapFactory.createThreadContextMap();
        readOnlyContextMap = contextMap instanceof ReadOnlyThreadContextMap ? (ReadOnlyThreadContextMap)((Object)contextMap) : null;
    }

    public static void put(String string, String string2) {
        contextMap.put(string, string2);
    }

    public static void putIfNull(String string, String string2) {
        if (!contextMap.containsKey(string)) {
            contextMap.put(string, string2);
        }
    }

    public static void putAll(Map<String, String> map) {
        if (contextMap instanceof ThreadContextMap2) {
            ((ThreadContextMap2)contextMap).putAll(map);
        } else if (contextMap instanceof DefaultThreadContextMap) {
            ((DefaultThreadContextMap)contextMap).putAll(map);
        } else {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                contextMap.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public static String get(String string) {
        return contextMap.get(string);
    }

    public static void remove(String string) {
        contextMap.remove(string);
    }

    public static void removeAll(Iterable<String> iterable) {
        if (contextMap instanceof CleanableThreadContextMap) {
            ((CleanableThreadContextMap)contextMap).removeAll(iterable);
        } else if (contextMap instanceof DefaultThreadContextMap) {
            ((DefaultThreadContextMap)contextMap).removeAll(iterable);
        } else {
            for (String string : iterable) {
                contextMap.remove(string);
            }
        }
    }

    public static void clearMap() {
        contextMap.clear();
    }

    public static void clearAll() {
        ThreadContext.clearMap();
        ThreadContext.clearStack();
    }

    public static boolean containsKey(String string) {
        return contextMap.containsKey(string);
    }

    public static Map<String, String> getContext() {
        return contextMap.getCopy();
    }

    public static Map<String, String> getImmutableContext() {
        Map<String, String> map = contextMap.getImmutableMapOrNull();
        return map == null ? EMPTY_MAP : map;
    }

    public static ReadOnlyThreadContextMap getThreadContextMap() {
        return readOnlyContextMap;
    }

    public static boolean isEmpty() {
        return contextMap.isEmpty();
    }

    public static void clearStack() {
        contextStack.clear();
    }

    public static ThreadContext$ContextStack cloneStack() {
        return contextStack.copy();
    }

    public static ThreadContext$ContextStack getImmutableStack() {
        ThreadContext$ContextStack threadContext$ContextStack = contextStack.getImmutableStackOrNull();
        return threadContext$ContextStack == null ? EMPTY_STACK : threadContext$ContextStack;
    }

    public static void setStack(Collection<String> collection) {
        if (collection.isEmpty() || !useStack) {
            return;
        }
        contextStack.clear();
        contextStack.addAll(collection);
    }

    public static int getDepth() {
        return contextStack.getDepth();
    }

    public static String pop() {
        return contextStack.pop();
    }

    public static String peek() {
        return contextStack.peek();
    }

    public static void push(String string) {
        contextStack.push(string);
    }

    public static void push(String string, Object ... objectArray) {
        contextStack.push(ParameterizedMessage.format(string, objectArray));
    }

    public static void removeStack() {
        contextStack.clear();
    }

    public static void trim(int n) {
        contextStack.trim(n);
    }

    static {
        ThreadContext.init();
    }
}

