/*
 * Decompiled with CFR 0.152.
 */
package com.azuriom.azauth;

import com.azuriom.azauth.AuthResult;
import com.azuriom.azauth.exception.AuthException;
import com.azuriom.azauth.gson.ColorAdapter;
import com.azuriom.azauth.gson.InstantAdapter;
import com.azuriom.azauth.gson.UuidAdapter;
import com.azuriom.azauth.model.ErrorResponse;
import com.azuriom.azauth.model.User;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class AuthClient {
    private static final Logger LOGGER = Logger.getLogger(AuthClient.class.getName());
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter((Type)((Object)Color.class), new ColorAdapter()).registerTypeAdapter((Type)((Object)Instant.class), new InstantAdapter()).registerTypeAdapter((Type)((Object)UUID.class), new UuidAdapter()).create();
    private final String url;

    public AuthClient(String string) {
        Objects.requireNonNull(string, "url");
        String string2 = this.url = string.endsWith("/") ? string.substring(0, string.length() - 1) : string;
        if (!string.startsWith("https://")) {
            LOGGER.warning("HTTP links are not secure, use HTTPS instead.");
        }
    }

    public String getUrl() {
        return this.url;
    }

    public AuthResult<User> login(String string, String string2) throws AuthException {
        return this.login(string, string2, User.class);
    }

    public AuthResult<User> login(String string, String string2, @Nullable String string3) throws AuthException {
        return this.login(string, string2, string3, User.class);
    }

    public <T> AuthResult<T> login(String string, String string2, Class<T> clazz) throws AuthException {
        return this.login(string, string2, (String)null, clazz);
    }

    public User login(String string, String string2, Supplier<String> supplier) throws AuthException {
        return this.login(string, string2, supplier, User.class);
    }

    public <T> T login(String string, String string2, Supplier<@Nullable String> supplier, Class<T> clazz) throws AuthException {
        AuthResult<T> authResult = this.login(string, string2, clazz);
        if (authResult.isSuccess()) {
            return authResult.getSuccessResult();
        }
        if (!authResult.isPending() || !authResult.asPending().require2fa()) {
            throw new AuthException("Unknown login result: " + authResult);
        }
        String string3 = supplier.get();
        if (string3 == null) {
            throw new AuthException("No 2FA code provided.");
        }
        authResult = this.login(string, string2, string3, clazz);
        if (!authResult.isSuccess()) {
            throw new AuthException("Unknown login result: " + authResult);
        }
        return authResult.getSuccessResult();
    }

    public <T> AuthResult<T> login(String string, String string2, @Nullable String string3, Class<T> clazz) throws AuthException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("email", string);
        jsonObject.addProperty("password", string2);
        jsonObject.addProperty("code", string3);
        return this.post("authenticate", jsonObject, clazz);
    }

    public User verify(String string) throws AuthException {
        return this.verify(string, User.class);
    }

    public <T> T verify(String string, Class<T> clazz) throws AuthException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("access_token", string);
        AuthResult<T> authResult = this.post("verify", jsonObject, clazz);
        if (!authResult.isSuccess()) {
            throw new AuthException("Unexpected verification result: " + authResult);
        }
        return authResult.asSuccess().getResult();
    }

    public void logout(String string) throws AuthException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("access_token", string);
        this.post("logout", jsonObject, JsonNull.class);
    }

    private <T> AuthResult<T> post(String string, JsonObject jsonObject, Class<T> clazz) throws AuthException {
        try {
            URI uRI = URI.create(this.url + "/api/auth/" + string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRI.toURL().openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.addRequestProperty("Content-Type", "application/json; charset=utf-8");
            httpURLConnection.addRequestProperty("User-Agent", "AzAuth authenticator v1");
            try (OutputStream outputStream = httpURLConnection.getOutputStream();){
                outputStream.write(jsonObject.toString().getBytes(StandardCharsets.UTF_8));
            }
            int n = httpURLConnection.getResponseCode();
            if (n >= 400 && n < 500) {
                return this.handleClientError(httpURLConnection);
            }
            return this.handleResponse(httpURLConnection, clazz);
        }
        catch (IOException iOException) {
            throw new AuthException(iOException);
        }
    }

    private <T> AuthResult<T> handleResponse(HttpURLConnection httpURLConnection, Class<@Nullable T> clazz) throws AuthException, IOException {
        if (clazz == JsonNull.class) {
            return new AuthResult.Success<T>(clazz.cast(JsonNull.INSTANCE));
        }
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));){
            T t = GSON.fromJson((Reader)bufferedReader, clazz);
            if (t == null) {
                throw new AuthException("Empty JSON response from API");
            }
            AuthResult.Success<T> success = new AuthResult.Success<T>(t);
            return success;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> AuthResult<T> handleClientError(HttpURLConnection httpURLConnection) throws AuthException, IOException {
        int n = httpURLConnection.getResponseCode();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream()));){
            ErrorResponse errorResponse = GSON.fromJson((Reader)bufferedReader, ErrorResponse.class);
            if (!errorResponse.getStatus().equals("pending")) throw new AuthException(errorResponse.getMessage());
            if (!Objects.equals(errorResponse.getReason(), "2fa")) throw new AuthException(errorResponse.getMessage());
            AuthResult.Pending pending = new AuthResult.Pending(AuthResult.Pending.Reason.REQUIRE_2FA);
            return pending;
        }
        catch (JsonParseException jsonParseException) {
            throw new AuthException("Invalid JSON response from API (HTTP " + n + ")", jsonParseException);
        }
    }
}

