/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util.internal;

import java.io.ObjectInputFilter;
import java.util.Arrays;
import java.util.List;

public class DefaultObjectInputFilter
implements ObjectInputFilter {
    private static final List<String> REQUIRED_JAVA_CLASSES = Arrays.asList("java.math.BigDecimal", "java.math.BigInteger", "java.rmi.MarshalledObject", "[B");
    private static final List<String> REQUIRED_JAVA_PACKAGES = Arrays.asList("java.lang.", "java.time", "java.util.", "org.apache.logging.log4j.", "[Lorg.apache.logging.log4j.");
    private final ObjectInputFilter delegate;

    public DefaultObjectInputFilter() {
        this.delegate = null;
    }

    public DefaultObjectInputFilter(ObjectInputFilter objectInputFilter) {
        this.delegate = objectInputFilter;
    }

    public static DefaultObjectInputFilter newInstance(ObjectInputFilter objectInputFilter) {
        return new DefaultObjectInputFilter(objectInputFilter);
    }

    @Override
    public ObjectInputFilter.Status checkInput(ObjectInputFilter.FilterInfo filterInfo) {
        String string;
        ObjectInputFilter.Status status = null;
        if (this.delegate != null && (status = this.delegate.checkInput(filterInfo)) != ObjectInputFilter.Status.UNDECIDED) {
            return status;
        }
        ObjectInputFilter objectInputFilter = ObjectInputFilter.Config.getSerialFilter();
        if (objectInputFilter != null && (status = objectInputFilter.checkInput(filterInfo)) != ObjectInputFilter.Status.UNDECIDED) {
            return status;
        }
        if (filterInfo.serialClass() != null && (DefaultObjectInputFilter.isAllowedByDefault(string = filterInfo.serialClass().getName()) || DefaultObjectInputFilter.isRequiredPackage(string))) {
            return ObjectInputFilter.Status.ALLOWED;
        }
        return ObjectInputFilter.Status.REJECTED;
    }

    private static boolean isAllowedByDefault(String string) {
        return DefaultObjectInputFilter.isRequiredPackage(string) || REQUIRED_JAVA_CLASSES.contains(string);
    }

    private static boolean isRequiredPackage(String string) {
        for (String string2 : REQUIRED_JAVA_PACKAGES) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }
}

