/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Predicate;
import org.apache.logging.log4j.util.PrivateSecurityManagerStackTraceUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class StackLocator {
    private static final StackWalker WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    private static final StackWalker STACK_WALKER = StackWalker.getInstance();
    private static final StackLocator INSTANCE = new StackLocator();

    public static StackLocator getInstance() {
        return INSTANCE;
    }

    private StackLocator() {
    }

    public Class<?> getCallerClass(Class<?> clazz, Predicate<Class<?>> predicate) {
        if (clazz == null) {
            throw new IllegalArgumentException("sentinelClass cannot be null");
        }
        if (predicate == null) {
            throw new IllegalArgumentException("callerPredicate cannot be null");
        }
        return WALKER.walk(stream -> stream.map(StackWalker.StackFrame::getDeclaringClass).dropWhile(clazz2 -> !clazz.equals(clazz2)).dropWhile(clazz2 -> clazz.equals(clazz2) || !predicate.test((Class<?>)clazz2)).findFirst().orElse(null));
    }

    public Class<?> getCallerClass(String string) {
        return this.getCallerClass(string, "");
    }

    public Class<?> getCallerClass(String string, String string2) {
        return WALKER.walk(stream -> stream.dropWhile(stackFrame -> !stackFrame.getClassName().equals(string)).dropWhile(stackFrame -> stackFrame.getClassName().equals(string)).dropWhile(stackFrame -> !stackFrame.getClassName().startsWith(string2)).findFirst()).map(StackWalker.StackFrame::getDeclaringClass).orElse(null);
    }

    public Class<?> getCallerClass(Class<?> clazz) {
        return WALKER.walk(stream -> stream.dropWhile(stackFrame -> !stackFrame.getDeclaringClass().equals(clazz)).dropWhile(stackFrame -> stackFrame.getDeclaringClass().equals(clazz)).findFirst()).map(StackWalker.StackFrame::getDeclaringClass).orElse(null);
    }

    public Class<?> getCallerClass(int n) {
        return WALKER.walk(stream -> stream.skip(n).findFirst()).map(StackWalker.StackFrame::getDeclaringClass).orElse(null);
    }

    public Deque<Class<?>> getCurrentStackTrace() {
        if (PrivateSecurityManagerStackTraceUtil.isEnabled()) {
            return PrivateSecurityManagerStackTraceUtil.getCurrentStackTrace();
        }
        ArrayDeque arrayDeque = new ArrayDeque();
        return WALKER.walk(stream -> {
            stream.forEach(stackFrame -> arrayDeque.add(stackFrame.getDeclaringClass()));
            return arrayDeque;
        });
    }

    public StackTraceElement calcLocation(String string) {
        return STACK_WALKER.walk(stream -> stream.dropWhile(stackFrame -> !stackFrame.getClassName().equals(string)).dropWhile(stackFrame -> stackFrame.getClassName().equals(string)).findFirst()).map(StackWalker.StackFrame::toStackTraceElement).orElse(null);
    }

    public StackTraceElement getStackTraceElement(int n) {
        return STACK_WALKER.walk(stream -> stream.skip(n).findFirst()).map(StackWalker.StackFrame::toStackTraceElement).orElse(null);
    }
}

