/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import pro.gravit.launcher.base.events.request.CrashReportRequestEvent;
import pro.gravit.launcher.base.request.CrashReportRequest;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.utils.helper.LogHelper;

public class CrashReportManager {
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static boolean initialized = false;
    private static Path crashReportsDir;
    private static Path sentReportsLogFile;
    private static final Set<String> sentReports;

    public static void initialize(Path path) {
        if (initialized) {
            return;
        }
        crashReportsDir = path.resolve("crash-reports");
        sentReportsLogFile = path.resolve("sent_crash_reports.log");
        initialized = true;
        try {
            if (Files.exists(sentReportsLogFile, new LinkOption[0])) {
                sentReports.addAll(Files.readAllLines(sentReportsLogFile));
            }
        }
        catch (IOException iOException) {
            LogHelper.error("Failed to load sent crash reports log: %s", iOException.getMessage());
        }
        LogHelper.info("CrashReportManager initialized, watching: %s", crashReportsDir);
        scheduler.scheduleAtFixedRate(() -> {
            try {
                CrashReportManager.checkForNewCrashes();
            }
            catch (Exception exception) {
                LogHelper.error("Error checking for new crashes: %s", exception.getMessage());
            }
        }, 30L, 30L, TimeUnit.SECONDS);
    }

    public static void shutdown() {
        if (scheduler != null && !scheduler.isShutdown()) {
            scheduler.shutdown();
            try {
                if (!scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                    scheduler.shutdownNow();
                }
            }
            catch (InterruptedException interruptedException) {
                scheduler.shutdownNow();
            }
        }
    }

    private static void checkForNewCrashes() {
        if (!initialized || !Files.exists(crashReportsDir, new LinkOption[0])) {
            return;
        }
        try {
            List list = Files.list(crashReportsDir).filter(path -> path.getFileName().toString().endsWith(".txt")).filter(path -> path.getFileName().toString().startsWith("crash-")).collect(Collectors.toList());
            for (Path path2 : list) {
                String string = path2.getFileName().toString();
                if (sentReports.contains(string)) continue;
                long l = Files.getLastModifiedTime(path2, new LinkOption[0]).toMillis();
                long l2 = System.currentTimeMillis();
                if (l2 - l < 5000L) continue;
                LogHelper.info("New crash detected: %s", string);
                CompletableFuture.runAsync(() -> {
                    try {
                        CrashReportManager.sendCrashReport(path2);
                    }
                    catch (Exception exception) {
                        LogHelper.error("Failed to send crash report: %s (%s)", path2, exception.getMessage());
                    }
                });
            }
        }
        catch (IOException iOException) {
            LogHelper.error("Error checking crash reports directory: %s", iOException.getMessage());
        }
    }

    private static void sendCrashReport(Path path) {
        block9: {
            Object object;
            if (!Request.isAvailable()) {
                LogHelper.warning("Request service not available, cannot send crash report");
                return;
            }
            String string = path.getFileName().toString();
            String string2 = Files.readString(path);
            String string3 = CrashReportManager.extractGameVersion(string2);
            String string4 = CrashReportManager.extractForgeVersion(string2);
            CrashReportRequest crashReportRequest = new CrashReportRequest(string, string2, string3, string4);
            try {
                object = new Gson();
                JsonObject jsonObject = ((Gson)object).toJsonTree(crashReportRequest).getAsJsonObject();
                jsonObject.addProperty("type", crashReportRequest.getType());
                String string5 = jsonObject.toString();
                Path path2 = crashReportsDir.getParent().resolve("crash-reports-json");
                Files.createDirectories(path2, new FileAttribute[0]);
                Path path3 = path2.resolve(string.replace(".txt", ".json"));
                Files.writeString(path3, (CharSequence)string5, new OpenOption[0]);
                LogHelper.info("Saved crash report json for diagnostics: %s", path3.toString());
            }
            catch (Exception exception) {
                LogHelper.error("Failed to save crash report json for diagnostics: %s", exception.getMessage());
            }
            try {
                object = (CrashReportRequestEvent)crashReportRequest.request();
                if (((CrashReportRequestEvent)object).success) {
                    LogHelper.info("Crash report sent successfully: %s", string);
                    sentReports.add(string);
                    try {
                        Files.writeString(sentReportsLogFile, (CharSequence)(string + "\n"), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                    }
                    catch (IOException iOException) {
                        LogHelper.error("Failed to update sent crash reports log: %s", iOException.getMessage());
                    }
                    LogHelper.info("Server response: %s", ((CrashReportRequestEvent)object).message);
                    if (((CrashReportRequestEvent)object).savedPath != null) {
                        LogHelper.info("Saved to: %s", ((CrashReportRequestEvent)object).savedPath);
                    }
                    break block9;
                }
                LogHelper.error("Failed to send crash report: %s", ((CrashReportRequestEvent)object).message);
            }
            catch (Exception exception) {
                LogHelper.error("Error sending crash report: %s", exception.getMessage());
                throw exception;
            }
        }
    }

    private static String extractGameVersion(String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.split("\n")) {
            if (!string2.trim().startsWith("Minecraft Version:")) continue;
            return string2.substring(string2.indexOf(":") + 1).trim();
        }
        return "unknown";
    }

    private static String extractForgeVersion(String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.split("\n")) {
            if (!string2.trim().startsWith("Forge:")) continue;
            String string3 = string2.substring(string2.indexOf(":") + 1).trim();
            if (string3.contains(":")) {
                return string3.substring(string3.lastIndexOf(":") + 1);
            }
            return string3;
        }
        return "unknown";
    }

    public static CompletableFuture<CrashReportRequestEvent> sendCrashReportManual(Path path) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String string = path.getFileName().toString();
                String string2 = Files.readString(path);
                String string3 = CrashReportManager.extractGameVersion(string2);
                String string4 = CrashReportManager.extractForgeVersion(string2);
                CrashReportRequest crashReportRequest = new CrashReportRequest(string, string2, string3, string4);
                return (CrashReportRequestEvent)crashReportRequest.request();
            }
            catch (Exception exception) {
                LogHelper.error("Failed to send crash report manually: %s", exception.getMessage());
                return new CrashReportRequestEvent(false, "Failed to send: " + exception.getMessage());
            }
        });
    }

    public static List<Path> getAllCrashFiles() {
        if (!initialized || !Files.exists(crashReportsDir, new LinkOption[0])) {
            return List.of();
        }
        try {
            return Files.list(crashReportsDir).filter(path -> path.getFileName().toString().endsWith(".txt")).filter(path -> path.getFileName().toString().startsWith("crash-")).sorted((path, path2) -> {
                try {
                    return Files.getLastModifiedTime(path2, new LinkOption[0]).compareTo(Files.getLastModifiedTime(path, new LinkOption[0]));
                }
                catch (IOException iOException) {
                    return 0;
                }
            }).collect(Collectors.toList());
        }
        catch (IOException iOException) {
            LogHelper.error("Error getting crash files: %s", iOException.getMessage());
            return List.of();
        }
    }

    static {
        sentReports = new HashSet<String>();
    }
}

