/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base.profiles;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.profiles.ClientProfile$ClassLoaderConfig;
import pro.gravit.launcher.base.profiles.ClientProfile$CompatibilityFlags;
import pro.gravit.launcher.base.profiles.ClientProfile$ProfileDefaultSettings;
import pro.gravit.launcher.base.profiles.ClientProfile$ServerProfile;
import pro.gravit.launcher.base.profiles.ClientProfile$Version;
import pro.gravit.launcher.base.profiles.optional.OptionalFile;
import pro.gravit.utils.launch.LaunchOptions$ModuleConf;

public class ClientProfileBuilder {
    private String title;
    private UUID uuid;
    private ClientProfile$Version version;
    private String info;
    private String dir;
    private int sortIndex;
    private String assetIndex;
    private String assetDir;
    private List<String> update;
    private List<String> updateExclusions;
    private List<String> updateVerify;
    private Set<OptionalFile> updateOptional;
    private List<String> jvmArgs;
    private List<String> classPath;
    private List<String> altClassPath;
    private List<String> clientArgs;
    private List<String> compatClasses;
    private List<String> loadNatives;
    private Map<String, String> properties;
    private List<ClientProfile$ServerProfile> servers;
    private ClientProfile$ClassLoaderConfig classLoaderConfig;
    private List<ClientProfile$CompatibilityFlags> flags;
    private int recommendJavaVersion;
    private int minJavaVersion;
    private int maxJavaVersion;
    private ClientProfile$ProfileDefaultSettings settings;
    private boolean limited;
    private String mainClass;
    private String mainModule;
    private LaunchOptions$ModuleConf moduleConf;

    public ClientProfileBuilder() {
        this.update = new ArrayList<String>();
        this.updateExclusions = new ArrayList<String>();
        this.updateVerify = new ArrayList<String>();
        this.updateOptional = new HashSet<OptionalFile>();
        this.jvmArgs = new ArrayList<String>();
        this.classPath = new ArrayList<String>();
        this.altClassPath = new ArrayList<String>();
        this.clientArgs = new ArrayList<String>();
        this.compatClasses = new ArrayList<String>();
        this.loadNatives = new ArrayList<String>();
        this.properties = new HashMap<String, String>();
        this.servers = new ArrayList<ClientProfile$ServerProfile>();
        this.flags = new ArrayList<ClientProfile$CompatibilityFlags>();
        this.settings = new ClientProfile$ProfileDefaultSettings();
        this.recommendJavaVersion = 21;
        this.minJavaVersion = 17;
        this.maxJavaVersion = 999;
        this.classLoaderConfig = ClientProfile$ClassLoaderConfig.LAUNCHER;
    }

    public ClientProfileBuilder(ClientProfile clientProfile) {
        this.title = clientProfile.getTitle();
        this.uuid = clientProfile.getUUID();
        this.version = clientProfile.getVersion();
        this.info = clientProfile.getInfo();
        this.dir = clientProfile.getDir();
        this.sortIndex = clientProfile.getSortIndex();
        this.assetIndex = clientProfile.getAssetIndex();
        this.assetDir = clientProfile.getAssetDir();
        this.update = new ArrayList<String>(clientProfile.getUpdate());
        this.updateExclusions = new ArrayList<String>(clientProfile.getUpdateExclusions());
        this.updateVerify = new ArrayList<String>(clientProfile.getUpdateVerify());
        this.updateOptional = new HashSet<OptionalFile>(clientProfile.getOptional());
        this.jvmArgs = new ArrayList<String>(clientProfile.getJvmArgs());
        this.classPath = new ArrayList<String>(clientProfile.getClassPath());
        this.altClassPath = new ArrayList<String>(clientProfile.getAlternativeClassPath());
        this.clientArgs = new ArrayList<String>(clientProfile.getClientArgs());
        this.compatClasses = new ArrayList<String>(clientProfile.getCompatClasses());
        this.loadNatives = new ArrayList<String>(clientProfile.getLoadNatives());
        this.properties = new HashMap<String, String>(clientProfile.getProperties());
        this.servers = new ArrayList<ClientProfile$ServerProfile>(clientProfile.getServers());
        this.classLoaderConfig = clientProfile.getClassLoaderConfig();
        this.flags = new ArrayList<ClientProfile$CompatibilityFlags>(clientProfile.getFlags());
        this.recommendJavaVersion = clientProfile.getRecommendJavaVersion();
        this.minJavaVersion = clientProfile.getMinJavaVersion();
        this.maxJavaVersion = clientProfile.getMaxJavaVersion();
        this.settings = clientProfile.getSettings();
        this.limited = clientProfile.isLimited();
        this.mainClass = clientProfile.getMainClass();
        this.mainModule = clientProfile.getMainModule();
        this.moduleConf = clientProfile.getModuleConf();
    }

    public ClientProfileBuilder setTitle(String string) {
        this.title = string;
        return this;
    }

    public ClientProfileBuilder setUuid(UUID uUID) {
        this.uuid = uUID;
        return this;
    }

    public ClientProfileBuilder setVersion(ClientProfile$Version clientProfile$Version) {
        this.version = clientProfile$Version;
        return this;
    }

    public ClientProfileBuilder setInfo(String string) {
        this.info = string;
        return this;
    }

    public ClientProfileBuilder setDir(String string) {
        this.dir = string;
        return this;
    }

    public ClientProfileBuilder setSortIndex(int n) {
        this.sortIndex = n;
        return this;
    }

    public ClientProfileBuilder setAssetIndex(String string) {
        this.assetIndex = string;
        return this;
    }

    public ClientProfileBuilder setAssetDir(String string) {
        this.assetDir = string;
        return this;
    }

    public ClientProfileBuilder setUpdate(List<String> list) {
        this.update = list;
        return this;
    }

    public ClientProfileBuilder update(String string) {
        this.update.add(string);
        return this;
    }

    public ClientProfileBuilder setUpdateExclusions(List<String> list) {
        this.updateExclusions = list;
        return this;
    }

    public ClientProfileBuilder updateExclusions(String string) {
        this.updateExclusions.add(string);
        return this;
    }

    public ClientProfileBuilder setUpdateVerify(List<String> list) {
        this.updateVerify = list;
        return this;
    }

    public ClientProfileBuilder updateVerify(String string) {
        this.updateVerify.add(string);
        return this;
    }

    public ClientProfileBuilder setUpdateOptional(Set<OptionalFile> set) {
        this.updateOptional = set;
        return this;
    }

    public ClientProfileBuilder updateOptional(OptionalFile optionalFile) {
        this.updateOptional.add(optionalFile);
        return this;
    }

    public ClientProfileBuilder setJvmArgs(List<String> list) {
        this.jvmArgs = list;
        return this;
    }

    public ClientProfileBuilder jvmArg(String string) {
        this.jvmArgs.add(string);
        return this;
    }

    public ClientProfileBuilder setClassPath(List<String> list) {
        this.classPath = list;
        return this;
    }

    public ClientProfileBuilder classPath(String string) {
        this.classPath.add(string);
        return this;
    }

    public ClientProfileBuilder setAltClassPath(List<String> list) {
        this.altClassPath = list;
        return this;
    }

    public ClientProfileBuilder altClassPath(String string) {
        this.altClassPath.add(string);
        return this;
    }

    public ClientProfileBuilder setClientArgs(List<String> list) {
        this.clientArgs = list;
        return this;
    }

    public ClientProfileBuilder clientArg(String string) {
        this.clientArgs.add(string);
        return this;
    }

    public ClientProfileBuilder setCompatClasses(List<String> list) {
        this.compatClasses = list;
        return this;
    }

    public ClientProfileBuilder compatClass(String string) {
        this.compatClasses.add(string);
        return this;
    }

    public ClientProfileBuilder setLoadNatives(List<String> list) {
        this.loadNatives = list;
        return this;
    }

    public ClientProfileBuilder loadNatives(String string) {
        this.loadNatives.add(string);
        return this;
    }

    public ClientProfileBuilder setProperties(Map<String, String> map) {
        this.properties = map;
        return this;
    }

    public ClientProfileBuilder property(String string, String string2) {
        this.properties.put(string, string2);
        return this;
    }

    public ClientProfileBuilder setServers(List<ClientProfile$ServerProfile> list) {
        this.servers = list;
        return this;
    }

    public ClientProfileBuilder server(ClientProfile$ServerProfile clientProfile$ServerProfile) {
        this.servers.add(clientProfile$ServerProfile);
        return this;
    }

    public ClientProfileBuilder setClassLoaderConfig(ClientProfile$ClassLoaderConfig clientProfile$ClassLoaderConfig) {
        this.classLoaderConfig = clientProfile$ClassLoaderConfig;
        return this;
    }

    public ClientProfileBuilder setFlags(List<ClientProfile$CompatibilityFlags> list) {
        this.flags = list;
        return this;
    }

    public ClientProfileBuilder flag(ClientProfile$CompatibilityFlags clientProfile$CompatibilityFlags) {
        this.flags.add(clientProfile$CompatibilityFlags);
        return this;
    }

    public ClientProfileBuilder setRecommendJavaVersion(int n) {
        this.recommendJavaVersion = n;
        return this;
    }

    public ClientProfileBuilder setMinJavaVersion(int n) {
        this.minJavaVersion = n;
        return this;
    }

    public ClientProfileBuilder setMaxJavaVersion(int n) {
        this.maxJavaVersion = n;
        return this;
    }

    public ClientProfileBuilder setSettings(ClientProfile$ProfileDefaultSettings clientProfile$ProfileDefaultSettings) {
        this.settings = clientProfile$ProfileDefaultSettings;
        return this;
    }

    public ClientProfileBuilder setLimited(boolean bl) {
        this.limited = bl;
        return this;
    }

    public ClientProfileBuilder setMainClass(String string) {
        this.mainClass = string;
        return this;
    }

    public ClientProfileBuilder setMainModule(String string) {
        this.mainModule = string;
        return this;
    }

    public ClientProfileBuilder setModuleConf(LaunchOptions$ModuleConf launchOptions$ModuleConf) {
        this.moduleConf = launchOptions$ModuleConf;
        return this;
    }

    public ClientProfile createClientProfile() {
        return new ClientProfile(this.title, this.uuid, this.version, this.info, this.dir, this.sortIndex, this.assetIndex, this.assetDir, this.update, this.updateExclusions, this.updateVerify, this.updateOptional, this.jvmArgs, this.classPath, this.altClassPath, this.clientArgs, this.compatClasses, this.loadNatives, this.properties, this.servers, this.classLoaderConfig, this.flags, this.recommendJavaVersion, this.minJavaVersion, this.maxJavaVersion, this.settings, this.limited, this.mainClass, this.mainModule, this.moduleConf);
    }
}

