/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Predicate;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.PrivateSecurityManagerStackTraceUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class StackLocator {
    static final int JDK_7U25_OFFSET;
    private static final Method GET_CALLER_CLASS_METHOD;
    private static final StackLocator INSTANCE;
    private static final Class<?> DEFAULT_CALLER_CLASS;

    public static StackLocator getInstance() {
        return INSTANCE;
    }

    private StackLocator() {
    }

    @PerformanceSensitive
    public Class<?> getCallerClass(Class<?> clazz, Predicate<Class<?>> predicate) {
        Class<?> clazz2;
        if (clazz == null) {
            throw new IllegalArgumentException("sentinelClass cannot be null");
        }
        if (predicate == null) {
            throw new IllegalArgumentException("callerPredicate cannot be null");
        }
        boolean bl = false;
        int n = 2;
        while (null != (clazz2 = this.getCallerClass(n))) {
            if (clazz.equals(clazz2)) {
                bl = true;
            } else if (bl && predicate.test(clazz2)) {
                return clazz2;
            }
            ++n;
        }
        return DEFAULT_CALLER_CLASS;
    }

    @PerformanceSensitive
    public Class<?> getCallerClass(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        if (GET_CALLER_CLASS_METHOD == null) {
            return DEFAULT_CALLER_CLASS;
        }
        try {
            return (Class)GET_CALLER_CLASS_METHOD.invoke(null, n + 1 + JDK_7U25_OFFSET);
        }
        catch (Exception exception) {
            return DEFAULT_CALLER_CLASS;
        }
    }

    @PerformanceSensitive
    public Class<?> getCallerClass(String string, String string2) {
        Class<?> clazz;
        boolean bl = false;
        int n = 2;
        while (null != (clazz = this.getCallerClass(n))) {
            if (string.equals(clazz.getName())) {
                bl = true;
            } else if (bl && clazz.getName().startsWith(string2)) {
                return clazz;
            }
            ++n;
        }
        return DEFAULT_CALLER_CLASS;
    }

    @PerformanceSensitive
    public Class<?> getCallerClass(Class<?> clazz) {
        Class<?> clazz2;
        boolean bl = false;
        int n = 2;
        while (null != (clazz2 = this.getCallerClass(n))) {
            if (clazz.equals(clazz2)) {
                bl = true;
            } else if (bl) {
                return clazz2;
            }
            ++n;
        }
        return Object.class;
    }

    @PerformanceSensitive
    public Deque<Class<?>> getCurrentStackTrace() {
        Class<?> clazz;
        if (PrivateSecurityManagerStackTraceUtil.isEnabled()) {
            return PrivateSecurityManagerStackTraceUtil.getCurrentStackTrace();
        }
        ArrayDeque arrayDeque = new ArrayDeque();
        int n = 1;
        while (null != (clazz = this.getCallerClass(n))) {
            arrayDeque.addLast(clazz);
            ++n;
        }
        return arrayDeque;
    }

    public StackTraceElement calcLocation(String string) {
        if (string == null) {
            return null;
        }
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        boolean bl = false;
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            String string2 = stackTraceElementArray[i].getClassName();
            if (string.equals(string2)) {
                bl = true;
                continue;
            }
            if (!bl || string.equals(string2)) continue;
            return stackTraceElementArray[i];
        }
        return null;
    }

    public StackTraceElement getStackTraceElement(int n) {
        int n2 = 0;
        for (StackTraceElement stackTraceElement : new Throwable().getStackTrace()) {
            if (!this.isValid(stackTraceElement)) continue;
            if (n2 == n) {
                return stackTraceElement;
            }
            ++n2;
        }
        throw new IndexOutOfBoundsException(Integer.toString(n));
    }

    private boolean isValid(StackTraceElement stackTraceElement) {
        if (stackTraceElement.isNativeMethod()) {
            return false;
        }
        String string = stackTraceElement.getClassName();
        if (string.startsWith("sun.reflect.")) {
            return false;
        }
        String string2 = stackTraceElement.getMethodName();
        if (string.startsWith("java.lang.reflect.") && (string2.equals("invoke") || string2.equals("newInstance"))) {
            return false;
        }
        if (string.startsWith("jdk.internal.reflect.")) {
            return false;
        }
        if (string.equals("java.lang.Class") && string2.equals("newInstance")) {
            return false;
        }
        return !string.equals("java.lang.invoke.MethodHandle") || !string2.startsWith("invoke");
    }

    static {
        Method method;
        DEFAULT_CALLER_CLASS = null;
        int n = 0;
        try {
            Class<?> clazz = LoaderUtil.loadClass("sun.reflect.Reflection");
            method = clazz.getDeclaredMethod("getCallerClass", Integer.TYPE);
            Object object = method.invoke(null, 0);
            method.invoke(null, 0);
            if (object == null || object != clazz) {
                method = null;
                n = -1;
            } else {
                object = method.invoke(null, 1);
                if (object == clazz) {
                    System.out.println("WARNING: Unexpected result from sun.reflect.Reflection.getCallerClass(int), adjusting offset for future calls.");
                    n = 1;
                }
            }
        }
        catch (Exception | LinkageError throwable) {
            System.out.println("WARNING: sun.reflect.Reflection.getCallerClass is not supported. This will impact performance.");
            method = null;
            n = -1;
        }
        GET_CALLER_CLASS_METHOD = method;
        JDK_7U25_OFFSET = n;
        INSTANCE = new StackLocator();
    }
}

