/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.OsgiServiceLocator;
import org.apache.logging.log4j.util.ServiceLoaderUtil$ServiceLoaderSpliterator;

public final class ServiceLoaderUtil {
    private static final int MAX_BROKEN_SERVICES = 8;

    private ServiceLoaderUtil() {
    }

    public static <T> Stream<T> loadServices(Class<T> clazz, MethodHandles.Lookup lookup) {
        return ServiceLoaderUtil.loadServices(clazz, lookup, false);
    }

    public static <T> Stream<T> loadServices(Class<T> clazz, MethodHandles.Lookup lookup, boolean bl) {
        return ServiceLoaderUtil.loadServices(clazz, lookup, bl, true);
    }

    static <T> Stream<T> loadServices(Class<T> clazz, MethodHandles.Lookup lookup, boolean bl, boolean bl2) {
        Object object;
        ClassLoader classLoader = lookup.lookupClass().getClassLoader();
        Stream<Object> stream = ServiceLoaderUtil.loadClassloaderServices(clazz, lookup, classLoader, bl2);
        if (bl && (object = LoaderUtil.getThreadContextClassLoader()) != classLoader) {
            stream = Stream.concat(stream, ServiceLoaderUtil.loadClassloaderServices(clazz, lookup, (ClassLoader)object, bl2));
        }
        if (OsgiServiceLocator.isAvailable()) {
            stream = Stream.concat(stream, OsgiServiceLocator.loadServices(clazz, lookup, bl2));
        }
        object = new HashSet();
        return stream.filter(arg_0 -> ServiceLoaderUtil.lambda$loadServices$0((Set)object, arg_0));
    }

    static <T> Stream<T> loadClassloaderServices(Class<T> clazz, MethodHandles.Lookup lookup, ClassLoader classLoader, boolean bl) {
        return StreamSupport.stream(new ServiceLoaderUtil$ServiceLoaderSpliterator<T>(clazz, lookup, classLoader, bl), false);
    }

    static <T> Iterable<T> callServiceLoader(MethodHandles.Lookup lookup, Class<T> clazz, ClassLoader classLoader, boolean bl) {
        try {
            ServiceLoader serviceLoader;
            MethodHandle methodHandle = lookup.findStatic(ServiceLoader.class, "load", MethodType.methodType(ServiceLoader.class, Class.class, ClassLoader.class));
            CallSite callSite = LambdaMetafactory.metafactory(lookup, "run", MethodType.methodType(PrivilegedAction.class, Class.class, ClassLoader.class), MethodType.methodType(Object.class), methodHandle, MethodType.methodType(ServiceLoader.class));
            PrivilegedAction privilegedAction = callSite.getTarget().bindTo(clazz).bindTo(classLoader).invoke();
            if (System.getSecurityManager() == null) {
                serviceLoader = (ServiceLoader)privilegedAction.run();
            } else {
                MethodHandle methodHandle2 = lookup.findStatic(AccessController.class, "doPrivileged", MethodType.methodType(Object.class, PrivilegedAction.class));
                serviceLoader = methodHandle2.invoke(privilegedAction);
            }
            return serviceLoader;
        }
        catch (Throwable throwable) {
            if (bl) {
                StatusLogger.getLogger().error("Unable to load services for service {}", (Object)clazz, (Object)throwable);
            }
            return Collections.emptyList();
        }
    }

    private static /* synthetic */ boolean lambda$loadServices$0(Set set, Object object) {
        return set.add(object.getClass());
    }
}

