/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PropertySource$Util {
    private static final Pattern PREFIX_PATTERN = Pattern.compile("(^log4j2?[-._/]?|^org\\.apache\\.logging\\.log4j\\.)|(?=AsyncLogger(Config)?\\.)", 2);
    private static final Pattern PROPERTY_TOKENIZER = Pattern.compile("([A-Z]*[a-z0-9]+|[A-Z0-9]+)[-._/]?");
    private static final Map<CharSequence, List<CharSequence>> CACHE = new ConcurrentHashMap<CharSequence, List<CharSequence>>();

    public static List<CharSequence> tokenize(CharSequence charSequence) {
        if (CACHE.containsKey(charSequence)) {
            return CACHE.get(charSequence);
        }
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        int n = 0;
        Matcher matcher = PREFIX_PATTERN.matcher(charSequence);
        if (matcher.find(n)) {
            n = matcher.end();
            Matcher matcher2 = PROPERTY_TOKENIZER.matcher(charSequence);
            while (matcher2.find(n)) {
                arrayList.add(matcher2.group(1).toLowerCase());
                n = matcher2.end();
            }
        }
        CACHE.put(charSequence, arrayList);
        return arrayList;
    }

    public static CharSequence joinAsCamelCase(Iterable<? extends CharSequence> iterable) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (CharSequence charSequence : iterable) {
            if (bl) {
                stringBuilder.append(charSequence);
            } else {
                stringBuilder.append(Character.toUpperCase(charSequence.charAt(0)));
                if (charSequence.length() > 1) {
                    stringBuilder.append(charSequence.subSequence(1, charSequence.length()));
                }
            }
            bl = false;
        }
        return stringBuilder.toString();
    }

    private PropertySource$Util() {
    }

    static {
        CACHE.put("disableThreadContext", Arrays.asList("disable", "thread", "context"));
        CACHE.put("disableThreadContextStack", Arrays.asList("disable", "thread", "context", "stack"));
        CACHE.put("disableThreadContextMap", Arrays.asList("disable", "thread", "context", "map"));
        CACHE.put("isThreadContextMapInheritable", Arrays.asList("is", "thread", "context", "map", "inheritable"));
    }
}

