/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.status;

import java.io.PrintStream;
import java.util.Objects;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedNoReferenceMessageFactory;
import org.apache.logging.log4j.status.SimpleLoggerFactory;
import org.apache.logging.log4j.status.StatusData;
import org.apache.logging.log4j.status.StatusListener;

public class StatusConsoleListener
implements StatusListener {
    private Level level;
    private String[] filters;
    private final PrintStream stream;
    private final Logger logger;

    public StatusConsoleListener(Level level) {
        this(level, System.out);
    }

    public StatusConsoleListener(Level level, PrintStream printStream) {
        this(level, printStream, SimpleLoggerFactory.getInstance());
    }

    StatusConsoleListener(Level level, PrintStream printStream, SimpleLoggerFactory simpleLoggerFactory) {
        this.level = Objects.requireNonNull(level, "level");
        this.stream = Objects.requireNonNull(printStream, "stream");
        this.logger = Objects.requireNonNull(simpleLoggerFactory, "loggerFactory").createSimpleLogger("StatusConsoleListener", level, ParameterizedNoReferenceMessageFactory.INSTANCE, printStream);
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    @Override
    public Level getStatusLevel() {
        return this.level;
    }

    @Override
    public void log(StatusData statusData) {
        boolean bl = this.filtered(statusData);
        if (!bl) {
            this.logger.atLevel(statusData.getLevel()).withThrowable(statusData.getThrowable()).withLocation(statusData.getStackTraceElement()).log(statusData.getMessage());
        }
    }

    public void setFilters(String ... stringArray) {
        this.filters = stringArray;
    }

    private boolean filtered(StatusData statusData) {
        if (this.filters == null) {
            return false;
        }
        String string = statusData.getStackTraceElement().getClassName();
        for (String string2 : this.filters) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        if (this.stream != System.out && this.stream != System.err) {
            this.stream.close();
        }
    }
}

