/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.util.IndexedStringMap;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.StringBuilderFormattable;
import org.apache.logging.log4j.util.StringBuilders;

enum MapMessageJsonFormatter {

    public static final int MAX_DEPTH = MapMessageJsonFormatter.readMaxDepth();
    private static final char DQUOTE = '\"';
    private static final char RBRACE = ']';
    private static final char LBRACE = '[';
    private static final char COMMA = ',';
    private static final char RCURLY = '}';
    private static final char LCURLY = '{';
    private static final char COLON = ':';

    private static int readMaxDepth() {
        int n = PropertiesUtil.getProperties().getIntegerProperty("log4j2.mapMessage.jsonFormatter.maxDepth", 8);
        if (n < 0) {
            throw new IllegalArgumentException("was expecting a positive maxDepth, found: " + n);
        }
        return n;
    }

    static void format(StringBuilder stringBuilder, Object object) {
        MapMessageJsonFormatter.format(stringBuilder, object, 0);
    }

    private static void format(StringBuilder stringBuilder, Object object, int n) {
        if (n >= MAX_DEPTH) {
            throw new IllegalArgumentException("maxDepth has been exceeded");
        }
        if (object == null) {
            stringBuilder.append("null");
        } else if (object instanceof IndexedStringMap) {
            IndexedStringMap indexedStringMap = (IndexedStringMap)object;
            MapMessageJsonFormatter.formatIndexedStringMap(stringBuilder, indexedStringMap, n);
        } else if (object instanceof Map) {
            Map map = (Map)object;
            MapMessageJsonFormatter.formatMap(stringBuilder, map, n);
        } else if (object instanceof List) {
            List list = (List)object;
            MapMessageJsonFormatter.formatList(stringBuilder, list, n);
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            MapMessageJsonFormatter.formatCollection(stringBuilder, collection, n);
        } else if (object instanceof Number) {
            Number number = (Number)object;
            MapMessageJsonFormatter.formatNumber(stringBuilder, number);
        } else if (object instanceof Boolean) {
            boolean bl = (Boolean)object;
            MapMessageJsonFormatter.formatBoolean(stringBuilder, bl);
        } else if (object instanceof StringBuilderFormattable) {
            StringBuilderFormattable stringBuilderFormattable = (StringBuilderFormattable)object;
            MapMessageJsonFormatter.formatFormattable(stringBuilder, stringBuilderFormattable);
        } else if (object instanceof char[]) {
            char[] cArray = (char[])object;
            MapMessageJsonFormatter.formatCharArray(stringBuilder, cArray);
        } else if (object instanceof boolean[]) {
            boolean[] blArray = (boolean[])object;
            MapMessageJsonFormatter.formatBooleanArray(stringBuilder, blArray);
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            MapMessageJsonFormatter.formatByteArray(stringBuilder, byArray);
        } else if (object instanceof short[]) {
            short[] sArray = (short[])object;
            MapMessageJsonFormatter.formatShortArray(stringBuilder, sArray);
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            MapMessageJsonFormatter.formatIntArray(stringBuilder, nArray);
        } else if (object instanceof long[]) {
            long[] lArray = (long[])object;
            MapMessageJsonFormatter.formatLongArray(stringBuilder, lArray);
        } else if (object instanceof float[]) {
            float[] fArray = (float[])object;
            MapMessageJsonFormatter.formatFloatArray(stringBuilder, fArray);
        } else if (object instanceof double[]) {
            double[] dArray = (double[])object;
            MapMessageJsonFormatter.formatDoubleArray(stringBuilder, dArray);
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            MapMessageJsonFormatter.formatObjectArray(stringBuilder, objectArray, n);
        } else {
            MapMessageJsonFormatter.formatString(stringBuilder, object);
        }
    }

    private static void formatIndexedStringMap(StringBuilder stringBuilder, IndexedStringMap indexedStringMap, int n) {
        stringBuilder.append('{');
        int n2 = n + 1;
        for (int i = 0; i < indexedStringMap.size(); ++i) {
            String string = indexedStringMap.getKeyAt(i);
            Object v = indexedStringMap.getValueAt(i);
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append('\"');
            int n3 = stringBuilder.length();
            stringBuilder.append(string);
            StringBuilders.escapeJson(stringBuilder, n3);
            stringBuilder.append('\"').append(':');
            MapMessageJsonFormatter.format(stringBuilder, v, n2);
        }
        stringBuilder.append('}');
    }

    private static void formatMap(StringBuilder stringBuilder, Map<Object, Object> map, int n) {
        stringBuilder.append('{');
        int n2 = n + 1;
        boolean[] blArray = new boolean[]{true};
        map.forEach((object, object2) -> {
            if (object == null) {
                throw new IllegalArgumentException("null keys are not allowed");
            }
            if (blArray[0]) {
                blArray[0] = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append('\"');
            String string = String.valueOf(object);
            int n2 = stringBuilder.length();
            stringBuilder.append(string);
            StringBuilders.escapeJson(stringBuilder, n2);
            stringBuilder.append('\"').append(':');
            MapMessageJsonFormatter.format(stringBuilder, object2, n2);
        });
        stringBuilder.append('}');
    }

    private static void formatList(StringBuilder stringBuilder, List<Object> list, int n) {
        stringBuilder.append('[');
        int n2 = n + 1;
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            Object object = list.get(i);
            MapMessageJsonFormatter.format(stringBuilder, object, n2);
        }
        stringBuilder.append(']');
    }

    private static void formatCollection(StringBuilder stringBuilder, Collection<Object> collection, int n) {
        stringBuilder.append('[');
        int n2 = n + 1;
        boolean[] blArray = new boolean[]{true};
        collection.forEach(object -> {
            if (blArray[0]) {
                blArray[0] = false;
            } else {
                stringBuilder.append(',');
            }
            MapMessageJsonFormatter.format(stringBuilder, object, n2);
        });
        stringBuilder.append(']');
    }

    private static void formatNumber(StringBuilder stringBuilder, Number number) {
        if (number instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)number;
            stringBuilder.append(bigDecimal.toString());
        } else if (number instanceof Double) {
            double d = (Double)number;
            stringBuilder.append(d);
        } else if (number instanceof Float) {
            float f = ((Float)number).floatValue();
            stringBuilder.append(f);
        } else if (number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof Long) {
            long l = number.longValue();
            stringBuilder.append(l);
        } else {
            double d;
            long l = number.longValue();
            if (Double.compare(l, d = number.doubleValue()) == 0) {
                stringBuilder.append(l);
            } else {
                stringBuilder.append(d);
            }
        }
    }

    private static void formatBoolean(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append(bl);
    }

    private static void formatFormattable(StringBuilder stringBuilder, StringBuilderFormattable stringBuilderFormattable) {
        stringBuilder.append('\"');
        int n = stringBuilder.length();
        stringBuilderFormattable.formatTo(stringBuilder);
        StringBuilders.escapeJson(stringBuilder, n);
        stringBuilder.append('\"');
    }

    private static void formatCharArray(StringBuilder stringBuilder, char[] cArray) {
        stringBuilder.append('[');
        for (int i = 0; i < cArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            char c = cArray[i];
            stringBuilder.append('\"');
            int n = stringBuilder.length();
            stringBuilder.append(c);
            StringBuilders.escapeJson(stringBuilder, n);
            stringBuilder.append('\"');
        }
        stringBuilder.append(']');
    }

    private static void formatBooleanArray(StringBuilder stringBuilder, boolean[] blArray) {
        stringBuilder.append('[');
        for (int i = 0; i < blArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            boolean bl = blArray[i];
            stringBuilder.append(bl);
        }
        stringBuilder.append(']');
    }

    private static void formatByteArray(StringBuilder stringBuilder, byte[] byArray) {
        stringBuilder.append('[');
        for (int i = 0; i < byArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            byte by = byArray[i];
            stringBuilder.append(by);
        }
        stringBuilder.append(']');
    }

    private static void formatShortArray(StringBuilder stringBuilder, short[] sArray) {
        stringBuilder.append('[');
        for (int i = 0; i < sArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            short s = sArray[i];
            stringBuilder.append(s);
        }
        stringBuilder.append(']');
    }

    private static void formatIntArray(StringBuilder stringBuilder, int[] nArray) {
        stringBuilder.append('[');
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            int n = nArray[i];
            stringBuilder.append(n);
        }
        stringBuilder.append(']');
    }

    private static void formatLongArray(StringBuilder stringBuilder, long[] lArray) {
        stringBuilder.append('[');
        for (int i = 0; i < lArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            long l = lArray[i];
            stringBuilder.append(l);
        }
        stringBuilder.append(']');
    }

    private static void formatFloatArray(StringBuilder stringBuilder, float[] fArray) {
        stringBuilder.append('[');
        for (int i = 0; i < fArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            float f = fArray[i];
            stringBuilder.append(f);
        }
        stringBuilder.append(']');
    }

    private static void formatDoubleArray(StringBuilder stringBuilder, double[] dArray) {
        stringBuilder.append('[');
        for (int i = 0; i < dArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            double d = dArray[i];
            stringBuilder.append(d);
        }
        stringBuilder.append(']');
    }

    private static void formatObjectArray(StringBuilder stringBuilder, Object[] objectArray, int n) {
        stringBuilder.append('[');
        int n2 = n + 1;
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            Object object = objectArray[i];
            MapMessageJsonFormatter.format(stringBuilder, object, n2);
        }
        stringBuilder.append(']');
    }

    private static void formatString(StringBuilder stringBuilder, Object object) {
        stringBuilder.append('\"');
        int n = stringBuilder.length();
        String string = String.valueOf(object);
        stringBuilder.append(string);
        StringBuilders.escapeJson(stringBuilder, n);
        stringBuilder.append('\"');
    }
}

