/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.message.AsynchronouslyFormattable;
import org.apache.logging.log4j.message.MapMessage$MapFormat;
import org.apache.logging.log4j.message.MapMessageJsonFormatter;
import org.apache.logging.log4j.message.ParameterFormatter;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.EnglishEnums;
import org.apache.logging.log4j.util.IndexedReadOnlyStringMap;
import org.apache.logging.log4j.util.IndexedStringMap;
import org.apache.logging.log4j.util.MultiFormatStringBuilderFormattable;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.StringBuilders;
import org.apache.logging.log4j.util.TriConsumer;

@AsynchronouslyFormattable
@PerformanceSensitive(value={"allocation"})
public class MapMessage<M extends MapMessage<M, V>, V>
implements MultiFormatStringBuilderFormattable {
    private static final long serialVersionUID = -5031471831131487120L;
    private final IndexedStringMap data;

    public MapMessage() {
        this.data = new SortedArrayStringMap();
    }

    public MapMessage(int n) {
        this.data = new SortedArrayStringMap(n);
    }

    public MapMessage(Map<String, V> map) {
        this.data = new SortedArrayStringMap(map);
    }

    @Override
    public String[] getFormats() {
        return MapMessage$MapFormat.names();
    }

    @Override
    public Object[] getParameters() {
        Object[] objectArray = new Object[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            objectArray[i] = this.data.getValueAt(i);
        }
        return objectArray;
    }

    @Override
    public String getFormat() {
        return "";
    }

    public Map<String, V> getData() {
        TreeMap treeMap = new TreeMap();
        for (int i = 0; i < this.data.size(); ++i) {
            treeMap.put(this.data.getKeyAt(i), this.data.getValueAt(i));
        }
        return Collections.unmodifiableMap(treeMap);
    }

    public IndexedReadOnlyStringMap getIndexedReadOnlyStringMap() {
        return this.data;
    }

    public void clear() {
        this.data.clear();
    }

    public boolean containsKey(String string) {
        return this.data.containsKey(string);
    }

    public void put(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("No value provided for key " + string);
        }
        String string3 = this.toKey(string);
        this.validate(string3, string2);
        this.data.putValue(string3, string2);
    }

    public void putAll(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.data.putValue(entry.getKey(), entry.getValue());
        }
    }

    public String get(String string) {
        Object v = this.data.getValue(string);
        return ParameterFormatter.deepToString(v);
    }

    public String remove(String string) {
        String string2 = this.get(string);
        this.data.remove(string);
        return string2;
    }

    public String asString() {
        return this.format(null, new StringBuilder()).toString();
    }

    public String asString(String string) {
        try {
            return this.format(EnglishEnums.valueOf(MapMessage$MapFormat.class, string), new StringBuilder()).toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.asString();
        }
    }

    public <CV> void forEach(BiConsumer<String, ? super CV> biConsumer) {
        this.data.forEach(biConsumer);
    }

    public <CV, S> void forEach(TriConsumer<String, ? super CV, S> triConsumer, S s) {
        this.data.forEach(triConsumer, s);
    }

    private StringBuilder format(MapMessage$MapFormat mapMessage$MapFormat, StringBuilder stringBuilder) {
        if (mapMessage$MapFormat == null) {
            this.appendMap(stringBuilder);
        } else {
            switch (mapMessage$MapFormat) {
                case XML: {
                    this.asXml(stringBuilder);
                    break;
                }
                case JSON: {
                    this.asJson(stringBuilder);
                    break;
                }
                case JAVA: {
                    this.asJava(stringBuilder);
                    break;
                }
                case JAVA_UNQUOTED: {
                    this.asJavaUnquoted(stringBuilder);
                    break;
                }
                default: {
                    this.appendMap(stringBuilder);
                }
            }
        }
        return stringBuilder;
    }

    public void asXml(StringBuilder stringBuilder) {
        stringBuilder.append("<Map>\n");
        for (int i = 0; i < this.data.size(); ++i) {
            stringBuilder.append("  <Entry key=\"").append(this.data.getKeyAt(i)).append("\">");
            int n = stringBuilder.length();
            ParameterFormatter.recursiveDeepToString(this.data.getValueAt(i), stringBuilder);
            StringBuilders.escapeXml(stringBuilder, n);
            stringBuilder.append("</Entry>\n");
        }
        stringBuilder.append("</Map>");
    }

    @Override
    public String getFormattedMessage() {
        return this.asString();
    }

    @Override
    public String getFormattedMessage(String[] stringArray) {
        return this.format(this.getFormat(stringArray), new StringBuilder()).toString();
    }

    private MapMessage$MapFormat getFormat(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            MapMessage$MapFormat mapMessage$MapFormat = MapMessage$MapFormat.lookupIgnoreCase(stringArray[i]);
            if (mapMessage$MapFormat == null) continue;
            return mapMessage$MapFormat;
        }
        return null;
    }

    protected void appendMap(StringBuilder stringBuilder) {
        for (int i = 0; i < this.data.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.data.getKeyAt(i)).append('=').append('\"');
            ParameterFormatter.recursiveDeepToString(this.data.getValueAt(i), stringBuilder);
            stringBuilder.append('\"');
        }
    }

    protected void asJson(StringBuilder stringBuilder) {
        MapMessageJsonFormatter.format(stringBuilder, this.data);
    }

    protected void asJavaUnquoted(StringBuilder stringBuilder) {
        this.asJava(stringBuilder, false);
    }

    protected void asJava(StringBuilder stringBuilder) {
        this.asJava(stringBuilder, true);
    }

    private void asJava(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append('{');
        for (int i = 0; i < this.data.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.data.getKeyAt(i)).append('=');
            if (bl) {
                stringBuilder.append('\"');
            }
            ParameterFormatter.recursiveDeepToString(this.data.getValueAt(i), stringBuilder);
            if (!bl) continue;
            stringBuilder.append('\"');
        }
        stringBuilder.append('}');
    }

    public M newInstance(Map<String, V> map) {
        return (M)new MapMessage<M, V>(map);
    }

    public String toString() {
        return this.asString();
    }

    @Override
    public void formatTo(StringBuilder stringBuilder) {
        this.format(null, stringBuilder);
    }

    @Override
    public void formatTo(String[] stringArray, StringBuilder stringBuilder) {
        this.format(this.getFormat(stringArray), stringBuilder);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MapMessage mapMessage = (MapMessage)object;
        return this.data.equals(mapMessage.data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    @Override
    public Throwable getThrowable() {
        return null;
    }

    protected void validate(String string, boolean bl) {
    }

    protected void validate(String string, byte by) {
    }

    protected void validate(String string, char c) {
    }

    protected void validate(String string, double d) {
    }

    protected void validate(String string, float f) {
    }

    protected void validate(String string, int n) {
    }

    protected void validate(String string, long l) {
    }

    protected void validate(String string, Object object) {
    }

    protected void validate(String string, short s) {
    }

    protected void validate(String string, String string2) {
    }

    protected String toKey(String string) {
        return string;
    }

    public M with(String string, boolean bl) {
        String string2 = this.toKey(string);
        this.validate(string2, bl);
        this.data.putValue(string2, bl);
        return (M)this;
    }

    public M with(String string, byte by) {
        String string2 = this.toKey(string);
        this.validate(string2, by);
        this.data.putValue(string2, by);
        return (M)this;
    }

    public M with(String string, char c) {
        String string2 = this.toKey(string);
        this.validate(string2, c);
        this.data.putValue(string2, Character.valueOf(c));
        return (M)this;
    }

    public M with(String string, double d) {
        String string2 = this.toKey(string);
        this.validate(string2, d);
        this.data.putValue(string2, d);
        return (M)this;
    }

    public M with(String string, float f) {
        String string2 = this.toKey(string);
        this.validate(string2, f);
        this.data.putValue(string2, Float.valueOf(f));
        return (M)this;
    }

    public M with(String string, int n) {
        String string2 = this.toKey(string);
        this.validate(string2, n);
        this.data.putValue(string2, n);
        return (M)this;
    }

    public M with(String string, long l) {
        String string2 = this.toKey(string);
        this.validate(string2, l);
        this.data.putValue(string2, l);
        return (M)this;
    }

    public M with(String string, Object object) {
        String string2 = this.toKey(string);
        this.validate(string2, object);
        this.data.putValue(string2, object);
        return (M)this;
    }

    public M with(String string, short s) {
        String string2 = this.toKey(string);
        this.validate(string2, s);
        this.data.putValue(string2, s);
        return (M)this;
    }

    public M with(String string, String string2) {
        String string3 = this.toKey(string);
        this.put(string3, string2);
        return (M)this;
    }
}

