/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.io.Serializable;
import org.apache.logging.log4j.message.DefaultFlowMessageFactory$SimpleEntryMessage;
import org.apache.logging.log4j.message.DefaultFlowMessageFactory$SimpleExitMessage;
import org.apache.logging.log4j.message.EntryMessage;
import org.apache.logging.log4j.message.ExitMessage;
import org.apache.logging.log4j.message.FlowMessageFactory;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.ReusableMessage;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.util.Strings;

public class DefaultFlowMessageFactory
implements Serializable,
FlowMessageFactory {
    private static final String EXIT_DEFAULT_PREFIX = "Exit";
    private static final String ENTRY_DEFAULT_PREFIX = "Enter";
    private static final long serialVersionUID = 8578655591131397576L;
    private final String entryText;
    private final String exitText;
    private final MessageFactory messageFactory;

    public DefaultFlowMessageFactory() {
        this(ENTRY_DEFAULT_PREFIX, EXIT_DEFAULT_PREFIX);
    }

    public DefaultFlowMessageFactory(String string, String string2) {
        this.entryText = string;
        this.exitText = string2;
        this.messageFactory = DefaultFlowMessageFactory.createDefaultMessageFactory();
    }

    private static MessageFactory createDefaultMessageFactory() {
        try {
            return AbstractLogger.DEFAULT_MESSAGE_FACTORY_CLASS.newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new IllegalStateException(reflectiveOperationException);
        }
    }

    public String getEntryText() {
        return this.entryText;
    }

    public String getExitText() {
        return this.exitText;
    }

    @Override
    public EntryMessage newEntryMessage(String string, Object ... objectArray) {
        Message message;
        boolean bl = Strings.isNotEmpty(string);
        if (objectArray == null || objectArray.length == 0) {
            message = bl ? this.messageFactory.newMessage(string) : null;
        } else if (bl) {
            message = this.messageFactory.newMessage(string, objectArray);
        } else {
            StringBuilder stringBuilder = new StringBuilder("params(");
            for (int i = 0; i < objectArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("{}");
            }
            stringBuilder.append(")");
            message = this.messageFactory.newMessage(stringBuilder.toString(), objectArray);
        }
        return this.newEntryMessage(message);
    }

    @Override
    public EntryMessage newEntryMessage(Message message) {
        return new DefaultFlowMessageFactory$SimpleEntryMessage(this.entryText, this.makeImmutable(message));
    }

    private Message makeImmutable(Message message) {
        if (message instanceof ReusableMessage) {
            return ((ReusableMessage)message).memento();
        }
        return message;
    }

    @Override
    public ExitMessage newExitMessage(String string, Object object) {
        boolean bl = Strings.isNotEmpty(string);
        Message message = object == null ? (bl ? this.messageFactory.newMessage(string) : null) : this.messageFactory.newMessage(bl ? string : "with({})", object);
        return this.newExitMessage(message);
    }

    @Override
    public ExitMessage newExitMessage(Message message) {
        return new DefaultFlowMessageFactory$SimpleExitMessage(this.exitText, message);
    }

    @Override
    public ExitMessage newExitMessage(EntryMessage entryMessage) {
        return new DefaultFlowMessageFactory$SimpleExitMessage(this.exitText, entryMessage);
    }

    @Override
    public ExitMessage newExitMessage(Object object, EntryMessage entryMessage) {
        return new DefaultFlowMessageFactory$SimpleExitMessage(this.exitText, object, entryMessage);
    }

    @Override
    public ExitMessage newExitMessage(Object object, Message message) {
        return new DefaultFlowMessageFactory$SimpleExitMessage(this.exitText, object, message);
    }
}

