/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.net.UrlConnectionFactory;
import org.apache.logging.log4j.core.net.ssl.SslConfigurationFactory;
import org.apache.logging.log4j.core.util.AuthorizationProvider;
import org.apache.logging.log4j.core.util.internal.HttpInputStreamUtil$Result;
import org.apache.logging.log4j.core.util.internal.LastModifiedSource;
import org.apache.logging.log4j.core.util.internal.Status;
import org.apache.logging.log4j.status.StatusLogger;

public final class HttpInputStreamUtil {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final int NOT_MODIFIED = 304;
    private static final int NOT_AUTHORIZED = 401;
    private static final int NOT_FOUND = 404;
    private static final int OK = 200;
    private static final int BUF_SIZE = 1024;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HttpInputStreamUtil$Result getInputStream(LastModifiedSource lastModifiedSource, AuthorizationProvider authorizationProvider) {
        HttpInputStreamUtil$Result httpInputStreamUtil$Result = new HttpInputStreamUtil$Result();
        try {
            long l = lastModifiedSource.getLastModified();
            HttpURLConnection httpURLConnection = (HttpURLConnection)UrlConnectionFactory.createConnection(lastModifiedSource.getURI().toURL(), l, SslConfigurationFactory.getSslConfiguration(), authorizationProvider);
            httpURLConnection.connect();
            try {
                int n = httpURLConnection.getResponseCode();
                switch (n) {
                    case 304: {
                        LOGGER.debug("Configuration not modified");
                        HttpInputStreamUtil$Result.access$002(httpInputStreamUtil$Result, Status.NOT_MODIFIED);
                        HttpInputStreamUtil$Result httpInputStreamUtil$Result2 = httpInputStreamUtil$Result;
                        return httpInputStreamUtil$Result2;
                    }
                    case 404: {
                        LOGGER.debug("Unable to access {}: Not Found", (Object)lastModifiedSource.toString());
                        HttpInputStreamUtil$Result.access$002(httpInputStreamUtil$Result, Status.NOT_FOUND);
                        HttpInputStreamUtil$Result httpInputStreamUtil$Result3 = httpInputStreamUtil$Result;
                        return httpInputStreamUtil$Result3;
                    }
                    case 200: {
                        InputStream inputStream = httpURLConnection.getInputStream();
                        Object object = null;
                        try {
                            lastModifiedSource.setLastModified(httpURLConnection.getLastModified());
                            LOGGER.debug("Content was modified for {}. previous lastModified: {}, new lastModified: {}", (Object)lastModifiedSource.toString(), (Object)l, (Object)httpURLConnection.getLastModified());
                            HttpInputStreamUtil$Result.access$002(httpInputStreamUtil$Result, Status.SUCCESS);
                            HttpInputStreamUtil$Result.access$102(httpInputStreamUtil$Result, new ByteArrayInputStream(HttpInputStreamUtil.readStream(inputStream)));
                            HttpInputStreamUtil$Result httpInputStreamUtil$Result4 = httpInputStreamUtil$Result;
                            return httpInputStreamUtil$Result4;
                        }
                        catch (Throwable throwable) {
                            try {
                                object = throwable;
                                throw throwable;
                            }
                            catch (IOException iOException) {
                                try {
                                    object = httpURLConnection.getErrorStream();
                                    Throwable throwable2 = null;
                                    try {
                                        LOGGER.info("Error accessing configuration at {}: {}", (Object)lastModifiedSource.toString(), (Object)HttpInputStreamUtil.readStream((InputStream)object));
                                        throw new ConfigurationException("Unable to access " + lastModifiedSource.toString(), iOException);
                                    }
                                    catch (Throwable throwable3) {
                                        throwable2 = throwable3;
                                        throw throwable3;
                                    }
                                    finally {
                                        if (object != null) {
                                            if (throwable2 != null) {
                                                try {
                                                    ((InputStream)object).close();
                                                }
                                                catch (Throwable throwable4) {
                                                    throwable2.addSuppressed(throwable4);
                                                }
                                            } else {
                                                ((InputStream)object).close();
                                            }
                                        }
                                    }
                                }
                                catch (IOException iOException2) {
                                    LOGGER.error("Error accessing configuration at {}: {}", (Object)lastModifiedSource.toString(), (Object)iOException.getMessage());
                                }
                                throw new ConfigurationException("Unable to access " + lastModifiedSource.toString(), iOException);
                            }
                        }
                        finally {
                            if (inputStream != null) {
                                if (object != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)object).addSuppressed(throwable);
                                    }
                                } else {
                                    inputStream.close();
                                }
                            }
                        }
                    }
                    case 401: {
                        throw new ConfigurationException("Authorization failed");
                    }
                }
                if (n < 0) {
                    LOGGER.info("Invalid response code returned");
                    throw new ConfigurationException("Unable to access " + lastModifiedSource.toString());
                }
                LOGGER.info("Unexpected response code returned {}", (Object)n);
                throw new ConfigurationException("Unable to access " + lastModifiedSource.toString());
            }
            finally {
                httpURLConnection.disconnect();
            }
        }
        catch (IOException iOException) {
            LOGGER.warn("Error accessing {}: {}", (Object)lastModifiedSource.toString(), (Object)iOException.getMessage());
            throw new ConfigurationException("Unable to access " + lastModifiedSource.toString(), iOException);
        }
    }

    public static byte[] readStream(InputStream inputStream) {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

