/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util.datetime;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.core.util.datetime.FastDateFormat;
import org.apache.logging.log4j.core.util.datetime.FixedDateFormat$FixedFormat;
import org.apache.logging.log4j.core.util.datetime.FixedDateFormat$FixedTimeZoneFormat;

public class FixedDateFormat {
    private static final char NONE = '\u0000';
    private final FixedDateFormat$FixedFormat fixedFormat;
    private final TimeZone timeZone;
    private final int length;
    private final int secondFractionDigits;
    private final FastDateFormat fastDateFormat;
    private final char timeSeparatorChar;
    private final char millisSeparatorChar;
    private final int timeSeparatorLength;
    private final int millisSeparatorLength;
    private final FixedDateFormat$FixedTimeZoneFormat fixedTimeZoneFormat;
    private volatile long midnightToday;
    private volatile long midnightTomorrow;
    private final int[] dstOffsets = new int[25];
    private char[] cachedDate;
    private int dateLength;
    static int[] TABLE = new int[]{100000, 10000, 1000, 100, 10, 1};

    FixedDateFormat(FixedDateFormat$FixedFormat fixedDateFormat$FixedFormat, TimeZone timeZone) {
        this(fixedDateFormat$FixedFormat, timeZone, fixedDateFormat$FixedFormat.getSecondFractionDigits());
    }

    FixedDateFormat(FixedDateFormat$FixedFormat fixedDateFormat$FixedFormat, TimeZone timeZone, int n) {
        this.fixedFormat = Objects.requireNonNull(fixedDateFormat$FixedFormat);
        this.timeZone = Objects.requireNonNull(timeZone);
        this.timeSeparatorChar = FixedDateFormat$FixedFormat.access$000(fixedDateFormat$FixedFormat);
        this.timeSeparatorLength = FixedDateFormat$FixedFormat.access$100(fixedDateFormat$FixedFormat);
        this.millisSeparatorChar = FixedDateFormat$FixedFormat.access$200(fixedDateFormat$FixedFormat);
        this.millisSeparatorLength = FixedDateFormat$FixedFormat.access$300(fixedDateFormat$FixedFormat);
        this.fixedTimeZoneFormat = FixedDateFormat$FixedFormat.access$400(fixedDateFormat$FixedFormat);
        this.length = fixedDateFormat$FixedFormat.getLength();
        this.secondFractionDigits = Math.max(1, Math.min(9, n));
        this.fastDateFormat = fixedDateFormat$FixedFormat.getFastDateFormat(timeZone);
    }

    public static FixedDateFormat createIfSupported(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0 || stringArray[0] == null) {
            return new FixedDateFormat(FixedDateFormat$FixedFormat.DEFAULT, TimeZone.getDefault());
        }
        TimeZone timeZone = stringArray.length > 1 ? (stringArray[1] != null ? TimeZone.getTimeZone(stringArray[1]) : TimeZone.getDefault()) : TimeZone.getDefault();
        String string = stringArray[0];
        FixedDateFormat$FixedFormat fixedDateFormat$FixedFormat = FixedDateFormat$FixedFormat.lookupIgnoringNanos(string);
        if (fixedDateFormat$FixedFormat != null) {
            int[] nArray = FixedDateFormat$FixedFormat.access$500(string);
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = n2 - n;
            return new FixedDateFormat(fixedDateFormat$FixedFormat, timeZone, n3);
        }
        FixedDateFormat$FixedFormat fixedDateFormat$FixedFormat2 = FixedDateFormat$FixedFormat.lookup(string);
        return fixedDateFormat$FixedFormat2 == null ? null : new FixedDateFormat(fixedDateFormat$FixedFormat2, timeZone);
    }

    public static FixedDateFormat create(FixedDateFormat$FixedFormat fixedDateFormat$FixedFormat) {
        return new FixedDateFormat(fixedDateFormat$FixedFormat, TimeZone.getDefault());
    }

    public static FixedDateFormat create(FixedDateFormat$FixedFormat fixedDateFormat$FixedFormat, TimeZone timeZone) {
        return new FixedDateFormat(fixedDateFormat$FixedFormat, timeZone != null ? timeZone : TimeZone.getDefault());
    }

    public String getFormat() {
        return this.fixedFormat.getPattern();
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public long millisSinceMidnight(long l) {
        if (l >= this.midnightTomorrow || l < this.midnightToday) {
            this.updateMidnightMillis(l);
        }
        return l - this.midnightToday;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMidnightMillis(long l) {
        if (l >= this.midnightTomorrow || l < this.midnightToday) {
            FixedDateFormat fixedDateFormat = this;
            synchronized (fixedDateFormat) {
                this.updateCachedDate(l);
                this.midnightToday = this.calcMidnightMillis(l, 0);
                this.midnightTomorrow = this.calcMidnightMillis(l, 1);
                this.updateDaylightSavingTime();
            }
        }
    }

    private long calcMidnightMillis(long l, int n) {
        Calendar calendar = Calendar.getInstance(this.timeZone);
        calendar.setTimeInMillis(l);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(5, n);
        return calendar.getTimeInMillis();
    }

    private void updateDaylightSavingTime() {
        Arrays.fill(this.dstOffsets, 0);
        int n = (int)TimeUnit.HOURS.toMillis(1L);
        if (this.timeZone.getOffset(this.midnightToday) != this.timeZone.getOffset(this.midnightToday + (long)(23 * n))) {
            int n2;
            for (n2 = 0; n2 < this.dstOffsets.length; ++n2) {
                long l = this.midnightToday + (long)(n2 * n);
                this.dstOffsets[n2] = this.timeZone.getOffset(l) - this.timeZone.getRawOffset();
            }
            if (this.dstOffsets[0] > this.dstOffsets[23]) {
                n2 = this.dstOffsets.length - 1;
                while (n2 >= 0) {
                    int n3 = n2--;
                    this.dstOffsets[n3] = this.dstOffsets[n3] - this.dstOffsets[0];
                }
            }
        }
    }

    private void updateCachedDate(long l) {
        if (this.fastDateFormat != null) {
            StringBuilder stringBuilder = this.fastDateFormat.format(l, new StringBuilder());
            this.cachedDate = stringBuilder.toString().toCharArray();
            this.dateLength = stringBuilder.length();
        }
    }

    public String formatInstant(Instant instant) {
        char[] cArray = new char[this.length << 1];
        int n = this.formatInstant(instant, cArray, 0);
        return new String(cArray, 0, n);
    }

    public int formatInstant(Instant instant, char[] cArray, int n) {
        long l = instant.getEpochMillisecond();
        int n2 = this.format(l, cArray, n);
        int n3 = this.formatNanoOfMillisecond(instant.getNanoOfMillisecond(), cArray, n + (n2 -= this.digitsLessThanThree()));
        return this.writeTimeZone(l, cArray, n3);
    }

    private int digitsLessThanThree() {
        return Math.max(0, FixedDateFormat$FixedFormat.access$600() - this.secondFractionDigits);
    }

    public String format(long l) {
        char[] cArray = new char[this.length << 1];
        int n = this.format(l, cArray, 0);
        return new String(cArray, 0, n);
    }

    public int format(long l, char[] cArray, int n) {
        int n2 = (int)this.millisSinceMidnight(l);
        this.writeDate(cArray, n);
        int n3 = this.writeTime(n2, cArray, n + this.dateLength);
        return n3 - n;
    }

    private void writeDate(char[] cArray, int n) {
        if (this.cachedDate != null) {
            System.arraycopy(this.cachedDate, 0, cArray, n, this.dateLength);
        }
    }

    private int writeTime(int n, char[] cArray, int n2) {
        int n3 = n / 3600000;
        int n4 = n3 + this.daylightSavingTime(n3) / 3600000;
        int n5 = (n -= 3600000 * n3) / 60000;
        int n6 = (n -= 60000 * n5) / 1000;
        n -= 1000 * n6;
        int n7 = n4 / 10;
        cArray[n2++] = (char)(n7 + 48);
        cArray[n2++] = (char)(n4 - 10 * n7 + 48);
        cArray[n2] = this.timeSeparatorChar;
        n2 += this.timeSeparatorLength;
        n7 = n5 / 10;
        cArray[n2++] = (char)(n7 + 48);
        cArray[n2++] = (char)(n5 - 10 * n7 + 48);
        cArray[n2] = this.timeSeparatorChar;
        n2 += this.timeSeparatorLength;
        n7 = n6 / 10;
        cArray[n2++] = (char)(n7 + 48);
        cArray[n2++] = (char)(n6 - 10 * n7 + 48);
        cArray[n2] = this.millisSeparatorChar;
        n2 += this.millisSeparatorLength;
        n7 = n / 100;
        cArray[n2++] = (char)(n7 + 48);
        n -= 100 * n7;
        n7 = n / 10;
        cArray[n2++] = (char)(n7 + 48);
        cArray[n2++] = (char)((n -= 10 * n7) + 48);
        return n2;
    }

    private int writeTimeZone(long l, char[] cArray, int n) {
        if (this.fixedTimeZoneFormat != null) {
            n = FixedDateFormat$FixedTimeZoneFormat.access$700(this.fixedTimeZoneFormat, this.timeZone.getOffset(l), cArray, n);
        }
        return n;
    }

    private int formatNanoOfMillisecond(int n, char[] cArray, int n2) {
        int n3 = n;
        for (int i = 0; i < this.secondFractionDigits - FixedDateFormat$FixedFormat.access$600(); ++i) {
            int n4 = TABLE[i];
            int n5 = n3 / n4;
            cArray[n2++] = (char)(n5 + 48);
            n3 -= n4 * n5;
        }
        return n2;
    }

    private int daylightSavingTime(int n) {
        return n > 23 ? this.dstOffsets[23] : this.dstOffsets[n];
    }

    public boolean isEquivalent(long l, int n, long l2, int n2) {
        if (l == l2) {
            if (this.secondFractionDigits <= 3) {
                return (long)n / 1000000L == (long)n2 / 1000000L;
            }
            return n == n2;
        }
        return false;
    }
}

