/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util.datetime;

import java.util.Objects;
import java.util.TimeZone;
import org.apache.logging.log4j.core.util.datetime.FastDateFormat;
import org.apache.logging.log4j.core.util.datetime.FixedDateFormat$FixedTimeZoneFormat;

public enum FixedDateFormat$FixedFormat {
    ABSOLUTE("HH:mm:ss,SSS", null, 0, ':', 1, ',', 1, 3, null),
    ABSOLUTE_MICROS("HH:mm:ss,nnnnnn", null, 0, ':', 1, ',', 1, 6, null),
    ABSOLUTE_NANOS("HH:mm:ss,nnnnnnnnn", null, 0, ':', 1, ',', 1, 9, null),
    ABSOLUTE_PERIOD("HH:mm:ss.SSS", null, 0, ':', 1, '.', 1, 3, null),
    COMPACT("yyyyMMddHHmmssSSS", "yyyyMMdd", 0, ' ', 0, ' ', 0, 3, null),
    DATE("dd MMM yyyy HH:mm:ss,SSS", "dd MMM yyyy ", 0, ':', 1, ',', 1, 3, null),
    DATE_PERIOD("dd MMM yyyy HH:mm:ss.SSS", "dd MMM yyyy ", 0, ':', 1, '.', 1, 3, null),
    DEFAULT("yyyy-MM-dd HH:mm:ss,SSS", "yyyy-MM-dd ", 0, ':', 1, ',', 1, 3, null),
    DEFAULT_MICROS("yyyy-MM-dd HH:mm:ss,nnnnnn", "yyyy-MM-dd ", 0, ':', 1, ',', 1, 6, null),
    DEFAULT_NANOS("yyyy-MM-dd HH:mm:ss,nnnnnnnnn", "yyyy-MM-dd ", 0, ':', 1, ',', 1, 9, null),
    DEFAULT_PERIOD("yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd ", 0, ':', 1, '.', 1, 3, null),
    ISO8601_BASIC("yyyyMMdd'T'HHmmss,SSS", "yyyyMMdd'T'", 2, ' ', 0, ',', 1, 3, null),
    ISO8601_BASIC_PERIOD("yyyyMMdd'T'HHmmss.SSS", "yyyyMMdd'T'", 2, ' ', 0, '.', 1, 3, null),
    ISO8601("yyyy-MM-dd'T'HH:mm:ss,SSS", "yyyy-MM-dd'T'", 2, ':', 1, ',', 1, 3, null),
    ISO8601_OFFSET_DATE_TIME_HH("yyyy-MM-dd'T'HH:mm:ss,SSSX", "yyyy-MM-dd'T'", 2, ':', 1, ',', 1, 3, FixedDateFormat$FixedTimeZoneFormat.HH),
    ISO8601_OFFSET_DATE_TIME_HHMM("yyyy-MM-dd'T'HH:mm:ss,SSSXX", "yyyy-MM-dd'T'", 2, ':', 1, ',', 1, 3, FixedDateFormat$FixedTimeZoneFormat.HHMM),
    ISO8601_OFFSET_DATE_TIME_HHCMM("yyyy-MM-dd'T'HH:mm:ss,SSSXXX", "yyyy-MM-dd'T'", 2, ':', 1, ',', 1, 3, FixedDateFormat$FixedTimeZoneFormat.HHCMM),
    ISO8601_PERIOD("yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'", 2, ':', 1, '.', 1, 3, null),
    ISO8601_PERIOD_MICROS("yyyy-MM-dd'T'HH:mm:ss.nnnnnn", "yyyy-MM-dd'T'", 2, ':', 1, '.', 1, 6, null),
    US_MONTH_DAY_YEAR2_TIME("dd/MM/yy HH:mm:ss.SSS", "dd/MM/yy ", 0, ':', 1, '.', 1, 3, null),
    US_MONTH_DAY_YEAR4_TIME("dd/MM/yyyy HH:mm:ss.SSS", "dd/MM/yyyy ", 0, ':', 1, '.', 1, 3, null);

    private static final String DEFAULT_SECOND_FRACTION_PATTERN = "SSS";
    private static final int MILLI_FRACTION_DIGITS;
    private static final char SECOND_FRACTION_PATTERN = 'n';
    private final String pattern;
    private final String datePattern;
    private final int escapeCount;
    private final char timeSeparatorChar;
    private final int timeSeparatorLength;
    private final char millisSeparatorChar;
    private final int millisSeparatorLength;
    private final int secondFractionDigits;
    private final FixedDateFormat$FixedTimeZoneFormat fixedTimeZoneFormat;
    private static final int[] EMPTY_RANGE;

    private FixedDateFormat$FixedFormat(String string2, String string3, int n2, char c, int n3, char c2, int n4, int n5, FixedDateFormat$FixedTimeZoneFormat fixedTimeZoneFormat) {
        this.timeSeparatorChar = c;
        this.timeSeparatorLength = n3;
        this.millisSeparatorChar = c2;
        this.millisSeparatorLength = n4;
        this.pattern = Objects.requireNonNull(string2);
        this.datePattern = string3;
        this.escapeCount = n2;
        this.secondFractionDigits = n5;
        this.fixedTimeZoneFormat = fixedTimeZoneFormat;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public static FixedDateFormat$FixedFormat lookup(String string) {
        for (FixedDateFormat$FixedFormat fixedDateFormat$FixedFormat : FixedDateFormat$FixedFormat.values()) {
            if (!fixedDateFormat$FixedFormat.name().equals(string) && !fixedDateFormat$FixedFormat.getPattern().equals(string)) continue;
            return fixedDateFormat$FixedFormat;
        }
        return null;
    }

    static FixedDateFormat$FixedFormat lookupIgnoringNanos(String string) {
        int[] nArray = FixedDateFormat$FixedFormat.nanoRange(string);
        int n = nArray[0];
        int n2 = nArray[1];
        if (n > 0) {
            String string2 = string.substring(0, n) + DEFAULT_SECOND_FRACTION_PATTERN + string.substring(n2, string.length());
            for (FixedDateFormat$FixedFormat fixedDateFormat$FixedFormat : FixedDateFormat$FixedFormat.values()) {
                if (!fixedDateFormat$FixedFormat.getPattern().equals(string2)) continue;
                return fixedDateFormat$FixedFormat;
            }
        }
        return null;
    }

    private static int[] nanoRange(String string) {
        int n = string.indexOf(110);
        int n2 = -1;
        if (n >= 0) {
            n2 = string.indexOf(90, n);
            n2 = n2 < 0 ? string.indexOf(88, n) : n2;
            n2 = n2 < 0 ? string.length() : n2;
            for (int i = n + 1; i < n2; ++i) {
                if (string.charAt(i) == 'n') continue;
                return EMPTY_RANGE;
            }
        }
        return new int[]{n, n2};
    }

    public int getLength() {
        return this.pattern.length() - this.escapeCount;
    }

    public int getDatePatternLength() {
        return this.getDatePattern() == null ? 0 : this.getDatePattern().length() - this.escapeCount;
    }

    public FastDateFormat getFastDateFormat() {
        return this.getFastDateFormat(null);
    }

    public FastDateFormat getFastDateFormat(TimeZone timeZone) {
        return this.getDatePattern() == null ? null : FastDateFormat.getInstance(this.getDatePattern(), timeZone);
    }

    public int getSecondFractionDigits() {
        return this.secondFractionDigits;
    }

    public FixedDateFormat$FixedTimeZoneFormat getFixedTimeZoneFormat() {
        return this.fixedTimeZoneFormat;
    }

    static /* synthetic */ char access$000(FixedDateFormat$FixedFormat fixedDateFormat$FixedFormat) {
        return fixedDateFormat$FixedFormat.timeSeparatorChar;
    }

    static /* synthetic */ int access$100(FixedDateFormat$FixedFormat fixedDateFormat$FixedFormat) {
        return fixedDateFormat$FixedFormat.timeSeparatorLength;
    }

    static /* synthetic */ char access$200(FixedDateFormat$FixedFormat fixedDateFormat$FixedFormat) {
        return fixedDateFormat$FixedFormat.millisSeparatorChar;
    }

    static /* synthetic */ int access$300(FixedDateFormat$FixedFormat fixedDateFormat$FixedFormat) {
        return fixedDateFormat$FixedFormat.millisSeparatorLength;
    }

    static /* synthetic */ FixedDateFormat$FixedTimeZoneFormat access$400(FixedDateFormat$FixedFormat fixedDateFormat$FixedFormat) {
        return fixedDateFormat$FixedFormat.fixedTimeZoneFormat;
    }

    static /* synthetic */ int[] access$500(String string) {
        return FixedDateFormat$FixedFormat.nanoRange(string);
    }

    static /* synthetic */ int access$600() {
        return MILLI_FRACTION_DIGITS;
    }

    static {
        MILLI_FRACTION_DIGITS = DEFAULT_SECOND_FRACTION_PATTERN.length();
        EMPTY_RANGE = new int[]{-1, -1};
    }
}

