/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.net.URLConnection;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.util.AuthorizationProvider;
import org.apache.logging.log4j.core.util.PasswordDecryptor;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Base64Util;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.PropertiesUtil;

public class BasicAuthorizationProvider
implements AuthorizationProvider {
    private static final String[] PREFIXES = new String[]{"log4j2.config.", "log4j2.Configuration.", "logging.auth."};
    private static final String AUTH_USER_NAME = "username";
    private static final String AUTH_PASSWORD = "password";
    private static final String AUTH_PASSWORD_DECRYPTOR = "passwordDecryptor";
    public static final String CONFIG_USER_NAME = "log4j2.configurationUserName";
    public static final String CONFIG_PASSWORD = "log4j2.configurationPassword";
    public static final String PASSWORD_DECRYPTOR = "log4j2.passwordDecryptor";
    private static Logger LOGGER = StatusLogger.getLogger();
    private String authString = null;

    public BasicAuthorizationProvider(PropertiesUtil propertiesUtil) {
        String string = propertiesUtil.getStringProperty(PREFIXES, AUTH_USER_NAME, () -> propertiesUtil.getStringProperty(CONFIG_USER_NAME));
        String string2 = propertiesUtil.getStringProperty(PREFIXES, AUTH_PASSWORD, () -> propertiesUtil.getStringProperty(CONFIG_PASSWORD));
        String string3 = propertiesUtil.getStringProperty(PREFIXES, AUTH_PASSWORD_DECRYPTOR, () -> propertiesUtil.getStringProperty(PASSWORD_DECRYPTOR));
        if (string3 != null) {
            try {
                Object t = LoaderUtil.newInstanceOf(string3);
                if (t instanceof PasswordDecryptor) {
                    string2 = ((PasswordDecryptor)t).decryptPassword(string2);
                }
            }
            catch (Exception exception) {
                LOGGER.warn("Unable to decrypt password.", (Throwable)exception);
            }
        }
        if (string != null && string2 != null) {
            this.authString = "Basic " + Base64Util.encode(string + ":" + string2);
        }
    }

    @Override
    public void addAuthorization(URLConnection uRLConnection) {
        if (this.authString != null) {
            uRLConnection.setRequestProperty("Authorization", this.authString);
        }
    }
}

