/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.time;

import java.io.Serializable;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.core.time.PreciseClock;
import org.apache.logging.log4j.core.util.Clock;
import org.apache.logging.log4j.util.PerformanceSensitive;

@PerformanceSensitive(value={"allocation"})
public class MutableInstant
implements Serializable,
TemporalAccessor,
Instant {
    private static final int MILLIS_PER_SECOND = 1000;
    private static final int NANOS_PER_MILLI = 1000000;
    private static final int NANOS_PER_SECOND = 1000000000;
    private long epochSecond;
    private int nanoOfSecond;

    @Override
    public long getEpochSecond() {
        return this.epochSecond;
    }

    @Override
    public int getNanoOfSecond() {
        return this.nanoOfSecond;
    }

    @Override
    public long getEpochMillisecond() {
        int n = this.nanoOfSecond / 1000000;
        long l = this.epochSecond * 1000L + (long)n;
        return l;
    }

    @Override
    public int getNanoOfMillisecond() {
        int n = this.nanoOfSecond / 1000000;
        int n2 = this.nanoOfSecond - n * 1000000;
        return n2;
    }

    public void initFrom(Instant instant) {
        this.epochSecond = instant.getEpochSecond();
        this.nanoOfSecond = instant.getNanoOfSecond();
    }

    public void initFromEpochMilli(long l, int n) {
        this.validateNanoOfMillisecond(n);
        this.epochSecond = l / 1000L;
        this.nanoOfSecond = (int)(l - this.epochSecond * 1000L) * 1000000 + n;
    }

    private void validateNanoOfMillisecond(int n) {
        if (n < 0 || n >= 1000000) {
            throw new IllegalArgumentException("Invalid nanoOfMillisecond " + n);
        }
    }

    public void initFrom(Clock clock) {
        if (clock instanceof PreciseClock) {
            ((PreciseClock)clock).init(this);
        } else {
            this.initFromEpochMilli(clock.currentTimeMillis(), 0);
        }
    }

    public void initFromEpochSecond(long l, int n) {
        this.validateNanoOfSecond(n);
        this.epochSecond = l;
        this.nanoOfSecond = n;
    }

    private void validateNanoOfSecond(int n) {
        if (n < 0 || n >= 1000000000) {
            throw new IllegalArgumentException("Invalid nanoOfSecond " + n);
        }
    }

    public static void instantToMillisAndNanos(long l, int n, long[] lArray) {
        int n2 = n / 1000000;
        lArray[0] = l * 1000L + (long)n2;
        lArray[1] = n - n2 * 1000000;
    }

    @Override
    public boolean isSupported(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            return temporalField == ChronoField.INSTANT_SECONDS || temporalField == ChronoField.NANO_OF_SECOND || temporalField == ChronoField.MICRO_OF_SECOND || temporalField == ChronoField.MILLI_OF_SECOND;
        }
        return temporalField != null && temporalField.isSupportedBy(this);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case NANO_OF_SECOND: {
                    return this.nanoOfSecond;
                }
                case MICRO_OF_SECOND: {
                    return this.nanoOfSecond / 1000;
                }
                case MILLI_OF_SECOND: {
                    return this.nanoOfSecond / 1000000;
                }
                case INSTANT_SECONDS: {
                    return this.epochSecond;
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return temporalField.getFrom(this);
    }

    @Override
    public ValueRange range(TemporalField temporalField) {
        return TemporalAccessor.super.range(temporalField);
    }

    @Override
    public int get(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case NANO_OF_SECOND: {
                    return this.nanoOfSecond;
                }
                case MICRO_OF_SECOND: {
                    return this.nanoOfSecond / 1000;
                }
                case MILLI_OF_SECOND: {
                    return this.nanoOfSecond / 1000000;
                }
                case INSTANT_SECONDS: {
                    ChronoField.INSTANT_SECONDS.checkValidIntValue(this.epochSecond);
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return this.range(temporalField).checkValidIntValue(temporalField.getFrom(this), temporalField);
    }

    @Override
    public <R> R query(TemporalQuery<R> temporalQuery) {
        if (temporalQuery == TemporalQueries.precision()) {
            return (R)ChronoUnit.NANOS;
        }
        if (temporalQuery == TemporalQueries.chronology() || temporalQuery == TemporalQueries.zoneId() || temporalQuery == TemporalQueries.zone() || temporalQuery == TemporalQueries.offset() || temporalQuery == TemporalQueries.localDate() || temporalQuery == TemporalQueries.localTime()) {
            return null;
        }
        return temporalQuery.queryFrom(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MutableInstant)) {
            return false;
        }
        MutableInstant mutableInstant = (MutableInstant)object;
        return this.epochSecond == mutableInstant.epochSecond && this.nanoOfSecond == mutableInstant.nanoOfSecond;
    }

    public int hashCode() {
        int n = 17;
        n = 31 * n + (int)(this.epochSecond ^ this.epochSecond >>> 32);
        n = 31 * n + this.nanoOfSecond;
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        this.formatTo(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public void formatTo(StringBuilder stringBuilder) {
        stringBuilder.append("MutableInstant[epochSecond=").append(this.epochSecond).append(", nano=").append(this.nanoOfSecond).append("]");
    }
}

