/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.script;

import java.security.AccessController;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.logging.log4j.core.script.AbstractScript;
import org.apache.logging.log4j.core.script.ScriptManager;
import org.apache.logging.log4j.core.script.ScriptManager$AbstractScriptRunner;

class ScriptManager$MainScriptRunner
extends ScriptManager$AbstractScriptRunner {
    private final AbstractScript script;
    private final CompiledScript compiledScript;
    private final ScriptEngine scriptEngine;
    final /* synthetic */ ScriptManager this$0;

    public ScriptManager$MainScriptRunner(ScriptManager scriptManager, ScriptEngine scriptEngine, AbstractScript abstractScript) {
        this.this$0 = scriptManager;
        super(scriptManager, null);
        this.script = abstractScript;
        this.scriptEngine = scriptEngine;
        CompiledScript compiledScript = null;
        if (scriptEngine instanceof Compilable) {
            ScriptManager.access$100().debug("Script {} is compilable", (Object)abstractScript.getName());
            compiledScript = AccessController.doPrivileged(() -> {
                try {
                    return ((Compilable)((Object)scriptEngine)).compile(abstractScript.getScriptText());
                }
                catch (Throwable throwable) {
                    ScriptManager.access$100().warn("Error compiling script", throwable);
                    return null;
                }
            });
        }
        this.compiledScript = compiledScript;
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    @Override
    public Object execute(Bindings bindings) {
        if (this.compiledScript != null) {
            try {
                return this.compiledScript.eval(bindings);
            }
            catch (ScriptException scriptException) {
                ScriptManager.access$100().error("Error running script " + this.script.getName(), (Throwable)scriptException);
                return null;
            }
        }
        try {
            return this.scriptEngine.eval(this.script.getScriptText(), bindings);
        }
        catch (ScriptException scriptException) {
            ScriptManager.access$100().error("Error running script " + this.script.getName(), (Throwable)scriptException);
            return null;
        }
    }

    @Override
    public AbstractScript getScript() {
        return this.script;
    }
}

