/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.impl.ThrowableFormatOptions;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.core.util.StringBuilderWriter;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="ThrowablePatternConverter", category="Converter")
@ConverterKeys(value={"ex", "throwable", "exception"})
public class ThrowablePatternConverter
extends LogEventPatternConverter {
    protected final List<PatternFormatter> formatters;
    private String rawOption;
    private final boolean subShortOption;
    private final boolean nonStandardLineSeparator;
    protected final ThrowableFormatOptions options;

    @Deprecated
    protected ThrowablePatternConverter(String string, String string2, String[] stringArray) {
        this(string, string2, stringArray, null);
    }

    protected ThrowablePatternConverter(String string, String string2, String[] stringArray, Configuration configuration) {
        super(string, string2);
        this.options = ThrowableFormatOptions.newInstance(stringArray);
        if (stringArray != null && stringArray.length > 0) {
            this.rawOption = stringArray[0];
        }
        if (this.options.getSuffix() != null) {
            PatternParser patternParser = PatternLayout.createPatternParser(configuration);
            List<PatternFormatter> list = patternParser.parse(this.options.getSuffix());
            boolean bl = false;
            for (PatternFormatter object : list) {
                if (!object.handlesThrowable()) continue;
                bl = true;
            }
            if (!bl) {
                this.formatters = list;
            } else {
                ArrayList arrayList = new ArrayList();
                for (PatternFormatter patternFormatter : list) {
                    if (patternFormatter.handlesThrowable()) continue;
                    arrayList.add(patternFormatter);
                }
                this.formatters = arrayList;
            }
        } else {
            this.formatters = Collections.emptyList();
        }
        this.subShortOption = "short.message".equalsIgnoreCase(this.rawOption) || "short.localizedMessage".equalsIgnoreCase(this.rawOption) || "short.fileName".equalsIgnoreCase(this.rawOption) || "short.lineNumber".equalsIgnoreCase(this.rawOption) || "short.methodName".equalsIgnoreCase(this.rawOption) || "short.className".equalsIgnoreCase(this.rawOption);
        this.nonStandardLineSeparator = !Strings.LINE_SEPARATOR.equals(this.options.getSeparator());
    }

    public static ThrowablePatternConverter newInstance(Configuration configuration, String[] stringArray) {
        return new ThrowablePatternConverter("Throwable", "throwable", stringArray, configuration);
    }

    @Override
    public void format(LogEvent logEvent, StringBuilder stringBuilder) {
        Throwable throwable = logEvent.getThrown();
        if (this.subShortOption) {
            this.formatSubShortOption(throwable, this.getSuffix(logEvent), stringBuilder);
        } else if (throwable != null && this.options.anyLines()) {
            this.formatOption(throwable, this.getSuffix(logEvent), stringBuilder);
        }
    }

    private void formatSubShortOption(Throwable throwable, String string, StringBuilder stringBuilder) {
        StackTraceElement[] stackTraceElementArray;
        StackTraceElement stackTraceElement = null;
        if (throwable != null && (stackTraceElementArray = throwable.getStackTrace()) != null && stackTraceElementArray.length > 0) {
            stackTraceElement = stackTraceElementArray[0];
        }
        if (throwable != null && stackTraceElement != null) {
            String string2 = "";
            if ("short.className".equalsIgnoreCase(this.rawOption)) {
                string2 = stackTraceElement.getClassName();
            } else if ("short.methodName".equalsIgnoreCase(this.rawOption)) {
                string2 = stackTraceElement.getMethodName();
            } else if ("short.lineNumber".equalsIgnoreCase(this.rawOption)) {
                string2 = String.valueOf(stackTraceElement.getLineNumber());
            } else if ("short.message".equalsIgnoreCase(this.rawOption)) {
                string2 = throwable.getMessage();
            } else if ("short.localizedMessage".equalsIgnoreCase(this.rawOption)) {
                string2 = throwable.getLocalizedMessage();
            } else if ("short.fileName".equalsIgnoreCase(this.rawOption)) {
                string2 = stackTraceElement.getFileName();
            }
            int n = stringBuilder.length();
            if (n > 0 && !Character.isWhitespace(stringBuilder.charAt(n - 1))) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string2);
            if (Strings.isNotBlank(string)) {
                stringBuilder.append(' ');
                stringBuilder.append(string);
            }
        }
    }

    private void formatOption(Throwable throwable, String string, StringBuilder stringBuilder) {
        int n = stringBuilder.length();
        if (n > 0 && !Character.isWhitespace(stringBuilder.charAt(n - 1))) {
            stringBuilder.append(' ');
        }
        if (!this.options.allLines() || this.nonStandardLineSeparator || Strings.isNotBlank(string)) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            String[] stringArray = stringWriter.toString().split(Strings.LINE_SEPARATOR);
            int n2 = this.options.minLines(stringArray.length) - 1;
            boolean bl = Strings.isNotBlank(string);
            for (int i = 0; i <= n2; ++i) {
                stringBuilder.append(stringArray[i]);
                if (bl) {
                    stringBuilder.append(' ');
                    stringBuilder.append(string);
                }
                if (i >= n2) continue;
                stringBuilder.append(this.options.getSeparator());
            }
        } else {
            throwable.printStackTrace(new PrintWriter(new StringBuilderWriter(stringBuilder)));
        }
    }

    @Override
    public boolean handlesThrowable() {
        return true;
    }

    protected String getSuffix(LogEvent logEvent) {
        if (this.formatters.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.formatters.size();
        for (int i = 0; i < n; ++i) {
            this.formatters.get(i).format(logEvent, stringBuilder);
        }
        return stringBuilder.toString();
    }

    public ThrowableFormatOptions getOptions() {
        return this.options;
    }
}

