/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.HashMap;
import java.util.Locale;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LevelPatternConverter$1;
import org.apache.logging.log4j.core.pattern.LevelPatternConverter$LevelMapLevelPatternConverter;
import org.apache.logging.log4j.core.pattern.LevelPatternConverter$SimpleLevelPatternConverter;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.core.util.Patterns;
import org.apache.logging.log4j.util.PerformanceSensitive;

@Plugin(name="LevelPatternConverter", category="Converter")
@ConverterKeys(value={"p", "level"})
@PerformanceSensitive(value={"allocation"})
public class LevelPatternConverter
extends LogEventPatternConverter {
    private static final String OPTION_LENGTH = "length";
    private static final String OPTION_LOWER = "lowerCase";
    private static final LevelPatternConverter INSTANCE = new LevelPatternConverter$SimpleLevelPatternConverter(null);

    private LevelPatternConverter() {
        super("Level", "level");
    }

    public static LevelPatternConverter newInstance(String[] stringArray) {
        Object object;
        if (stringArray == null || stringArray.length == 0) {
            return INSTANCE;
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        int n = Integer.MAX_VALUE;
        boolean bl = false;
        String[] stringArray2 = stringArray[0].split(Patterns.COMMA_SEPARATOR);
        for (String object2 : stringArray2) {
            object = object2.split("=");
            if (object == null || ((String[])object).length != 2) {
                LOGGER.error("Invalid option {}", (Object)object2);
                continue;
            }
            String string = object[0].trim();
            String string2 = object[1].trim();
            if (OPTION_LENGTH.equalsIgnoreCase(string)) {
                n = Integers.parseInt(string2);
                continue;
            }
            if (OPTION_LOWER.equalsIgnoreCase(string)) {
                bl = Boolean.parseBoolean(string2);
                continue;
            }
            Level level = Level.toLevel(string, null);
            if (level == null) {
                LOGGER.error("Invalid Level {}", (Object)string);
                continue;
            }
            hashMap.put(level, string2);
        }
        if (hashMap.isEmpty() && n == Integer.MAX_VALUE && !bl) {
            return INSTANCE;
        }
        for (Level level : Level.values()) {
            if (hashMap.containsKey(level)) continue;
            object = LevelPatternConverter.left(level, n);
            hashMap.put(level, bl ? ((String)object).toLowerCase(Locale.US) : object);
        }
        return new LevelPatternConverter$LevelMapLevelPatternConverter(hashMap, null);
    }

    private static String left(Level level, int n) {
        String string = level.toString();
        if (n >= string.length()) {
            return string;
        }
        return string.substring(0, n);
    }

    @Override
    public void format(LogEvent logEvent, StringBuilder stringBuilder) {
        throw new UnsupportedOperationException("Overridden by subclasses");
    }

    @Override
    public String getStyleClass(Object object) {
        if (object instanceof LogEvent) {
            return "level " + ((LogEvent)object).getLevel().name().toLowerCase(Locale.ENGLISH);
        }
        return "level";
    }

    /* synthetic */ LevelPatternConverter(LevelPatternConverter$1 levelPatternConverter$1) {
        this();
    }
}

