/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.osgi;

import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.impl.ContextAnchor;
import org.apache.logging.log4j.core.selector.ClassLoaderContextSelector;
import org.apache.logging.log4j.util.StackLocatorUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.osgi.framework.FrameworkUtil;

public class BundleContextSelector
extends ClassLoaderContextSelector {
    @Override
    public void shutdown(String string, ClassLoader classLoader, boolean bl, boolean bl2) {
        Bundle[] bundleArray;
        LoggerContext loggerContext = null;
        Bundle bundle = null;
        if (bl) {
            loggerContext = ContextAnchor.THREAD_CONTEXT.get();
            ContextAnchor.THREAD_CONTEXT.remove();
        }
        if (loggerContext == null && classLoader instanceof BundleReference) {
            bundle = ((BundleReference)classLoader).getBundle();
            loggerContext = this.getLoggerContext(bundle);
            this.removeLoggerContext(loggerContext);
        }
        if (loggerContext == null && (bundleArray = StackLocatorUtil.getCallerClass(string)) != null) {
            bundle = FrameworkUtil.getBundle(bundleArray);
            loggerContext = this.getLoggerContext(FrameworkUtil.getBundle(bundleArray));
            this.removeLoggerContext(loggerContext);
        }
        if (loggerContext == null) {
            loggerContext = ContextAnchor.THREAD_CONTEXT.get();
            ContextAnchor.THREAD_CONTEXT.remove();
        }
        if (loggerContext != null) {
            loggerContext.stop(50L, TimeUnit.MILLISECONDS);
        }
        if (bundle != null && bl2) {
            for (Bundle bundle2 : bundleArray = bundle.getBundleContext().getBundles()) {
                loggerContext = this.getLoggerContext(bundle2);
                if (loggerContext == null) continue;
                loggerContext.stop(50L, TimeUnit.MILLISECONDS);
            }
        }
    }

    private LoggerContext getLoggerContext(Bundle bundle) {
        String string = Objects.requireNonNull(bundle, "No Bundle provided").getSymbolicName();
        AtomicReference atomicReference = (AtomicReference)CONTEXT_MAP.get(string);
        if (atomicReference != null && atomicReference.get() != null) {
            return (LoggerContext)((WeakReference)atomicReference.get()).get();
        }
        return null;
    }

    private void removeLoggerContext(LoggerContext loggerContext) {
        CONTEXT_MAP.remove(loggerContext.getName());
    }

    @Override
    public boolean hasContext(String string, ClassLoader classLoader, boolean bl) {
        if (bl && ContextAnchor.THREAD_CONTEXT.get() != null) {
            return ContextAnchor.THREAD_CONTEXT.get().isStarted();
        }
        if (classLoader instanceof BundleReference) {
            return BundleContextSelector.hasContext(((BundleReference)classLoader).getBundle());
        }
        Class<?> clazz = StackLocatorUtil.getCallerClass(string);
        if (clazz != null) {
            return BundleContextSelector.hasContext(FrameworkUtil.getBundle(clazz));
        }
        return ContextAnchor.THREAD_CONTEXT.get() != null && ContextAnchor.THREAD_CONTEXT.get().isStarted();
    }

    @Override
    public LoggerContext getContext(String string, ClassLoader classLoader, boolean bl, URI uRI) {
        if (bl) {
            LoggerContext loggerContext = ContextAnchor.THREAD_CONTEXT.get();
            if (loggerContext != null) {
                return loggerContext;
            }
            return this.getDefault();
        }
        if (classLoader instanceof BundleReference) {
            return BundleContextSelector.locateContext(((BundleReference)classLoader).getBundle(), uRI);
        }
        Class<?> clazz = StackLocatorUtil.getCallerClass(string);
        if (clazz != null) {
            return BundleContextSelector.locateContext(FrameworkUtil.getBundle(clazz), uRI);
        }
        LoggerContext loggerContext = ContextAnchor.THREAD_CONTEXT.get();
        return loggerContext == null ? this.getDefault() : loggerContext;
    }

    private static boolean hasContext(Bundle bundle) {
        String string = Objects.requireNonNull(bundle, "No Bundle provided").getSymbolicName();
        AtomicReference atomicReference = (AtomicReference)CONTEXT_MAP.get(string);
        return atomicReference != null && atomicReference.get() != null && ((WeakReference)atomicReference.get()).get() != null && ((LoggerContext)((WeakReference)atomicReference.get()).get()).isStarted();
    }

    private static LoggerContext locateContext(Bundle bundle, URI uRI) {
        String string = Objects.requireNonNull(bundle, "No Bundle provided").getSymbolicName();
        AtomicReference atomicReference = (AtomicReference)CONTEXT_MAP.get(string);
        if (atomicReference == null) {
            LoggerContext loggerContext = new LoggerContext(string, (Object)bundle, uRI);
            CONTEXT_MAP.putIfAbsent(string, new AtomicReference<WeakReference<LoggerContext>>(new WeakReference<LoggerContext>(loggerContext)));
            return (LoggerContext)((WeakReference)((AtomicReference)CONTEXT_MAP.get(string)).get()).get();
        }
        WeakReference weakReference = (WeakReference)atomicReference.get();
        LoggerContext loggerContext = (LoggerContext)weakReference.get();
        if (loggerContext == null) {
            LoggerContext loggerContext2 = new LoggerContext(string, (Object)bundle, uRI);
            atomicReference.compareAndSet(weakReference, new WeakReference<LoggerContext>(loggerContext2));
            return (LoggerContext)((WeakReference)atomicReference.get()).get();
        }
        URI uRI2 = loggerContext.getConfigLocation();
        if (uRI2 == null && uRI != null) {
            LOGGER.debug("Setting bundle ({}) configuration to {}", (Object)string, (Object)uRI);
            loggerContext.setConfigLocation(uRI);
        } else if (uRI2 != null && uRI != null && !uRI.equals(uRI2)) {
            LOGGER.warn("locateContext called with URI [{}], but existing LoggerContext has URI [{}]", (Object)uRI, (Object)uRI2);
        }
        return loggerContext;
    }
}

