/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.ssl;

import java.util.Arrays;
import java.util.Objects;
import javax.net.ssl.TrustManagerFactory;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.net.ssl.AbstractKeyStoreConfiguration;
import org.apache.logging.log4j.core.net.ssl.EnvironmentPasswordProvider;
import org.apache.logging.log4j.core.net.ssl.FilePasswordProvider;
import org.apache.logging.log4j.core.net.ssl.MemoryPasswordProvider;
import org.apache.logging.log4j.core.net.ssl.PasswordProvider;
import org.apache.logging.log4j.core.net.ssl.StoreConfigurationException;

@Plugin(name="TrustStore", category="Core", printObject=true)
public class TrustStoreConfiguration
extends AbstractKeyStoreConfiguration {
    private final String trustManagerFactoryAlgorithm;

    public TrustStoreConfiguration(String string, PasswordProvider passwordProvider, String string2, String string3) {
        super(string, passwordProvider, string2);
        this.trustManagerFactoryAlgorithm = string3 == null ? TrustManagerFactory.getDefaultAlgorithm() : string3;
    }

    @Deprecated
    public TrustStoreConfiguration(String string, char[] cArray, String string2, String string3) {
        this(string, new MemoryPasswordProvider(cArray), string2, string3);
        if (cArray != null) {
            Arrays.fill(cArray, '\u0000');
        }
    }

    @Deprecated
    public TrustStoreConfiguration(String string, String string2, String string3, String string4) {
        this(string, new MemoryPasswordProvider(string2 == null ? null : string2.toCharArray()), string3, string4);
    }

    @PluginFactory
    public static TrustStoreConfiguration createKeyStoreConfiguration(@PluginAttribute(value="location") String string, @PluginAttribute(value="password", sensitive=true) char[] cArray, @PluginAttribute(value="passwordEnvironmentVariable") String string2, @PluginAttribute(value="passwordFile") String string3, @PluginAttribute(value="type") String string4, @PluginAttribute(value="trustManagerFactoryAlgorithm") String string5) {
        if (cArray != null && string2 != null && string3 != null) {
            throw new IllegalStateException("You MUST set only one of 'password', 'passwordEnvironmentVariable' or 'passwordFile'.");
        }
        try {
            PasswordProvider passwordProvider;
            PasswordProvider passwordProvider2 = string3 != null ? new FilePasswordProvider(string3) : (passwordProvider = string2 != null ? new EnvironmentPasswordProvider(string2) : new MemoryPasswordProvider(cArray));
            if (cArray != null) {
                Arrays.fill(cArray, '\u0000');
            }
            return new TrustStoreConfiguration(string, passwordProvider, string4, string5);
        }
        catch (Exception exception) {
            throw new StoreConfigurationException("Could not configure TrustStore", exception);
        }
    }

    @Deprecated
    public static TrustStoreConfiguration createKeyStoreConfiguration(String string, char[] cArray, String string2, String string3) {
        return TrustStoreConfiguration.createKeyStoreConfiguration(string, cArray, null, null, string2, string3);
    }

    @Deprecated
    public static TrustStoreConfiguration createKeyStoreConfiguration(String string, String string2, String string3, String string4) {
        return TrustStoreConfiguration.createKeyStoreConfiguration(string, string2 == null ? null : string2.toCharArray(), null, null, string3, string4);
    }

    public TrustManagerFactory initTrustManagerFactory() {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this.trustManagerFactoryAlgorithm);
        trustManagerFactory.init(this.getKeyStore());
        return trustManagerFactory;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + (this.trustManagerFactoryAlgorithm == null ? 0 : this.trustManagerFactoryAlgorithm.hashCode());
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TrustStoreConfiguration trustStoreConfiguration = (TrustStoreConfiguration)object;
        return Objects.equals(this.trustManagerFactoryAlgorithm, trustStoreConfiguration.trustManagerFactoryAlgorithm);
    }

    public String getTrustManagerFactoryAlgorithm() {
        return this.trustManagerFactoryAlgorithm;
    }
}

