/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.ssl;

import java.util.Arrays;
import java.util.Objects;
import javax.net.ssl.KeyManagerFactory;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.net.ssl.AbstractKeyStoreConfiguration;
import org.apache.logging.log4j.core.net.ssl.EnvironmentPasswordProvider;
import org.apache.logging.log4j.core.net.ssl.FilePasswordProvider;
import org.apache.logging.log4j.core.net.ssl.MemoryPasswordProvider;
import org.apache.logging.log4j.core.net.ssl.PasswordProvider;
import org.apache.logging.log4j.core.net.ssl.StoreConfigurationException;

@Plugin(name="KeyStore", category="Core", printObject=true)
public class KeyStoreConfiguration
extends AbstractKeyStoreConfiguration {
    private final String keyManagerFactoryAlgorithm;

    public KeyStoreConfiguration(String string, PasswordProvider passwordProvider, String string2, String string3) {
        super(string, passwordProvider, string2);
        this.keyManagerFactoryAlgorithm = string3 == null ? KeyManagerFactory.getDefaultAlgorithm() : string3;
    }

    @Deprecated
    public KeyStoreConfiguration(String string, char[] cArray, String string2, String string3) {
        this(string, new MemoryPasswordProvider(cArray), string2, string3);
        if (cArray != null) {
            Arrays.fill(cArray, '\u0000');
        }
    }

    @Deprecated
    public KeyStoreConfiguration(String string, String string2, String string3, String string4) {
        this(string, new MemoryPasswordProvider(string2 == null ? null : string2.toCharArray()), string3, string4);
    }

    @PluginFactory
    public static KeyStoreConfiguration createKeyStoreConfiguration(@PluginAttribute(value="location") String string, @PluginAttribute(value="password", sensitive=true) char[] cArray, @PluginAttribute(value="passwordEnvironmentVariable") String string2, @PluginAttribute(value="passwordFile") String string3, @PluginAttribute(value="type") String string4, @PluginAttribute(value="keyManagerFactoryAlgorithm") String string5) {
        if (cArray != null && string2 != null && string3 != null) {
            throw new StoreConfigurationException("You MUST set only one of 'password', 'passwordEnvironmentVariable' or 'passwordFile'.");
        }
        try {
            PasswordProvider passwordProvider;
            PasswordProvider passwordProvider2 = string3 != null ? new FilePasswordProvider(string3) : (passwordProvider = string2 != null ? new EnvironmentPasswordProvider(string2) : new MemoryPasswordProvider(cArray));
            if (cArray != null) {
                Arrays.fill(cArray, '\u0000');
            }
            return new KeyStoreConfiguration(string, passwordProvider, string4, string5);
        }
        catch (Exception exception) {
            throw new StoreConfigurationException("Could not configure KeyStore", exception);
        }
    }

    @Deprecated
    public static KeyStoreConfiguration createKeyStoreConfiguration(String string, char[] cArray, String string2, String string3) {
        return KeyStoreConfiguration.createKeyStoreConfiguration(string, cArray, null, null, string2, string3);
    }

    @Deprecated
    public static KeyStoreConfiguration createKeyStoreConfiguration(String string, String string2, String string3, String string4) {
        return KeyStoreConfiguration.createKeyStoreConfiguration(string, string2 == null ? null : string2.toCharArray(), string3, string4);
    }

    public KeyManagerFactory initKeyManagerFactory() {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this.keyManagerFactoryAlgorithm);
        char[] cArray = this.getPasswordAsCharArray();
        try {
            keyManagerFactory.init(this.getKeyStore(), cArray);
        }
        finally {
            if (cArray != null) {
                Arrays.fill(cArray, '\u0000');
            }
        }
        return keyManagerFactory;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + (this.keyManagerFactoryAlgorithm == null ? 0 : this.keyManagerFactoryAlgorithm.hashCode());
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        KeyStoreConfiguration keyStoreConfiguration = (KeyStoreConfiguration)object;
        return Objects.equals(this.keyManagerFactoryAlgorithm, keyStoreConfiguration.keyManagerFactoryAlgorithm);
    }

    public String getKeyManagerFactoryAlgorithm() {
        return this.keyManagerFactoryAlgorithm;
    }
}

