/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.net.TcpSocketManager;
import org.apache.logging.log4j.core.net.TcpSocketManager$FactoryData;
import org.apache.logging.log4j.core.net.TcpSocketManager$HostResolver;
import org.apache.logging.log4j.core.util.Closer;
import org.apache.logging.log4j.core.util.NullOutputStream;

public class TcpSocketManager$TcpSocketManagerFactory<M extends TcpSocketManager, T extends TcpSocketManager$FactoryData>
implements ManagerFactory<M, T> {
    static volatile TcpSocketManager$HostResolver RESOLVER = TcpSocketManager$HostResolver.INSTANCE;

    protected TcpSocketManager$TcpSocketManagerFactory() {
    }

    @Override
    public M createManager(String string, T t) {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(((TcpSocketManager$FactoryData)t).host);
        }
        catch (UnknownHostException unknownHostException) {
            TcpSocketManager.access$1100().error("Could not find address of {}: {}", (Object)((TcpSocketManager$FactoryData)t).host, (Object)unknownHostException, (Object)unknownHostException);
            return null;
        }
        Socket socket = null;
        try {
            socket = this.createSocket(t);
            OutputStream outputStream = socket.getOutputStream();
            return this.createManager(string, outputStream, socket, inetAddress, t);
        }
        catch (IOException iOException) {
            TcpSocketManager.access$1200().error("TcpSocketManager ({}) caught exception and will continue:", (Object)string, (Object)iOException);
            NullOutputStream nullOutputStream = NullOutputStream.getInstance();
            if (((TcpSocketManager$FactoryData)t).reconnectDelayMillis == 0) {
                Closer.closeSilently(socket);
                return null;
            }
            return this.createManager(string, nullOutputStream, null, inetAddress, t);
        }
    }

    M createManager(String string, OutputStream outputStream, Socket socket, InetAddress inetAddress, T t) {
        return (M)new TcpSocketManager(string, outputStream, socket, inetAddress, ((TcpSocketManager$FactoryData)t).host, ((TcpSocketManager$FactoryData)t).port, ((TcpSocketManager$FactoryData)t).connectTimeoutMillis, ((TcpSocketManager$FactoryData)t).reconnectDelayMillis, ((TcpSocketManager$FactoryData)t).immediateFail, ((TcpSocketManager$FactoryData)t).layout, ((TcpSocketManager$FactoryData)t).bufferSize, ((TcpSocketManager$FactoryData)t).socketOptions);
    }

    Socket createSocket(T t) {
        List<InetSocketAddress> list = RESOLVER.resolveHost(((TcpSocketManager$FactoryData)t).host, ((TcpSocketManager$FactoryData)t).port);
        IOException iOException = null;
        for (InetSocketAddress inetSocketAddress : list) {
            try {
                return TcpSocketManager.createSocket(inetSocketAddress, ((TcpSocketManager$FactoryData)t).socketOptions, ((TcpSocketManager$FactoryData)t).connectTimeoutMillis);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        throw new IOException(this.errorMessage(t, list), iOException);
    }

    protected String errorMessage(T t, List<InetSocketAddress> list) {
        StringBuilder stringBuilder = new StringBuilder("Unable to create socket for ");
        stringBuilder.append(((TcpSocketManager$FactoryData)t).host).append(" at port ").append(((TcpSocketManager$FactoryData)t).port);
        if (list.size() == 1) {
            if (!list.get(0).getAddress().getHostAddress().equals(((TcpSocketManager$FactoryData)t).host)) {
                stringBuilder.append(" using ip address ").append(list.get(0).getAddress().getHostAddress());
                stringBuilder.append(" and port ").append(list.get(0).getPort());
            }
        } else {
            stringBuilder.append(" using ip addresses and ports ");
            for (int i = 0; i < list.size(); ++i) {
                if (i <= 0) continue;
                stringBuilder.append(", ");
                stringBuilder.append(list.get(i).getAddress().getHostAddress());
                stringBuilder.append(":").append(list.get(i).getPort());
            }
        }
        return stringBuilder.toString();
    }
}

