/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.net.TcpSocketManager;
import org.apache.logging.log4j.core.net.TcpSocketManager$TcpSocketManagerFactory;
import org.apache.logging.log4j.core.util.Closer;
import org.apache.logging.log4j.core.util.Log4jThread;

class TcpSocketManager$Reconnector
extends Log4jThread {
    private final CountDownLatch latch;
    private boolean shutdown;
    private final Object owner;
    final /* synthetic */ TcpSocketManager this$0;

    public TcpSocketManager$Reconnector(TcpSocketManager tcpSocketManager, OutputStreamManager outputStreamManager) {
        this.this$0 = tcpSocketManager;
        super("TcpSocketManager-Reconnector");
        this.latch = new CountDownLatch(1);
        this.shutdown = false;
        this.owner = outputStreamManager;
    }

    public void latch() {
        try {
            this.latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void shutdown() {
        this.shutdown = true;
    }

    @Override
    public void run() {
        while (!this.shutdown) {
            try {
                TcpSocketManager$Reconnector.sleep(TcpSocketManager.access$000(this.this$0));
                this.reconnect();
            }
            catch (InterruptedException interruptedException) {
                TcpSocketManager.access$100().debug("Reconnection interrupted.");
            }
            catch (ConnectException connectException) {
                TcpSocketManager.access$200().debug("{}:{} refused connection", (Object)this.this$0.host, (Object)this.this$0.port);
            }
            catch (IOException iOException) {
                TcpSocketManager.access$300().debug("Unable to reconnect to {}:{}", (Object)this.this$0.host, (Object)this.this$0.port);
            }
            finally {
                this.latch.countDown();
            }
        }
    }

    void reconnect() {
        List<InetSocketAddress> list = TcpSocketManager$TcpSocketManagerFactory.RESOLVER.resolveHost(this.this$0.host, this.this$0.port);
        if (list.size() != 1) {
            IOException iOException = null;
            for (InetSocketAddress inetSocketAddress : list) {
                try {
                    TcpSocketManager.access$500().debug("Reconnecting " + inetSocketAddress);
                    this.connect(inetSocketAddress);
                    return;
                }
                catch (IOException iOException2) {
                    iOException = iOException2;
                }
            }
            throw iOException;
        }
        TcpSocketManager.access$400().debug("Reconnecting " + list.get(0));
        this.connect(list.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(InetSocketAddress inetSocketAddress) {
        Socket socket = this.this$0.createSocket(inetSocketAddress);
        OutputStream outputStream = socket.getOutputStream();
        InetAddress inetAddress = TcpSocketManager.access$600(this.this$0) != null ? TcpSocketManager.access$600(this.this$0).getInetAddress() : null;
        Object object = this.owner;
        synchronized (object) {
            Closer.closeSilently(TcpSocketManager.access$700(this.this$0));
            TcpSocketManager.access$800(this.this$0, outputStream);
            TcpSocketManager.access$602(this.this$0, socket);
            TcpSocketManager.access$902(this.this$0, null);
            this.shutdown = true;
        }
        object = inetAddress != null && inetAddress.getHostAddress().equals(inetSocketAddress.getAddress().getHostAddress()) ? "reestablished" : "established";
        TcpSocketManager.access$1000().debug("Connection to {}:{} {}: {}", (Object)this.this$0.host, (Object)this.this$0.port, object, (Object)TcpSocketManager.access$600(this.this$0));
    }

    @Override
    public String toString() {
        return "Reconnector [latch=" + this.latch + ", shutdown=" + this.shutdown + "]";
    }
}

