/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.net.SocketOptions;
import org.apache.logging.log4j.core.net.SslSocketManager$SslFactoryData;
import org.apache.logging.log4j.core.net.SslSocketManager$SslSocketManagerFactory;
import org.apache.logging.log4j.core.net.TcpSocketManager;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.util.Strings;

public class SslSocketManager
extends TcpSocketManager {
    public static final int DEFAULT_PORT = 6514;
    private static final SslSocketManager$SslSocketManagerFactory FACTORY = new SslSocketManager$SslSocketManagerFactory(null);
    private final SslConfiguration sslConfig;

    @Deprecated
    public SslSocketManager(String string, OutputStream outputStream, Socket socket, SslConfiguration sslConfiguration, InetAddress inetAddress, String string2, int n, int n2, int n3, boolean bl, Layout<? extends Serializable> layout, int n4) {
        super(string, outputStream, socket, inetAddress, string2, n, n2, n3, bl, layout, n4, null);
        this.sslConfig = sslConfiguration;
    }

    public SslSocketManager(String string, OutputStream outputStream, Socket socket, SslConfiguration sslConfiguration, InetAddress inetAddress, String string2, int n, int n2, int n3, boolean bl, Layout<? extends Serializable> layout, int n4, SocketOptions socketOptions) {
        super(string, outputStream, socket, inetAddress, string2, n, n2, n3, bl, layout, n4, socketOptions);
        this.sslConfig = sslConfiguration;
    }

    @Deprecated
    public static SslSocketManager getSocketManager(SslConfiguration sslConfiguration, String string, int n, int n2, int n3, boolean bl, Layout<? extends Serializable> layout, int n4) {
        return SslSocketManager.getSocketManager(sslConfiguration, string, n, n2, n3, bl, layout, n4, null);
    }

    public static SslSocketManager getSocketManager(SslConfiguration sslConfiguration, String string, int n, int n2, int n3, boolean bl, Layout<? extends Serializable> layout, int n4, SocketOptions socketOptions) {
        if (Strings.isEmpty(string)) {
            throw new IllegalArgumentException("A host name is required");
        }
        if (n <= 0) {
            n = 6514;
        }
        if (n3 == 0) {
            n3 = 30000;
        }
        String string2 = "TLS:" + string + ':' + n;
        return (SslSocketManager)SslSocketManager.getManager(string2, new SslSocketManager$SslFactoryData(sslConfiguration, string, n, n2, n3, bl, layout, n4, socketOptions), FACTORY);
    }

    @Override
    protected Socket createSocket(InetSocketAddress inetSocketAddress) {
        SSLSocketFactory sSLSocketFactory = SslSocketManager.createSslSocketFactory(this.sslConfig);
        Socket socket = sSLSocketFactory.createSocket();
        socket.connect(inetSocketAddress, this.getConnectTimeoutMillis());
        return socket;
    }

    private static SSLSocketFactory createSslSocketFactory(SslConfiguration sslConfiguration) {
        SSLSocketFactory sSLSocketFactory = sslConfiguration != null ? sslConfiguration.getSslSocketFactory() : (SSLSocketFactory)SSLSocketFactory.getDefault();
        return sSLSocketFactory;
    }

    static Socket createSocket(InetSocketAddress inetSocketAddress, int n, SslConfiguration sslConfiguration, SocketOptions socketOptions) {
        SSLSocketFactory sSLSocketFactory = SslSocketManager.createSslSocketFactory(sslConfiguration);
        SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket();
        if (socketOptions != null) {
            socketOptions.apply(sSLSocket);
        }
        sSLSocket.connect(inetSocketAddress, n);
        if (socketOptions != null) {
            socketOptions.apply(sSLSocket);
        }
        return sSLSocket;
    }
}

