/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.lookup.AbstractLookup;

@Plugin(name="event", category="Lookup")
public class EventLookup
extends AbstractLookup {
    @Override
    public String lookup(LogEvent logEvent, String string) {
        if (logEvent == null) {
            return null;
        }
        switch (string) {
            case "Marker": {
                return logEvent.getMarker() != null ? logEvent.getMarker().getName() : null;
            }
            case "ThreadName": {
                return logEvent.getThreadName();
            }
            case "Level": {
                return logEvent.getLevel().toString();
            }
            case "ThreadId": {
                return Long.toString(logEvent.getThreadId());
            }
            case "Timestamp": {
                return Long.toString(logEvent.getTimeMillis());
            }
            case "Exception": {
                if (logEvent.getThrown() != null) {
                    return logEvent.getThrown().getClass().getSimpleName();
                }
                if (logEvent.getThrownProxy() != null) {
                    return logEvent.getThrownProxy().getName();
                }
                return null;
            }
            case "Logger": {
                return logEvent.getLoggerName();
            }
            case "Message": {
                return logEvent.getMessage().getFormattedMessage();
            }
        }
        return null;
    }
}

