/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.LocationAware;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.AbstractStringLayout$Serializer;
import org.apache.logging.log4j.core.layout.AbstractStringLayout$Serializer2;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.Encoder;
import org.apache.logging.log4j.core.layout.PatternLayout$1;
import org.apache.logging.log4j.core.layout.PatternLayout$Builder;
import org.apache.logging.log4j.core.layout.PatternLayout$SerializerBuilder;
import org.apache.logging.log4j.core.layout.PatternSelector;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.core.pattern.RegexReplacement;

@Plugin(name="PatternLayout", category="Core", elementType="layout", printObject=true)
public final class PatternLayout
extends AbstractStringLayout {
    public static final String DEFAULT_CONVERSION_PATTERN = "%m%n";
    public static final String TTCC_CONVERSION_PATTERN = "%r [%t] %p %c %notEmpty{%x }- %m%n";
    public static final String SIMPLE_CONVERSION_PATTERN = "%d [%t] %p %c - %m%n";
    public static final String KEY = "Converter";
    private final String conversionPattern;
    private final PatternSelector patternSelector;
    private final AbstractStringLayout$Serializer eventSerializer;

    private PatternLayout(Configuration configuration, RegexReplacement regexReplacement, String string, PatternSelector patternSelector, Charset charset, boolean bl, boolean bl2, boolean bl3, String string2, String string3) {
        super(configuration, charset, PatternLayout.newSerializerBuilder().setConfiguration(configuration).setReplace(regexReplacement).setPatternSelector(patternSelector).setAlwaysWriteExceptions(bl).setDisableAnsi(bl2).setNoConsoleNoAnsi(bl3).setPattern(string2).build(), PatternLayout.newSerializerBuilder().setConfiguration(configuration).setReplace(regexReplacement).setPatternSelector(patternSelector).setAlwaysWriteExceptions(bl).setDisableAnsi(bl2).setNoConsoleNoAnsi(bl3).setPattern(string3).build());
        this.conversionPattern = string;
        this.patternSelector = patternSelector;
        this.eventSerializer = PatternLayout.newSerializerBuilder().setConfiguration(configuration).setReplace(regexReplacement).setPatternSelector(patternSelector).setAlwaysWriteExceptions(bl).setDisableAnsi(bl2).setNoConsoleNoAnsi(bl3).setPattern(string).setDefaultPattern(DEFAULT_CONVERSION_PATTERN).build();
    }

    public static PatternLayout$SerializerBuilder newSerializerBuilder() {
        return new PatternLayout$SerializerBuilder();
    }

    @Override
    public boolean requiresLocation() {
        return this.eventSerializer instanceof LocationAware && ((LocationAware)((Object)this.eventSerializer)).requiresLocation();
    }

    @Deprecated
    public static AbstractStringLayout$Serializer createSerializer(Configuration configuration, RegexReplacement regexReplacement, String string, String string2, PatternSelector patternSelector, boolean bl, boolean bl2) {
        PatternLayout$SerializerBuilder patternLayout$SerializerBuilder = PatternLayout.newSerializerBuilder();
        patternLayout$SerializerBuilder.setAlwaysWriteExceptions(bl);
        patternLayout$SerializerBuilder.setConfiguration(configuration);
        patternLayout$SerializerBuilder.setDefaultPattern(string2);
        patternLayout$SerializerBuilder.setNoConsoleNoAnsi(bl2);
        patternLayout$SerializerBuilder.setPattern(string);
        patternLayout$SerializerBuilder.setPatternSelector(patternSelector);
        patternLayout$SerializerBuilder.setReplace(regexReplacement);
        return patternLayout$SerializerBuilder.build();
    }

    public String getConversionPattern() {
        return this.conversionPattern;
    }

    @Override
    public Map<String, String> getContentFormat() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("structured", "false");
        hashMap.put("formatType", "conversion");
        hashMap.put("format", this.conversionPattern);
        return hashMap;
    }

    @Override
    public String toSerializable(LogEvent logEvent) {
        return this.eventSerializer.toSerializable(logEvent);
    }

    public void serialize(LogEvent logEvent, StringBuilder stringBuilder) {
        this.eventSerializer.toSerializable(logEvent, stringBuilder);
    }

    @Override
    public void encode(LogEvent logEvent, ByteBufferDestination byteBufferDestination) {
        StringBuilder stringBuilder = this.toText(this.eventSerializer, logEvent, PatternLayout.getStringBuilder());
        Encoder<StringBuilder> encoder = this.getStringBuilderEncoder();
        encoder.encode(stringBuilder, byteBufferDestination);
        PatternLayout.trimToMaxSize(stringBuilder);
    }

    private StringBuilder toText(AbstractStringLayout$Serializer2 abstractStringLayout$Serializer2, LogEvent logEvent, StringBuilder stringBuilder) {
        return abstractStringLayout$Serializer2.toSerializable(logEvent, stringBuilder);
    }

    public static PatternParser createPatternParser(Configuration configuration) {
        if (configuration == null) {
            return new PatternParser(configuration, KEY, LogEventPatternConverter.class);
        }
        PatternParser patternParser = (PatternParser)configuration.getComponent(KEY);
        if (patternParser == null) {
            patternParser = new PatternParser(configuration, KEY, LogEventPatternConverter.class);
            configuration.addComponent(KEY, patternParser);
            patternParser = (PatternParser)configuration.getComponent(KEY);
        }
        return patternParser;
    }

    public String toString() {
        return this.patternSelector == null ? this.conversionPattern : this.patternSelector.toString();
    }

    @PluginFactory
    @Deprecated
    public static PatternLayout createLayout(@PluginAttribute(value="pattern", defaultString="%m%n") String string, @PluginElement(value="PatternSelector") PatternSelector patternSelector, @PluginConfiguration Configuration configuration, @PluginElement(value="Replace") RegexReplacement regexReplacement, @PluginAttribute(value="charset") Charset charset, @PluginAttribute(value="alwaysWriteExceptions", defaultBoolean=true) boolean bl, @PluginAttribute(value="noConsoleNoAnsi") boolean bl2, @PluginAttribute(value="header") String string2, @PluginAttribute(value="footer") String string3) {
        return PatternLayout.newBuilder().withPattern(string).withPatternSelector(patternSelector).withConfiguration(configuration).withRegexReplacement(regexReplacement).withCharset(charset).withAlwaysWriteExceptions(bl).withNoConsoleNoAnsi(bl2).withHeader(string2).withFooter(string3).build();
    }

    public static PatternLayout createDefaultLayout() {
        return PatternLayout.newBuilder().build();
    }

    public static PatternLayout createDefaultLayout(Configuration configuration) {
        return PatternLayout.newBuilder().withConfiguration(configuration).build();
    }

    @PluginBuilderFactory
    public static PatternLayout$Builder newBuilder() {
        return new PatternLayout$Builder(null);
    }

    public AbstractStringLayout$Serializer getEventSerializer() {
        return this.eventSerializer;
    }

    /* synthetic */ PatternLayout(Configuration configuration, RegexReplacement regexReplacement, String string, PatternSelector patternSelector, Charset charset, boolean bl, boolean bl2, boolean bl3, String string2, String string3, PatternLayout$1 patternLayout$1) {
        this(configuration, regexReplacement, string, patternSelector, charset, bl, bl2, bl3, string2, string3);
    }
}

