/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.util.List;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.layout.AbstractStringLayout$Serializer;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.layout.PatternLayout$NoFormatPatternSerializer;
import org.apache.logging.log4j.core.layout.PatternLayout$PatternFormatterPatternSerializer;
import org.apache.logging.log4j.core.layout.PatternLayout$PatternSelectorSerializer;
import org.apache.logging.log4j.core.layout.PatternLayout$PatternSerializer;
import org.apache.logging.log4j.core.layout.PatternLayout$PatternSerializerWithReplacement;
import org.apache.logging.log4j.core.layout.PatternSelector;
import org.apache.logging.log4j.core.pattern.FormattingInfo;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.core.pattern.RegexReplacement;
import org.apache.logging.log4j.core.util.Builder;
import org.apache.logging.log4j.util.Strings;

public class PatternLayout$SerializerBuilder
implements Builder<AbstractStringLayout$Serializer> {
    private Configuration configuration;
    private RegexReplacement replace;
    private String pattern;
    private String defaultPattern;
    private PatternSelector patternSelector;
    private boolean alwaysWriteExceptions;
    private boolean disableAnsi;
    private boolean noConsoleNoAnsi;

    @Override
    public AbstractStringLayout$Serializer build() {
        if (Strings.isEmpty(this.pattern) && Strings.isEmpty(this.defaultPattern)) {
            return null;
        }
        if (this.patternSelector == null) {
            try {
                PatternParser patternParser = PatternLayout.createPatternParser(this.configuration);
                List<PatternFormatter> list = patternParser.parse(this.pattern == null ? this.defaultPattern : this.pattern, this.alwaysWriteExceptions, this.disableAnsi, this.noConsoleNoAnsi);
                PatternFormatter[] patternFormatterArray = list.toArray(PatternFormatter.EMPTY_ARRAY);
                boolean bl = false;
                for (PatternFormatter patternFormatter : patternFormatterArray) {
                    FormattingInfo formattingInfo = patternFormatter.getFormattingInfo();
                    if (formattingInfo == null || formattingInfo == FormattingInfo.getDefault()) continue;
                    bl = true;
                    break;
                }
                PatternLayout$PatternSerializer patternLayout$PatternSerializer = bl ? new PatternLayout$PatternFormatterPatternSerializer(patternFormatterArray, null) : new PatternLayout$NoFormatPatternSerializer(patternFormatterArray, null);
                return this.replace == null ? patternLayout$PatternSerializer : new PatternLayout$PatternSerializerWithReplacement(patternLayout$PatternSerializer, this.replace, null);
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalArgumentException("Cannot parse pattern '" + this.pattern + "'", runtimeException);
            }
        }
        return new PatternLayout$PatternSelectorSerializer(this.patternSelector, this.replace, null);
    }

    public PatternLayout$SerializerBuilder setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public PatternLayout$SerializerBuilder setReplace(RegexReplacement regexReplacement) {
        this.replace = regexReplacement;
        return this;
    }

    public PatternLayout$SerializerBuilder setPattern(String string) {
        this.pattern = string;
        return this;
    }

    public PatternLayout$SerializerBuilder setDefaultPattern(String string) {
        this.defaultPattern = string;
        return this;
    }

    public PatternLayout$SerializerBuilder setPatternSelector(PatternSelector patternSelector) {
        this.patternSelector = patternSelector;
        return this;
    }

    public PatternLayout$SerializerBuilder setAlwaysWriteExceptions(boolean bl) {
        this.alwaysWriteExceptions = bl;
        return this;
    }

    public PatternLayout$SerializerBuilder setDisableAnsi(boolean bl) {
        this.disableAnsi = bl;
        return this;
    }

    public PatternLayout$SerializerBuilder setNoConsoleNoAnsi(boolean bl) {
        this.noConsoleNoAnsi = bl;
        return this;
    }
}

