/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.HtmlLayout$1;
import org.apache.logging.log4j.core.layout.HtmlLayout$Builder;
import org.apache.logging.log4j.core.layout.HtmlLayout$FontSize;
import org.apache.logging.log4j.core.pattern.DatePatternConverter;
import org.apache.logging.log4j.core.util.Transform;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="HtmlLayout", category="Core", elementType="layout", printObject=true)
public final class HtmlLayout
extends AbstractStringLayout {
    public static final String DEFAULT_FONT_FAMILY = "arial,sans-serif";
    private static final String TRACE_PREFIX = "<br />&nbsp;&nbsp;&nbsp;&nbsp;";
    private static final String REGEXP = Strings.LINE_SEPARATOR.equals("\n") ? "\n" : Strings.LINE_SEPARATOR + "|\n";
    private static final String DEFAULT_TITLE = "Log4j Log Messages";
    private static final String DEFAULT_CONTENT_TYPE = "text/html";
    private static final String DEFAULT_DATE_PATTERN = "JVM_ELAPSE_TIME";
    private final long jvmStartTime = ManagementFactory.getRuntimeMXBean().getStartTime();
    private final boolean locationInfo;
    private final String title;
    private final String contentType;
    private final String font;
    private final String fontSize;
    private final String headerSize;
    private final DatePatternConverter datePatternConverter;

    private HtmlLayout(boolean bl, String string, String string2, Charset charset, String string3, String string4, String string5, String string6, String string7) {
        super(charset);
        this.locationInfo = bl;
        this.title = string;
        this.contentType = this.addCharsetToContentType(string2);
        this.font = string3;
        this.fontSize = string4;
        this.headerSize = string5;
        this.datePatternConverter = DEFAULT_DATE_PATTERN.equals(string6) ? null : DatePatternConverter.newInstance(new String[]{string6, string7});
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isLocationInfo() {
        return this.locationInfo;
    }

    @Override
    public boolean requiresLocation() {
        return this.locationInfo;
    }

    private String addCharsetToContentType(String string) {
        if (string == null) {
            return "text/html; charset=" + this.getCharset();
        }
        return string.contains("charset") ? string : string + "; charset=" + this.getCharset();
    }

    @Override
    public String toSerializable(LogEvent logEvent) {
        Serializable serializable;
        StringBuilder stringBuilder = HtmlLayout.getStringBuilder();
        stringBuilder.append(Strings.LINE_SEPARATOR).append("<tr>").append(Strings.LINE_SEPARATOR);
        stringBuilder.append("<td>");
        if (this.datePatternConverter == null) {
            stringBuilder.append(logEvent.getTimeMillis() - this.jvmStartTime);
        } else {
            this.datePatternConverter.format(logEvent, stringBuilder);
        }
        stringBuilder.append("</td>").append(Strings.LINE_SEPARATOR);
        String string = Transform.escapeHtmlTags(logEvent.getThreadName());
        stringBuilder.append("<td title=\"").append(string).append(" thread\">");
        stringBuilder.append(string);
        stringBuilder.append("</td>").append(Strings.LINE_SEPARATOR);
        stringBuilder.append("<td title=\"Level\">");
        if (logEvent.getLevel().equals(Level.DEBUG)) {
            stringBuilder.append("<font color=\"#339933\">");
            stringBuilder.append(Transform.escapeHtmlTags(String.valueOf(logEvent.getLevel())));
            stringBuilder.append("</font>");
        } else if (logEvent.getLevel().isMoreSpecificThan(Level.WARN)) {
            stringBuilder.append("<font color=\"#993300\"><strong>");
            stringBuilder.append(Transform.escapeHtmlTags(String.valueOf(logEvent.getLevel())));
            stringBuilder.append("</strong></font>");
        } else {
            stringBuilder.append(Transform.escapeHtmlTags(String.valueOf(logEvent.getLevel())));
        }
        stringBuilder.append("</td>").append(Strings.LINE_SEPARATOR);
        String string2 = Transform.escapeHtmlTags(logEvent.getLoggerName());
        if (Strings.isEmpty(string2)) {
            string2 = "root";
        }
        stringBuilder.append("<td title=\"").append(string2).append(" logger\">");
        stringBuilder.append(string2);
        stringBuilder.append("</td>").append(Strings.LINE_SEPARATOR);
        if (this.locationInfo) {
            serializable = logEvent.getSource();
            stringBuilder.append("<td>");
            stringBuilder.append(Transform.escapeHtmlTags(serializable.getFileName()));
            stringBuilder.append(':');
            stringBuilder.append(serializable.getLineNumber());
            stringBuilder.append("</td>").append(Strings.LINE_SEPARATOR);
        }
        stringBuilder.append("<td title=\"Message\">");
        stringBuilder.append(Transform.escapeHtmlTags(logEvent.getMessage().getFormattedMessage()).replaceAll(REGEXP, "<br />"));
        stringBuilder.append("</td>").append(Strings.LINE_SEPARATOR);
        stringBuilder.append("</tr>").append(Strings.LINE_SEPARATOR);
        if (logEvent.getContextStack() != null && !logEvent.getContextStack().isEmpty()) {
            stringBuilder.append("<tr><td bgcolor=\"#EEEEEE\" style=\"font-size : ").append(this.fontSize);
            stringBuilder.append(";\" colspan=\"6\" ");
            stringBuilder.append("title=\"Nested Diagnostic Context\">");
            stringBuilder.append("NDC: ").append(Transform.escapeHtmlTags(logEvent.getContextStack().toString()));
            stringBuilder.append("</td></tr>").append(Strings.LINE_SEPARATOR);
        }
        if (logEvent.getContextData() != null && !logEvent.getContextData().isEmpty()) {
            stringBuilder.append("<tr><td bgcolor=\"#EEEEEE\" style=\"font-size : ").append(this.fontSize);
            stringBuilder.append(";\" colspan=\"6\" ");
            stringBuilder.append("title=\"Mapped Diagnostic Context\">");
            stringBuilder.append("MDC: ").append(Transform.escapeHtmlTags(logEvent.getContextData().toMap().toString()));
            stringBuilder.append("</td></tr>").append(Strings.LINE_SEPARATOR);
        }
        if ((serializable = logEvent.getThrown()) != null) {
            stringBuilder.append("<tr><td bgcolor=\"#993300\" style=\"color:White; font-size : ").append(this.fontSize);
            stringBuilder.append(";\" colspan=\"6\">");
            this.appendThrowableAsHtml((Throwable)serializable, stringBuilder);
            stringBuilder.append("</td></tr>").append(Strings.LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    private void appendThrowableAsHtml(Throwable throwable, StringBuilder stringBuilder) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        try {
            throwable.printStackTrace(printWriter);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        printWriter.flush();
        LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(stringWriter.toString()));
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string = lineNumberReader.readLine();
            while (string != null) {
                arrayList.add(string);
                string = lineNumberReader.readLine();
            }
        }
        catch (IOException iOException) {
            if (iOException instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            arrayList.add(iOException.toString());
        }
        boolean bl = true;
        for (String string : arrayList) {
            if (!bl) {
                stringBuilder.append(TRACE_PREFIX);
            } else {
                bl = false;
            }
            stringBuilder.append(Transform.escapeHtmlTags(string));
            stringBuilder.append(Strings.LINE_SEPARATOR);
        }
    }

    private StringBuilder appendLs(StringBuilder stringBuilder, String string) {
        stringBuilder.append(string).append(Strings.LINE_SEPARATOR);
        return stringBuilder;
    }

    private StringBuilder append(StringBuilder stringBuilder, String string) {
        stringBuilder.append(string);
        return stringBuilder;
    }

    @Override
    public byte[] getHeader() {
        StringBuilder stringBuilder = new StringBuilder();
        this.append(stringBuilder, "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" ");
        this.appendLs(stringBuilder, "\"http://www.w3.org/TR/html4/loose.dtd\">");
        this.appendLs(stringBuilder, "<html>");
        this.appendLs(stringBuilder, "<head>");
        this.append(stringBuilder, "<meta charset=\"");
        this.append(stringBuilder, this.getCharset().toString());
        this.appendLs(stringBuilder, "\"/>");
        this.append(stringBuilder, "<title>").append(this.title);
        this.appendLs(stringBuilder, "</title>");
        this.appendLs(stringBuilder, "<style type=\"text/css\">");
        this.appendLs(stringBuilder, "<!--");
        this.append(stringBuilder, "body, table {font-family:").append(this.font).append("; font-size: ");
        this.appendLs(stringBuilder, this.headerSize).append(";}");
        this.appendLs(stringBuilder, "th {background: #336699; color: #FFFFFF; text-align: left;}");
        this.appendLs(stringBuilder, "-->");
        this.appendLs(stringBuilder, "</style>");
        this.appendLs(stringBuilder, "</head>");
        this.appendLs(stringBuilder, "<body bgcolor=\"#FFFFFF\" topmargin=\"6\" leftmargin=\"6\">");
        this.appendLs(stringBuilder, "<hr size=\"1\" noshade=\"noshade\">");
        this.appendLs(stringBuilder, "Log session start time " + new Date() + "<br>");
        this.appendLs(stringBuilder, "<br>");
        this.appendLs(stringBuilder, "<table cellspacing=\"0\" cellpadding=\"4\" border=\"1\" bordercolor=\"#224466\" width=\"100%\">");
        this.appendLs(stringBuilder, "<tr>");
        this.appendLs(stringBuilder, "<th>Time</th>");
        this.appendLs(stringBuilder, "<th>Thread</th>");
        this.appendLs(stringBuilder, "<th>Level</th>");
        this.appendLs(stringBuilder, "<th>Logger</th>");
        if (this.locationInfo) {
            this.appendLs(stringBuilder, "<th>File:Line</th>");
        }
        this.appendLs(stringBuilder, "<th>Message</th>");
        this.appendLs(stringBuilder, "</tr>");
        return stringBuilder.toString().getBytes(this.getCharset());
    }

    @Override
    public byte[] getFooter() {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendLs(stringBuilder, "</table>");
        this.appendLs(stringBuilder, "<br>");
        this.appendLs(stringBuilder, "</body></html>");
        return this.getBytes(stringBuilder.toString());
    }

    @Deprecated
    @PluginFactory
    public static HtmlLayout createLayout(@PluginAttribute(value="locationInfo") boolean bl, @PluginAttribute(value="title", defaultString="Log4j Log Messages") String string, @PluginAttribute(value="contentType") String string2, @PluginAttribute(value="charset", defaultString="UTF-8") Charset charset, @PluginAttribute(value="fontSize") String string3, @PluginAttribute(value="fontName", defaultString="arial,sans-serif") String string4) {
        HtmlLayout$FontSize htmlLayout$FontSize = HtmlLayout$FontSize.getFontSize(string3);
        string3 = htmlLayout$FontSize.getFontSize();
        String string5 = htmlLayout$FontSize.larger().getFontSize();
        if (string2 == null) {
            string2 = "text/html; charset=" + charset;
        }
        return new HtmlLayout(bl, string, string2, charset, string4, string3, string5, DEFAULT_DATE_PATTERN, null);
    }

    public static HtmlLayout createDefaultLayout() {
        return HtmlLayout.newBuilder().build();
    }

    @PluginBuilderFactory
    public static HtmlLayout$Builder newBuilder() {
        return new HtmlLayout$Builder(null);
    }

    /* synthetic */ HtmlLayout(boolean bl, String string, String string2, Charset charset, String string3, String string4, String string5, String string6, String string7, HtmlLayout$1 htmlLayout$1) {
        this(bl, string, string2, charset, string3, string4, string5, string6, string7);
    }
}

