/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.layout.AbstractJacksonLayout$LogEventWithAdditionalFields;
import org.apache.logging.log4j.core.layout.AbstractJacksonLayout$ReadOnlyLogEventWrapper;
import org.apache.logging.log4j.core.layout.AbstractJacksonLayout$ResolvableKeyValuePair;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.core.util.StringBuilderWriter;
import org.apache.logging.log4j.message.Message;

abstract class AbstractJacksonLayout
extends AbstractStringLayout {
    protected static final String DEFAULT_EOL = "\r\n";
    protected static final String COMPACT_EOL = "";
    protected final String eol;
    protected final ObjectWriter objectWriter;
    protected final boolean compact;
    protected final boolean complete;
    protected final boolean includeNullDelimiter;
    protected final AbstractJacksonLayout$ResolvableKeyValuePair[] additionalFields;

    @Deprecated
    protected AbstractJacksonLayout(Configuration configuration, ObjectWriter objectWriter, Charset charset, boolean bl, boolean bl2, boolean bl3, AbstractStringLayout.Serializer serializer, AbstractStringLayout.Serializer serializer2) {
        this(configuration, objectWriter, charset, bl, bl2, bl3, serializer, serializer2, false);
    }

    @Deprecated
    protected AbstractJacksonLayout(Configuration configuration, ObjectWriter objectWriter, Charset charset, boolean bl, boolean bl2, boolean bl3, AbstractStringLayout.Serializer serializer, AbstractStringLayout.Serializer serializer2, boolean bl4) {
        this(configuration, objectWriter, charset, bl, bl2, bl3, null, serializer, serializer2, bl4, null);
    }

    protected AbstractJacksonLayout(Configuration configuration, ObjectWriter objectWriter, Charset charset, boolean bl, boolean bl2, boolean bl3, String string, AbstractStringLayout.Serializer serializer, AbstractStringLayout.Serializer serializer2, boolean bl4, KeyValuePair[] keyValuePairArray) {
        super(configuration, charset, serializer, serializer2);
        this.objectWriter = objectWriter;
        this.compact = bl;
        this.complete = bl2;
        this.eol = string != null ? string : (bl && !bl3 ? COMPACT_EOL : DEFAULT_EOL);
        this.includeNullDelimiter = bl4;
        this.additionalFields = AbstractJacksonLayout.prepareAdditionalFields(configuration, keyValuePairArray);
    }

    protected static boolean valueNeedsLookup(String string) {
        return string != null && string.contains("${");
    }

    private static AbstractJacksonLayout$ResolvableKeyValuePair[] prepareAdditionalFields(Configuration configuration, KeyValuePair[] keyValuePairArray) {
        if (keyValuePairArray == null || keyValuePairArray.length == 0) {
            return AbstractJacksonLayout$ResolvableKeyValuePair.EMPTY_ARRAY;
        }
        AbstractJacksonLayout$ResolvableKeyValuePair[] abstractJacksonLayout$ResolvableKeyValuePairArray = new AbstractJacksonLayout$ResolvableKeyValuePair[keyValuePairArray.length];
        for (int i = 0; i < keyValuePairArray.length; ++i) {
            AbstractJacksonLayout$ResolvableKeyValuePair abstractJacksonLayout$ResolvableKeyValuePair = abstractJacksonLayout$ResolvableKeyValuePairArray[i] = new AbstractJacksonLayout$ResolvableKeyValuePair(keyValuePairArray[i]);
            if (configuration != null || !abstractJacksonLayout$ResolvableKeyValuePair.valueNeedsLookup) continue;
            throw new IllegalArgumentException("configuration needs to be set when there are additional fields with variables");
        }
        return abstractJacksonLayout$ResolvableKeyValuePairArray;
    }

    @Override
    public String toSerializable(LogEvent logEvent) {
        StringBuilderWriter stringBuilderWriter = new StringBuilderWriter();
        try {
            this.toSerializable(logEvent, stringBuilderWriter);
            return stringBuilderWriter.toString();
        }
        catch (IOException iOException) {
            LOGGER.error(iOException);
            return COMPACT_EOL;
        }
    }

    private static LogEvent convertMutableToLog4jEvent(LogEvent logEvent) {
        return logEvent instanceof Log4jLogEvent ? logEvent : Log4jLogEvent.createMemento(logEvent);
    }

    protected Object wrapLogEvent(LogEvent logEvent) {
        if (this.additionalFields.length > 0) {
            Map<String, String> map = this.resolveAdditionalFields(logEvent);
            return new AbstractJacksonLayout$LogEventWithAdditionalFields(logEvent, map);
        }
        if (logEvent instanceof Message) {
            return new AbstractJacksonLayout$ReadOnlyLogEventWrapper(logEvent);
        }
        return logEvent;
    }

    private Map<String, String> resolveAdditionalFields(LogEvent logEvent) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(this.additionalFields.length);
        StrSubstitutor strSubstitutor = this.configuration.getStrSubstitutor();
        for (AbstractJacksonLayout$ResolvableKeyValuePair abstractJacksonLayout$ResolvableKeyValuePair : this.additionalFields) {
            if (abstractJacksonLayout$ResolvableKeyValuePair.valueNeedsLookup) {
                linkedHashMap.put(abstractJacksonLayout$ResolvableKeyValuePair.key, strSubstitutor.replace(logEvent, abstractJacksonLayout$ResolvableKeyValuePair.value));
                continue;
            }
            linkedHashMap.put(abstractJacksonLayout$ResolvableKeyValuePair.key, abstractJacksonLayout$ResolvableKeyValuePair.value);
        }
        return linkedHashMap;
    }

    public void toSerializable(LogEvent logEvent, Writer writer) {
        this.objectWriter.writeValue(writer, this.wrapLogEvent(AbstractJacksonLayout.convertMutableToLog4jEvent(logEvent)));
        writer.write(this.eol);
        if (this.includeNullDelimiter) {
            writer.write(0);
        }
        this.markEvent();
    }
}

