/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext$ContextStack;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.ContextDataFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.impl.MutableLogEvent;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ReusableMessage;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.StringMap;

class Log4jLogEvent$LogEventProxy
implements Serializable {
    private static final long serialVersionUID = -8634075037355293699L;
    private final String loggerFQCN;
    private final Marker marker;
    private final Level level;
    private final String loggerName;
    private final transient Message message;
    private MarshalledObject<Message> marshalledMessage;
    private String messageString;
    private final long timeMillis;
    private final int nanoOfMillisecond;
    private final transient Throwable thrown;
    private final ThrowableProxy thrownProxy;
    private final StringMap contextData;
    private final ThreadContext$ContextStack contextStack;
    private final long threadId;
    private final String threadName;
    private final int threadPriority;
    private final StackTraceElement source;
    private final boolean isLocationRequired;
    private final boolean isEndOfBatch;
    private final transient long nanoTime;

    public Log4jLogEvent$LogEventProxy(Log4jLogEvent log4jLogEvent, boolean bl) {
        this.loggerFQCN = Log4jLogEvent.access$2700(log4jLogEvent);
        this.marker = Log4jLogEvent.access$2800(log4jLogEvent);
        this.level = Log4jLogEvent.access$2900(log4jLogEvent);
        this.loggerName = Log4jLogEvent.access$3000(log4jLogEvent);
        this.message = Log4jLogEvent.access$3100(log4jLogEvent) instanceof ReusableMessage ? Log4jLogEvent$LogEventProxy.memento((ReusableMessage)Log4jLogEvent.access$3100(log4jLogEvent)) : Log4jLogEvent.access$3100(log4jLogEvent);
        this.timeMillis = Log4jLogEvent.access$3200(log4jLogEvent).getEpochMillisecond();
        this.nanoOfMillisecond = Log4jLogEvent.access$3200(log4jLogEvent).getNanoOfMillisecond();
        this.thrown = Log4jLogEvent.access$3300(log4jLogEvent);
        this.thrownProxy = Log4jLogEvent.access$200(log4jLogEvent);
        this.contextData = Log4jLogEvent.access$100(log4jLogEvent);
        this.contextStack = Log4jLogEvent.access$3400(log4jLogEvent);
        this.source = bl ? log4jLogEvent.getSource() : Log4jLogEvent.access$300(log4jLogEvent);
        this.threadId = log4jLogEvent.getThreadId();
        this.threadName = log4jLogEvent.getThreadName();
        this.threadPriority = log4jLogEvent.getThreadPriority();
        this.isLocationRequired = bl;
        this.isEndOfBatch = Log4jLogEvent.access$3500(log4jLogEvent);
        this.nanoTime = Log4jLogEvent.access$3600(log4jLogEvent);
    }

    public Log4jLogEvent$LogEventProxy(LogEvent logEvent, boolean bl) {
        this.loggerFQCN = logEvent.getLoggerFqcn();
        this.marker = logEvent.getMarker();
        this.level = logEvent.getLevel();
        this.loggerName = logEvent.getLoggerName();
        Message message = logEvent.getMessage();
        this.message = message instanceof ReusableMessage ? Log4jLogEvent$LogEventProxy.memento((ReusableMessage)message) : message;
        this.timeMillis = logEvent.getInstant().getEpochMillisecond();
        this.nanoOfMillisecond = logEvent.getInstant().getNanoOfMillisecond();
        this.thrown = logEvent.getThrown();
        this.thrownProxy = logEvent.getThrownProxy();
        this.contextData = Log4jLogEvent$LogEventProxy.memento(logEvent.getContextData());
        this.contextStack = logEvent.getContextStack();
        this.source = bl ? logEvent.getSource() : (logEvent instanceof MutableLogEvent ? ((MutableLogEvent)logEvent).source : null);
        this.threadId = logEvent.getThreadId();
        this.threadName = logEvent.getThreadName();
        this.threadPriority = logEvent.getThreadPriority();
        this.isLocationRequired = bl;
        this.isEndOfBatch = logEvent.isEndOfBatch();
        this.nanoTime = logEvent.getNanoTime();
    }

    private static Message memento(ReusableMessage reusableMessage) {
        return reusableMessage.memento();
    }

    private static StringMap memento(ReadOnlyStringMap readOnlyStringMap) {
        StringMap stringMap = ContextDataFactory.createContextData();
        stringMap.putAll(readOnlyStringMap);
        return stringMap;
    }

    private static MarshalledObject<Message> marshall(Message message) {
        try {
            return new MarshalledObject<Message>(message);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        this.messageString = this.message.getFormattedMessage();
        this.marshalledMessage = Log4jLogEvent$LogEventProxy.marshall(this.message);
        objectOutputStream.defaultWriteObject();
    }

    protected Object readResolve() {
        Log4jLogEvent log4jLogEvent = new Log4jLogEvent(this.loggerName, this.marker, this.loggerFQCN, this.level, this.message(), this.thrown, this.thrownProxy, this.contextData, this.contextStack, this.threadId, this.threadName, this.threadPriority, this.source, this.timeMillis, this.nanoOfMillisecond, this.nanoTime, null);
        log4jLogEvent.setEndOfBatch(this.isEndOfBatch);
        log4jLogEvent.setIncludeLocation(this.isLocationRequired);
        return log4jLogEvent;
    }

    private Message message() {
        if (this.marshalledMessage != null) {
            try {
                return this.marshalledMessage.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new SimpleMessage(this.messageString);
    }

    static /* synthetic */ String access$900(Log4jLogEvent$LogEventProxy log4jLogEvent$LogEventProxy) {
        return log4jLogEvent$LogEventProxy.loggerName;
    }

    static /* synthetic */ Marker access$1000(Log4jLogEvent$LogEventProxy log4jLogEvent$LogEventProxy) {
        return log4jLogEvent$LogEventProxy.marker;
    }

    static /* synthetic */ String access$1100(Log4jLogEvent$LogEventProxy log4jLogEvent$LogEventProxy) {
        return log4jLogEvent$LogEventProxy.loggerFQCN;
    }

    static /* synthetic */ Level access$1200(Log4jLogEvent$LogEventProxy log4jLogEvent$LogEventProxy) {
        return log4jLogEvent$LogEventProxy.level;
    }

    static /* synthetic */ Message access$1300(Log4jLogEvent$LogEventProxy log4jLogEvent$LogEventProxy) {
        return log4jLogEvent$LogEventProxy.message;
    }

    static /* synthetic */ Throwable access$1400(Log4jLogEvent$LogEventProxy log4jLogEvent$LogEventProxy) {
        return log4jLogEvent$LogEventProxy.thrown;
    }

    static /* synthetic */ ThrowableProxy access$1500(Log4jLogEvent$LogEventProxy log4jLogEvent$LogEventProxy) {
        return log4jLogEvent$LogEventProxy.thrownProxy;
    }

    static /* synthetic */ StringMap access$1600(Log4jLogEvent$LogEventProxy log4jLogEvent$LogEventProxy) {
        return log4jLogEvent$LogEventProxy.contextData;
    }

    static /* synthetic */ ThreadContext$ContextStack access$1700(Log4jLogEvent$LogEventProxy log4jLogEvent$LogEventProxy) {
        return log4jLogEvent$LogEventProxy.contextStack;
    }

    static /* synthetic */ long access$1800(Log4jLogEvent$LogEventProxy log4jLogEvent$LogEventProxy) {
        return log4jLogEvent$LogEventProxy.threadId;
    }

    static /* synthetic */ String access$1900(Log4jLogEvent$LogEventProxy log4jLogEvent$LogEventProxy) {
        return log4jLogEvent$LogEventProxy.threadName;
    }

    static /* synthetic */ int access$2000(Log4jLogEvent$LogEventProxy log4jLogEvent$LogEventProxy) {
        return log4jLogEvent$LogEventProxy.threadPriority;
    }

    static /* synthetic */ StackTraceElement access$2100(Log4jLogEvent$LogEventProxy log4jLogEvent$LogEventProxy) {
        return log4jLogEvent$LogEventProxy.source;
    }

    static /* synthetic */ long access$2200(Log4jLogEvent$LogEventProxy log4jLogEvent$LogEventProxy) {
        return log4jLogEvent$LogEventProxy.timeMillis;
    }

    static /* synthetic */ int access$2300(Log4jLogEvent$LogEventProxy log4jLogEvent$LogEventProxy) {
        return log4jLogEvent$LogEventProxy.nanoOfMillisecond;
    }

    static /* synthetic */ long access$2400(Log4jLogEvent$LogEventProxy log4jLogEvent$LogEventProxy) {
        return log4jLogEvent$LogEventProxy.nanoTime;
    }

    static /* synthetic */ boolean access$2500(Log4jLogEvent$LogEventProxy log4jLogEvent$LogEventProxy) {
        return log4jLogEvent$LogEventProxy.isEndOfBatch;
    }

    static /* synthetic */ boolean access$2600(Log4jLogEvent$LogEventProxy log4jLogEvent$LogEventProxy) {
        return log4jLogEvent$LogEventProxy.isLocationRequired;
    }
}

