/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Filter$Result;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.ConfigurationScheduler;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAliases;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.filter.MutableThreadContextMapFilter$1;
import org.apache.logging.log4j.core.filter.MutableThreadContextMapFilter$Builder;
import org.apache.logging.log4j.core.filter.MutableThreadContextMapFilter$ConfigResult;
import org.apache.logging.log4j.core.filter.MutableThreadContextMapFilter$FileMonitor;
import org.apache.logging.log4j.core.filter.MutableThreadContextMapFilter$FilterConfigUpdateListener;
import org.apache.logging.log4j.core.filter.mutable.KeyValuePairConfig;
import org.apache.logging.log4j.core.util.AuthorizationProvider;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.core.util.internal.HttpInputStreamUtil;
import org.apache.logging.log4j.core.util.internal.HttpInputStreamUtil$Result;
import org.apache.logging.log4j.core.util.internal.LastModifiedSource;
import org.apache.logging.log4j.core.util.internal.Status;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.PerformanceSensitive;

@Plugin(name="MutableThreadContextMapFilter", category="Core", elementType="filter", printObject=true)
@PluginAliases(value={"MutableContextMapFilter"})
@PerformanceSensitive(value={"allocation"})
public class MutableThreadContextMapFilter
extends AbstractFilter {
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final KeyValuePair[] EMPTY_ARRAY = new KeyValuePair[0];
    private volatile Filter filter;
    private final long pollInterval;
    private final ConfigurationScheduler scheduler;
    private final LastModifiedSource source;
    private final AuthorizationProvider authorizationProvider;
    private final List<MutableThreadContextMapFilter$FilterConfigUpdateListener> listeners = new ArrayList<MutableThreadContextMapFilter$FilterConfigUpdateListener>();
    private ScheduledFuture<?> future = null;

    private MutableThreadContextMapFilter(Filter filter, LastModifiedSource lastModifiedSource, long l, AuthorizationProvider authorizationProvider, Filter$Result filter$Result, Filter$Result filter$Result2, Configuration configuration) {
        super(filter$Result, filter$Result2);
        this.filter = filter;
        this.pollInterval = l;
        this.source = lastModifiedSource;
        this.scheduler = configuration.getScheduler();
        this.authorizationProvider = authorizationProvider;
    }

    @Override
    public void start() {
        if (this.pollInterval > 0L) {
            this.future = this.scheduler.scheduleWithFixedDelay(new MutableThreadContextMapFilter$FileMonitor(this, null), 0L, this.pollInterval, TimeUnit.SECONDS);
            LOGGER.debug("Watching {} with poll interval {}", (Object)this.source.toString(), (Object)this.pollInterval);
        }
        super.start();
    }

    @Override
    public boolean stop(long l, TimeUnit timeUnit) {
        this.future.cancel(true);
        return super.stop(l, timeUnit);
    }

    public void registerListener(MutableThreadContextMapFilter$FilterConfigUpdateListener mutableThreadContextMapFilter$FilterConfigUpdateListener) {
        this.listeners.add(mutableThreadContextMapFilter$FilterConfigUpdateListener);
    }

    @PluginBuilderFactory
    public static MutableThreadContextMapFilter$Builder newBuilder() {
        return new MutableThreadContextMapFilter$Builder();
    }

    @Override
    public Filter$Result filter(LogEvent logEvent) {
        return this.filter.filter(logEvent);
    }

    @Override
    public Filter$Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, Message message, Throwable throwable) {
        return this.filter.filter(logger, level, marker, message, throwable);
    }

    @Override
    public Filter$Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, Object object, Throwable throwable) {
        return this.filter.filter(logger, level, marker, object, throwable);
    }

    @Override
    public Filter$Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String string, Object ... objectArray) {
        return this.filter.filter(logger, level, marker, string, objectArray);
    }

    @Override
    public Filter$Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String string, Object object) {
        return this.filter.filter(logger, level, marker, string, object);
    }

    @Override
    public Filter$Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String string, Object object, Object object2) {
        return this.filter.filter(logger, level, marker, string, object, object2);
    }

    @Override
    public Filter$Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3) {
        return this.filter.filter(logger, level, marker, string, object, object2, object3);
    }

    @Override
    public Filter$Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3, Object object4) {
        return this.filter.filter(logger, level, marker, string, object, object2, object3, object4);
    }

    @Override
    public Filter$Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        return this.filter.filter(logger, level, marker, string, object, object2, object3, object4, object5);
    }

    @Override
    public Filter$Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        return this.filter.filter(logger, level, marker, string, object, object2, object3, object4, object5, object6);
    }

    @Override
    public Filter$Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        return this.filter.filter(logger, level, marker, string, object, object2, object3, object4, object5, object6, object7);
    }

    @Override
    public Filter$Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        return this.filter.filter(logger, level, marker, string, object, object2, object3, object4, object5, object6, object7, object8);
    }

    @Override
    public Filter$Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        return this.filter.filter(logger, level, marker, string, object, object2, object3, object4, object5, object6, object7, object8, object9);
    }

    @Override
    public Filter$Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10) {
        return this.filter.filter(logger, level, marker, string, object, object2, object3, object4, object5, object6, object7, object8, object9, object10);
    }

    private static LastModifiedSource getSource(String string) {
        LastModifiedSource lastModifiedSource = null;
        try {
            URI uRI = new URI(string);
            lastModifiedSource = uRI.getScheme() != null ? new LastModifiedSource(new URI(string)) : new LastModifiedSource(new File(string));
        }
        catch (Exception exception) {
            lastModifiedSource = new LastModifiedSource(new File(string));
        }
        return lastModifiedSource;
    }

    private static MutableThreadContextMapFilter$ConfigResult getConfig(LastModifiedSource lastModifiedSource, AuthorizationProvider authorizationProvider) {
        MutableThreadContextMapFilter$ConfigResult mutableThreadContextMapFilter$ConfigResult;
        block22: {
            HttpInputStreamUtil$Result httpInputStreamUtil$Result;
            InputStream inputStream;
            block21: {
                File file = lastModifiedSource.getFile();
                inputStream = null;
                httpInputStreamUtil$Result = null;
                long l = lastModifiedSource.getLastModified();
                if (file != null && file.exists()) {
                    try {
                        long l2 = file.lastModified();
                        if (l2 > l) {
                            lastModifiedSource.setLastModified(l2);
                            inputStream = new FileInputStream(file);
                            httpInputStreamUtil$Result = new HttpInputStreamUtil$Result(Status.SUCCESS);
                            break block21;
                        }
                        httpInputStreamUtil$Result = new HttpInputStreamUtil$Result(Status.NOT_MODIFIED);
                    }
                    catch (Exception exception) {
                        httpInputStreamUtil$Result = new HttpInputStreamUtil$Result(Status.ERROR);
                    }
                } else if (lastModifiedSource.getURI() != null) {
                    try {
                        httpInputStreamUtil$Result = HttpInputStreamUtil.getInputStream(lastModifiedSource, authorizationProvider);
                        inputStream = httpInputStreamUtil$Result.getInputStream();
                    }
                    catch (ConfigurationException configurationException) {
                        httpInputStreamUtil$Result = new HttpInputStreamUtil$Result(Status.ERROR);
                    }
                } else {
                    httpInputStreamUtil$Result = new HttpInputStreamUtil$Result(Status.NOT_FOUND);
                }
            }
            mutableThreadContextMapFilter$ConfigResult = new MutableThreadContextMapFilter$ConfigResult(null);
            if (httpInputStreamUtil$Result.getStatus() == Status.SUCCESS) {
                LOGGER.debug("Processing Debug key/value pairs from: {}", (Object)lastModifiedSource.toString());
                try {
                    KeyValuePairConfig keyValuePairConfig = (KeyValuePairConfig)MAPPER.readValue(inputStream, KeyValuePairConfig.class);
                    if (keyValuePairConfig != null) {
                        Map<String, String[]> map = keyValuePairConfig.getConfigs();
                        if (map != null && map.size() > 0) {
                            ArrayList<KeyValuePair> arrayList = new ArrayList<KeyValuePair>();
                            for (Map.Entry<String, String[]> entry : map.entrySet()) {
                                String string = entry.getKey();
                                for (String string2 : entry.getValue()) {
                                    if (string2 != null) {
                                        arrayList.add(new KeyValuePair(string, string2));
                                        continue;
                                    }
                                    LOGGER.warn("Ignoring null value for {}", (Object)string);
                                }
                            }
                            if (arrayList.size() > 0) {
                                mutableThreadContextMapFilter$ConfigResult.pairs = arrayList.toArray(EMPTY_ARRAY);
                                mutableThreadContextMapFilter$ConfigResult.status = Status.SUCCESS;
                            } else {
                                mutableThreadContextMapFilter$ConfigResult.status = Status.EMPTY;
                            }
                        } else {
                            LOGGER.debug("No configuration data in {}", (Object)lastModifiedSource.toString());
                            mutableThreadContextMapFilter$ConfigResult.status = Status.EMPTY;
                        }
                        break block22;
                    }
                    LOGGER.warn("No configs element in MutableThreadContextMapFilter configuration");
                    mutableThreadContextMapFilter$ConfigResult.status = Status.ERROR;
                }
                catch (Exception exception) {
                    LOGGER.warn("Invalid key/value pair configuration, input ignored: {}", (Object)exception.getMessage());
                    mutableThreadContextMapFilter$ConfigResult.status = Status.ERROR;
                }
            } else {
                mutableThreadContextMapFilter$ConfigResult.status = httpInputStreamUtil$Result.getStatus();
            }
        }
        return mutableThreadContextMapFilter$ConfigResult;
    }

    static /* synthetic */ LastModifiedSource access$100(String string) {
        return MutableThreadContextMapFilter.getSource(string);
    }

    /* synthetic */ MutableThreadContextMapFilter(Filter filter, LastModifiedSource lastModifiedSource, long l, AuthorizationProvider authorizationProvider, Filter$Result filter$Result, Filter$Result filter$Result2, Configuration configuration, MutableThreadContextMapFilter$1 mutableThreadContextMapFilter$1) {
        this(filter, lastModifiedSource, l, authorizationProvider, filter$Result, filter$Result2, configuration);
    }

    static /* synthetic */ MutableThreadContextMapFilter$ConfigResult access$300(LastModifiedSource lastModifiedSource, AuthorizationProvider authorizationProvider) {
        return MutableThreadContextMapFilter.getConfig(lastModifiedSource, authorizationProvider);
    }

    static /* synthetic */ Logger access$400() {
        return LOGGER;
    }

    static /* synthetic */ LastModifiedSource access$500(MutableThreadContextMapFilter mutableThreadContextMapFilter) {
        return mutableThreadContextMapFilter.source;
    }

    static /* synthetic */ AuthorizationProvider access$600(MutableThreadContextMapFilter mutableThreadContextMapFilter) {
        return mutableThreadContextMapFilter.authorizationProvider;
    }

    static /* synthetic */ Filter access$702(MutableThreadContextMapFilter mutableThreadContextMapFilter, Filter filter) {
        mutableThreadContextMapFilter.filter = filter;
        return mutableThreadContextMapFilter.filter;
    }

    static /* synthetic */ Filter access$700(MutableThreadContextMapFilter mutableThreadContextMapFilter) {
        return mutableThreadContextMapFilter.filter;
    }

    static /* synthetic */ Logger access$800() {
        return LOGGER;
    }

    static /* synthetic */ List access$900(MutableThreadContextMapFilter mutableThreadContextMapFilter) {
        return mutableThreadContextMapFilter.listeners;
    }

    static /* synthetic */ Logger access$1000() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$1100() {
        return LOGGER;
    }
}

