/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;

public final class PluginUtil {
    private PluginUtil() {
    }

    public static Map<String, PluginType<?>> collectPluginsByCategory(String string) {
        Objects.requireNonNull(string, "category");
        return PluginUtil.collectPluginsByCategoryAndPackage(string, Collections.emptyList());
    }

    public static Map<String, PluginType<?>> collectPluginsByCategoryAndPackage(String string, List<String> list) {
        Objects.requireNonNull(string, "category");
        Objects.requireNonNull(list, "packages");
        PluginManager pluginManager = new PluginManager(string);
        pluginManager.collectPlugins(list);
        return pluginManager.getPlugins();
    }

    public static <V> V instantiatePlugin(Class<V> clazz) {
        Objects.requireNonNull(clazz, "pluginClass");
        Method method = PluginUtil.findPluginFactoryMethod(clazz);
        try {
            Object object = method.invoke(null, new Object[0]);
            return (V)object;
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            String string = String.format("failed to instantiate plugin of type %s using the factory method %s", clazz, method);
            throw new IllegalStateException(string, reflectiveOperationException);
        }
    }

    public static Method findPluginFactoryMethod(Class<?> clazz) {
        Objects.requireNonNull(clazz, "pluginClass");
        for (Method method : clazz.getDeclaredMethods()) {
            boolean bl;
            boolean bl2 = method.isAnnotationPresent(PluginFactory.class);
            if (!bl2 || !(bl = Modifier.isStatic(method.getModifiers()))) continue;
            return method;
        }
        throw new IllegalStateException("no factory method found for class " + clazz);
    }
}

