/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.convert;

import java.nio.charset.Charset;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.convert.Base64Converter;
import org.apache.logging.log4j.core.config.plugins.convert.HexConverter;
import org.apache.logging.log4j.core.config.plugins.convert.TypeConverter;
import org.apache.logging.log4j.util.Constants;

@Plugin(name="ByteArray", category="TypeConverter")
public class TypeConverters$ByteArrayConverter
implements TypeConverter<byte[]> {
    private static final String PREFIX_0x = "0x";
    private static final String PREFIX_BASE64 = "Base64:";

    @Override
    public byte[] convert(String string) {
        byte[] byArray;
        if (string == null || string.isEmpty()) {
            byArray = Constants.EMPTY_BYTE_ARRAY;
        } else if (string.startsWith(PREFIX_BASE64)) {
            String string2 = string.substring(PREFIX_BASE64.length());
            byArray = Base64Converter.parseBase64Binary(string2);
        } else if (string.startsWith(PREFIX_0x)) {
            String string3 = string.substring(PREFIX_0x.length());
            byArray = HexConverter.parseHexBinary(string3);
        } else {
            byArray = string.getBytes(Charset.defaultCharset());
        }
        return byArray;
    }
}

