/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.arbiters;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.arbiters.ScriptArbiter;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginNode;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.core.script.AbstractScript;
import org.apache.logging.log4j.core.script.ScriptRef;
import org.apache.logging.log4j.core.util.Builder;
import org.apache.logging.log4j.status.StatusLogger;

public class ScriptArbiter$Builder
implements Builder<ScriptArbiter> {
    private static final Logger LOGGER = StatusLogger.getLogger();
    @PluginConfiguration
    private AbstractConfiguration configuration;
    @PluginNode
    private Node node;

    public ScriptArbiter$Builder setConfiguration(AbstractConfiguration abstractConfiguration) {
        this.configuration = abstractConfiguration;
        return this.asBuilder();
    }

    public ScriptArbiter$Builder setNode(Node node) {
        this.node = node;
        return this.asBuilder();
    }

    public ScriptArbiter$Builder asBuilder() {
        return this;
    }

    @Override
    public ScriptArbiter build() {
        AbstractScript abstractScript = null;
        for (Node node : this.node.getChildren()) {
            PluginType<?> pluginType = node.getType();
            if (pluginType == null) {
                LOGGER.error("Node {} is missing a Plugintype", (Object)node.getName());
                continue;
            }
            if (!AbstractScript.class.isAssignableFrom(pluginType.getPluginClass())) continue;
            abstractScript = (AbstractScript)this.configuration.createPluginObject(pluginType, node);
            this.node.getChildren().remove(node);
            break;
        }
        if (abstractScript == null) {
            LOGGER.error("A Script, ScriptFile or ScriptRef element must be provided for this ScriptFilter");
            return null;
        }
        if (this.configuration.getScriptManager() == null) {
            LOGGER.error("Script support is not enabled");
            return null;
        }
        if (abstractScript instanceof ScriptRef) {
            if (this.configuration.getScriptManager().getScript(abstractScript.getName()) == null) {
                LOGGER.error("No script with name {} has been declared.", (Object)abstractScript.getName());
                return null;
            }
        } else if (!this.configuration.getScriptManager().addScript(abstractScript)) {
            return null;
        }
        return new ScriptArbiter(this.configuration, abstractScript, null);
    }
}

