/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.PropertiesPlugin$NullLookup;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.lookup.Interpolator;
import org.apache.logging.log4j.core.lookup.PropertiesLookup;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;

@Plugin(name="properties", category="Core", printObject=true)
public final class PropertiesPlugin {
    private static final StrSubstitutor UNESCAPING_SUBSTITUTOR = PropertiesPlugin.createUnescapingSubstitutor();

    private PropertiesPlugin() {
    }

    @PluginFactory
    public static StrLookup configureSubstitutor(@PluginElement(value="Properties") Property[] propertyArray, @PluginConfiguration Configuration configuration) {
        Property[] propertyArray2 = new Property[propertyArray == null ? 0 : propertyArray.length];
        for (int i = 0; i < propertyArray2.length; ++i) {
            propertyArray2[i] = PropertiesPlugin.unescape(propertyArray[i]);
        }
        return new Interpolator(new PropertiesLookup(propertyArray2, configuration.getProperties()), configuration.getPluginPackages());
    }

    private static Property unescape(Property property) {
        return Property.createProperty(property.getName(), PropertiesPlugin.unescape(property.getRawValue()), property.getValue());
    }

    static String unescape(String string) {
        return UNESCAPING_SUBSTITUTOR.replace(string);
    }

    private static StrSubstitutor createUnescapingSubstitutor() {
        StrSubstitutor strSubstitutor = new StrSubstitutor(PropertiesPlugin$NullLookup.INSTANCE);
        strSubstitutor.setValueDelimiter(null);
        strSubstitutor.setValueDelimiterMatcher(null);
        return strSubstitutor;
    }
}

