/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.async.AsyncLoggerContext;
import org.apache.logging.log4j.core.async.AsyncLoggerContextSelector;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.config.AppenderControlArraySet;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultReliabilityStrategy;
import org.apache.logging.log4j.core.config.LoggerConfig$Builder;
import org.apache.logging.log4j.core.config.LoggerConfig$LevelAndRefs;
import org.apache.logging.log4j.core.config.LoggerConfig$LoggerConfigPredicate;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.ReliabilityStrategy;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.config.properties.PropertiesConfiguration;
import org.apache.logging.log4j.core.filter.AbstractFilterable;
import org.apache.logging.log4j.core.impl.DefaultLogEventFactory;
import org.apache.logging.log4j.core.impl.LocationAware;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.impl.LogEventFactory;
import org.apache.logging.log4j.core.impl.ReusableLogEventFactory;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.StackLocatorUtil;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="logger", category="Core", printObject=true)
public class LoggerConfig
extends AbstractFilterable
implements LocationAware {
    public static final String ROOT = "root";
    private static LogEventFactory LOG_EVENT_FACTORY = null;
    private List<AppenderRef> appenderRefs = new ArrayList<AppenderRef>();
    private final AppenderControlArraySet appenders = new AppenderControlArraySet();
    private final String name;
    private LogEventFactory logEventFactory = LOG_EVENT_FACTORY;
    private Level level;
    private boolean additive = true;
    private boolean includeLocation = true;
    private LoggerConfig parent;
    private Map<Property, Boolean> propertiesMap;
    private final List<Property> properties;
    private final boolean propertiesRequireLookup;
    private final Configuration config;
    private final ReliabilityStrategy reliabilityStrategy;

    @PluginBuilderFactory
    public static <B extends LoggerConfig$Builder<B>> B newBuilder() {
        return new LoggerConfig$Builder().asBuilder();
    }

    public LoggerConfig() {
        this.level = Level.ERROR;
        this.name = "";
        this.properties = null;
        this.propertiesRequireLookup = false;
        this.config = null;
        this.reliabilityStrategy = new DefaultReliabilityStrategy(this);
    }

    public LoggerConfig(String string, Level level, boolean bl) {
        this.name = string;
        this.level = level;
        this.additive = bl;
        this.properties = null;
        this.propertiesRequireLookup = false;
        this.config = null;
        this.reliabilityStrategy = new DefaultReliabilityStrategy(this);
    }

    protected LoggerConfig(String string, List<AppenderRef> list, Filter filter, Level level, boolean bl, Property[] propertyArray, Configuration configuration, boolean bl2) {
        super(filter);
        this.name = string;
        this.appenderRefs = list;
        this.level = level;
        this.additive = bl;
        this.includeLocation = bl2;
        this.config = configuration;
        this.properties = propertyArray != null && propertyArray.length > 0 ? Collections.unmodifiableList(Arrays.asList(Arrays.copyOf(propertyArray, propertyArray.length))) : null;
        this.propertiesRequireLookup = LoggerConfig.containsPropertyRequiringLookup(propertyArray);
        this.reliabilityStrategy = configuration.getReliabilityStrategy(this);
    }

    private static boolean containsPropertyRequiringLookup(Property[] propertyArray) {
        if (propertyArray == null) {
            return false;
        }
        for (int i = 0; i < propertyArray.length; ++i) {
            if (!propertyArray[i].isValueNeedsLookup()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Filter getFilter() {
        return super.getFilter();
    }

    public String getName() {
        return this.name;
    }

    public void setParent(LoggerConfig loggerConfig) {
        this.parent = loggerConfig;
    }

    public LoggerConfig getParent() {
        return this.parent;
    }

    public void addAppender(Appender appender, Level level, Filter filter) {
        this.appenders.add(new AppenderControl(appender, level, filter));
    }

    public void removeAppender(String string) {
        AppenderControl appenderControl = null;
        while ((appenderControl = this.appenders.remove(string)) != null) {
            this.cleanupFilter(appenderControl);
        }
    }

    public Map<String, Appender> getAppenders() {
        return this.appenders.asMap();
    }

    protected void clearAppenders() {
        do {
            AppenderControl[] appenderControlArray;
            for (AppenderControl appenderControl : appenderControlArray = this.appenders.clear()) {
                this.cleanupFilter(appenderControl);
            }
        } while (!this.appenders.isEmpty());
    }

    private void cleanupFilter(AppenderControl appenderControl) {
        Filter filter = appenderControl.getFilter();
        if (filter != null) {
            appenderControl.removeFilter(filter);
            filter.stop();
        }
    }

    public List<AppenderRef> getAppenderRefs() {
        return this.appenderRefs;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public Level getLevel() {
        return this.level == null ? (this.parent == null ? Level.ERROR : this.parent.getLevel()) : this.level;
    }

    public Level getExplicitLevel() {
        return this.level;
    }

    public LogEventFactory getLogEventFactory() {
        return this.logEventFactory;
    }

    public void setLogEventFactory(LogEventFactory logEventFactory) {
        this.logEventFactory = logEventFactory;
    }

    public boolean isAdditive() {
        return this.additive;
    }

    public void setAdditive(boolean bl) {
        this.additive = bl;
    }

    public boolean isIncludeLocation() {
        return this.includeLocation;
    }

    @Deprecated
    public Map<Property, Boolean> getProperties() {
        if (this.properties == null) {
            return null;
        }
        if (this.propertiesMap == null) {
            HashMap<Property, Boolean> hashMap = new HashMap<Property, Boolean>(this.properties.size() * 2);
            for (int i = 0; i < this.properties.size(); ++i) {
                hashMap.put(this.properties.get(i), this.properties.get(i).isValueNeedsLookup());
            }
            this.propertiesMap = Collections.unmodifiableMap(hashMap);
        }
        return this.propertiesMap;
    }

    public List<Property> getPropertyList() {
        return this.properties;
    }

    public boolean isPropertiesRequireLookup() {
        return this.propertiesRequireLookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PerformanceSensitive(value={"allocation"})
    public void log(String string, String string2, Marker marker, Level level, Message message, Throwable throwable) {
        List<Property> list = this.getProperties(string, string2, marker, level, message, throwable);
        LogEvent logEvent = this.logEventFactory.createEvent(string, marker, string2, this.location(string2), level, message, list, throwable);
        try {
            this.log(logEvent, LoggerConfig$LoggerConfigPredicate.ALL);
        }
        finally {
            ReusableLogEventFactory.release(logEvent);
        }
    }

    private StackTraceElement location(String string) {
        return this.requiresLocation() ? StackLocatorUtil.calcLocation(string) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PerformanceSensitive(value={"allocation"})
    public void log(String string, String string2, StackTraceElement stackTraceElement, Marker marker, Level level, Message message, Throwable throwable) {
        List<Property> list = this.getProperties(string, string2, marker, level, message, throwable);
        LogEvent logEvent = this.logEventFactory.createEvent(string, marker, string2, stackTraceElement, level, message, list, throwable);
        try {
            this.log(logEvent, LoggerConfig$LoggerConfigPredicate.ALL);
        }
        finally {
            ReusableLogEventFactory.release(logEvent);
        }
    }

    private List<Property> getProperties(String string, String string2, Marker marker, Level level, Message message, Throwable throwable) {
        List<Property> list = this.properties;
        if (list == null || !this.propertiesRequireLookup) {
            return list;
        }
        return this.getPropertiesWithLookups(string, string2, marker, level, message, throwable, list);
    }

    private List<Property> getPropertiesWithLookups(String string, String string2, Marker marker, Level level, Message message, Throwable throwable, List<Property> list) {
        ArrayList<Property> arrayList = new ArrayList<Property>(list.size());
        Log4jLogEvent log4jLogEvent = Log4jLogEvent.newBuilder().setMessage(message).setMarker(marker).setLevel(level).setLoggerName(string).setLoggerFqcn(string2).setThrown(throwable).build();
        for (int i = 0; i < list.size(); ++i) {
            Property property = list.get(i);
            String string3 = property.evaluate(this.config.getStrSubstitutor());
            arrayList.add(Property.createProperty(property.getName(), property.getRawValue(), string3));
        }
        return arrayList;
    }

    public void log(LogEvent logEvent) {
        this.log(logEvent, LoggerConfig$LoggerConfigPredicate.ALL);
    }

    protected void log(LogEvent logEvent, LoggerConfig$LoggerConfigPredicate loggerConfig$LoggerConfigPredicate) {
        if (!this.isFiltered(logEvent)) {
            this.processLogEvent(logEvent, loggerConfig$LoggerConfigPredicate);
        }
    }

    public ReliabilityStrategy getReliabilityStrategy() {
        return this.reliabilityStrategy;
    }

    private void processLogEvent(LogEvent logEvent, LoggerConfig$LoggerConfigPredicate loggerConfig$LoggerConfigPredicate) {
        logEvent.setIncludeLocation(this.isIncludeLocation());
        if (loggerConfig$LoggerConfigPredicate.allow(this)) {
            this.callAppenders(logEvent);
        }
        this.logParent(logEvent, loggerConfig$LoggerConfigPredicate);
    }

    @Override
    public boolean requiresLocation() {
        if (!this.includeLocation) {
            return false;
        }
        AppenderControl[] appenderControlArray = this.appenders.get();
        LoggerConfig loggerConfig = this;
        while (loggerConfig != null) {
            for (AppenderControl appenderControl : appenderControlArray) {
                Appender appender = appenderControl.getAppender();
                if (!(appender instanceof LocationAware) || !((LocationAware)((Object)appender)).requiresLocation()) continue;
                return true;
            }
            if (!loggerConfig.additive) break;
            loggerConfig = loggerConfig.parent;
            if (loggerConfig == null) continue;
            appenderControlArray = loggerConfig.appenders.get();
        }
        return false;
    }

    private void logParent(LogEvent logEvent, LoggerConfig$LoggerConfigPredicate loggerConfig$LoggerConfigPredicate) {
        if (this.additive && this.parent != null) {
            this.parent.log(logEvent, loggerConfig$LoggerConfigPredicate);
        }
    }

    @PerformanceSensitive(value={"allocation"})
    protected void callAppenders(LogEvent logEvent) {
        AppenderControl[] appenderControlArray = this.appenders.get();
        for (int i = 0; i < appenderControlArray.length; ++i) {
            appenderControlArray[i].callAppender(logEvent);
        }
    }

    public String toString() {
        return Strings.isEmpty(this.name) ? ROOT : this.name;
    }

    @Deprecated
    public static LoggerConfig createLogger(String string, Level level, @PluginAttribute(value="name") String string2, String string3, AppenderRef[] appenderRefArray, Property[] propertyArray, @PluginConfiguration Configuration configuration, Filter filter) {
        if (string2 == null) {
            LOGGER.error("Loggers cannot be configured without a name");
            return null;
        }
        List<AppenderRef> list = Arrays.asList(appenderRefArray);
        String string4 = string2.equals(ROOT) ? "" : string2;
        boolean bl = Booleans.parseBoolean(string, true);
        return new LoggerConfig(string4, list, filter, level, bl, propertyArray, configuration, LoggerConfig.includeLocation(string3, configuration));
    }

    @Deprecated
    public static LoggerConfig createLogger(@PluginAttribute(value="additivity", defaultBoolean=true) boolean bl, @PluginAttribute(value="level") Level level, @Required(message="Loggers cannot be configured without a name") @PluginAttribute(value="name") String string, @PluginAttribute(value="includeLocation") String string2, @PluginElement(value="AppenderRef") AppenderRef[] appenderRefArray, @PluginElement(value="Properties") Property[] propertyArray, @PluginConfiguration Configuration configuration, @PluginElement(value="Filter") Filter filter) {
        String string3 = string.equals(ROOT) ? "" : string;
        return new LoggerConfig(string3, Arrays.asList(appenderRefArray), filter, level, bl, propertyArray, configuration, LoggerConfig.includeLocation(string2, configuration));
    }

    protected static boolean includeLocation(String string) {
        return LoggerConfig.includeLocation(string, null);
    }

    protected static boolean includeLocation(String string, Configuration configuration) {
        if (string == null) {
            LoggerContext loggerContext = null;
            if (configuration != null) {
                loggerContext = configuration.getLoggerContext();
            }
            if (loggerContext != null) {
                return !(loggerContext instanceof AsyncLoggerContext);
            }
            return !AsyncLoggerContextSelector.isSelected();
        }
        return Boolean.parseBoolean(string);
    }

    protected final boolean hasAppenders() {
        return !this.appenders.isEmpty();
    }

    protected static LoggerConfig$LevelAndRefs getLevelAndRefs(Level level, AppenderRef[] appenderRefArray, String string2, Configuration configuration) {
        LoggerConfig$LevelAndRefs loggerConfig$LevelAndRefs = new LoggerConfig$LevelAndRefs();
        if (string2 != null) {
            if (configuration instanceof PropertiesConfiguration) {
                if (level != null) {
                    LOGGER.warn("Level is ignored when levelAndRefs syntax is used.");
                }
                if (appenderRefArray != null && appenderRefArray.length > 0) {
                    LOGGER.warn("Appender references are ignored when levelAndRefs syntax is used");
                }
                String[] stringArray = Strings.splitList(string2);
                loggerConfig$LevelAndRefs.level = Level.getLevel(stringArray[0]);
                if (stringArray.length > 1) {
                    ArrayList<AppenderRef> arrayList = new ArrayList<AppenderRef>();
                    Arrays.stream(stringArray).skip(1L).forEach(string -> arrayList.add(AppenderRef.createAppenderRef(string, null, null)));
                    loggerConfig$LevelAndRefs.refs = arrayList;
                }
            } else {
                LOGGER.warn("levelAndRefs are only allowed in a properties configuration. The value is ignored.");
                loggerConfig$LevelAndRefs.level = level;
                loggerConfig$LevelAndRefs.refs = appenderRefArray != null ? Arrays.asList(appenderRefArray) : new ArrayList<AppenderRef>();
            }
        } else {
            loggerConfig$LevelAndRefs.level = level;
            loggerConfig$LevelAndRefs.refs = appenderRefArray != null ? Arrays.asList(appenderRefArray) : new ArrayList<AppenderRef>();
        }
        return loggerConfig$LevelAndRefs;
    }

    static {
        String string = PropertiesUtil.getProperties().getStringProperty("Log4jLogEventFactory");
        if (string != null) {
            try {
                Class<?> clazz = Loader.loadClass(string);
                if (clazz != null && LogEventFactory.class.isAssignableFrom(clazz)) {
                    LOG_EVENT_FACTORY = (LogEventFactory)clazz.newInstance();
                }
            }
            catch (Exception exception) {
                LOGGER.error("Unable to create LogEventFactory {}", (Object)string, (Object)exception);
            }
        }
        if (LOG_EVENT_FACTORY == null) {
            LOG_EVENT_FACTORY = Constants.ENABLE_THREADLOCALS ? new ReusableLogEventFactory() : new DefaultLogEventFactory();
        }
    }
}

