/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.net.UrlConnectionFactory;
import org.apache.logging.log4j.core.util.FileUtils;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.core.util.Source;
import org.apache.logging.log4j.util.Constants;
import org.apache.logging.log4j.util.LoaderUtil;

public class ConfigurationSource {
    public static final ConfigurationSource NULL_SOURCE = new ConfigurationSource(Constants.EMPTY_BYTE_ARRAY, null, 0L);
    public static final ConfigurationSource COMPOSITE_SOURCE = new ConfigurationSource(Constants.EMPTY_BYTE_ARRAY, null, 0L);
    private final InputStream stream;
    private volatile byte[] data;
    private volatile Source source;
    private final long lastModified;
    private volatile long modifiedMillis;

    public ConfigurationSource(InputStream inputStream, File file) {
        this.stream = Objects.requireNonNull(inputStream, "stream is null");
        this.data = null;
        this.source = new Source(file);
        long l = 0L;
        try {
            l = file.lastModified();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lastModified = l;
    }

    public ConfigurationSource(InputStream inputStream, Path path) {
        this.stream = Objects.requireNonNull(inputStream, "stream is null");
        this.data = null;
        this.source = new Source(path);
        long l = 0L;
        try {
            l = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lastModified = l;
    }

    public ConfigurationSource(InputStream inputStream, URL uRL) {
        this.stream = Objects.requireNonNull(inputStream, "stream is null");
        this.data = null;
        this.lastModified = 0L;
        this.source = new Source(uRL);
    }

    public ConfigurationSource(InputStream inputStream, URL uRL, long l) {
        this.stream = Objects.requireNonNull(inputStream, "stream is null");
        this.data = null;
        this.lastModified = l;
        this.source = new Source(uRL);
    }

    public ConfigurationSource(InputStream inputStream) {
        this(ConfigurationSource.toByteArray(inputStream), null, 0L);
    }

    public ConfigurationSource(Source source, byte[] byArray, long l) {
        Objects.requireNonNull(source, "source is null");
        this.data = Objects.requireNonNull(byArray, "data is null");
        this.stream = new ByteArrayInputStream(byArray);
        this.lastModified = l;
        this.source = source;
    }

    private ConfigurationSource(byte[] byArray, URL uRL, long l) {
        this.data = Objects.requireNonNull(byArray, "data is null");
        this.stream = new ByteArrayInputStream(byArray);
        this.lastModified = l;
        if (uRL == null) {
            this.data = byArray;
        } else {
            this.source = new Source(uRL);
        }
    }

    private static byte[] toByteArray(InputStream inputStream) {
        int n = Math.max(4096, inputStream.available());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        byte[] byArray = new byte[n];
        int n2 = inputStream.read(byArray);
        while (n2 > 0) {
            byteArrayOutputStream.write(byArray, 0, n2);
            n2 = inputStream.read(byArray);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public File getFile() {
        return this.source == null ? null : this.source.getFile();
    }

    private boolean isFile() {
        return this.source == null ? false : this.source.getFile() != null;
    }

    private boolean isURL() {
        return this.source == null ? false : this.source.getURI() != null;
    }

    private boolean isLocation() {
        return this.source == null ? false : this.source.getLocation() != null;
    }

    public URL getURL() {
        return this.source == null ? null : this.source.getURL();
    }

    @Deprecated
    public void setSource(Source source) {
        this.source = source;
    }

    public void setData(byte[] byArray) {
        this.data = byArray;
    }

    public void setModifiedMillis(long l) {
        this.modifiedMillis = l;
    }

    public URI getURI() {
        return this.source == null ? null : this.source.getURI();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getLocation() {
        return this.source == null ? null : this.source.getLocation();
    }

    public InputStream getInputStream() {
        return this.stream;
    }

    public ConfigurationSource resetInputStream() {
        if (this.source != null && this.data != null) {
            return new ConfigurationSource(this.source, this.data, this.lastModified);
        }
        if (this.isFile()) {
            return new ConfigurationSource((InputStream)new FileInputStream(this.getFile()), this.getFile());
        }
        if (this.isURL() && this.data != null) {
            return new ConfigurationSource(this.data, this.getURL(), this.modifiedMillis == 0L ? this.lastModified : this.modifiedMillis);
        }
        if (this.isURL()) {
            return ConfigurationSource.fromUri(this.getURI());
        }
        if (this.data != null) {
            return new ConfigurationSource(this.data, null, this.lastModified);
        }
        return null;
    }

    public String toString() {
        if (this.isLocation()) {
            return this.getLocation();
        }
        if (this == NULL_SOURCE) {
            return "NULL_SOURCE";
        }
        int n = this.data == null ? -1 : this.data.length;
        return "stream (" + n + " bytes, unknown location)";
    }

    public static ConfigurationSource fromUri(URI uRI) {
        File file = FileUtils.fileFromUri(uRI);
        if (file != null && file.exists() && file.canRead()) {
            try {
                return new ConfigurationSource((InputStream)new FileInputStream(file), file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                ConfigurationFactory.LOGGER.error("Cannot locate file {}", (Object)uRI.getPath(), (Object)fileNotFoundException);
            }
        }
        if (ConfigurationFactory.isClassLoaderUri(uRI)) {
            ClassLoader classLoader = LoaderUtil.getThreadContextClassLoader();
            String string = ConfigurationFactory.extractClassLoaderUriPath(uRI);
            return ConfigurationSource.fromResource(string, classLoader);
        }
        if (!uRI.isAbsolute()) {
            ConfigurationFactory.LOGGER.error("File not found in file system or classpath: {}", (Object)uRI.toString());
            return null;
        }
        try {
            return ConfigurationSource.getConfigurationSource(uRI.toURL());
        }
        catch (MalformedURLException malformedURLException) {
            ConfigurationFactory.LOGGER.error("Invalid URL {}", (Object)uRI.toString(), (Object)malformedURLException);
            return null;
        }
    }

    public static ConfigurationSource fromResource(String string, ClassLoader classLoader) {
        URL uRL = Loader.getResource(string, classLoader);
        if (uRL == null) {
            return null;
        }
        return ConfigurationSource.getConfigurationSource(uRL);
    }

    private static ConfigurationSource getConfigurationSource(URL uRL) {
        try {
            File file = FileUtils.fileFromUri(uRL.toURI());
            URLConnection uRLConnection = UrlConnectionFactory.createConnection(uRL);
            try {
                if (file != null) {
                    return new ConfigurationSource(uRLConnection.getInputStream(), FileUtils.fileFromUri(uRL.toURI()));
                }
                if (uRLConnection instanceof JarURLConnection) {
                    long l = new File(((JarURLConnection)uRLConnection).getJarFile().getName()).lastModified();
                    return new ConfigurationSource(uRLConnection.getInputStream(), uRL, l);
                }
                return new ConfigurationSource(uRLConnection.getInputStream(), uRL, uRLConnection.getLastModified());
            }
            catch (FileNotFoundException fileNotFoundException) {
                ConfigurationFactory.LOGGER.info("Unable to locate file {}, ignoring.", (Object)uRL.toString());
                return null;
            }
        }
        catch (IOException | URISyntaxException exception) {
            ConfigurationFactory.LOGGER.warn("Error accessing {} due to {}, ignoring.", (Object)uRL.toString(), (Object)exception.getMessage());
            return null;
        }
    }
}

