/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory$Factory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.OrderComparator;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.core.lookup.ConfigurationStrSubstitutor;
import org.apache.logging.log4j.core.lookup.Interpolator;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.util.AuthorizationProvider;
import org.apache.logging.log4j.core.util.BasicAuthorizationProvider;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.core.util.NetUtils;
import org.apache.logging.log4j.core.util.ReflectionUtil;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.PropertiesUtil;

public abstract class ConfigurationFactory
extends ConfigurationBuilderFactory {
    public static final String CONFIGURATION_FACTORY_PROPERTY = "log4j.configurationFactory";
    public static final String CONFIGURATION_FILE_PROPERTY = "log4j.configurationFile";
    public static final String LOG4J1_CONFIGURATION_FILE_PROPERTY = "log4j.configuration";
    public static final String LOG4J1_EXPERIMENTAL = "log4j1.compatibility";
    public static final String AUTHORIZATION_PROVIDER = "authorizationProvider";
    public static final String CATEGORY = "ConfigurationFactory";
    protected static final Logger LOGGER = StatusLogger.getLogger();
    protected static final String TEST_PREFIX = "log4j2-test";
    protected static final String DEFAULT_PREFIX = "log4j2";
    protected static final String LOG4J1_VERSION = "1";
    protected static final String LOG4J2_VERSION = "2";
    private static final String CLASS_LOADER_SCHEME = "classloader";
    private static final String CLASS_PATH_SCHEME = "classpath";
    private static final String OVERRIDE_PARAM = "override";
    private static volatile List<ConfigurationFactory> factories;
    private static ConfigurationFactory configFactory;
    protected final StrSubstitutor substitutor = new ConfigurationStrSubstitutor(new Interpolator());
    private static final Lock LOCK;
    private static final String HTTPS = "https";
    private static final String HTTP = "http";
    private static final String[] PREFIXES;
    private static volatile AuthorizationProvider authorizationProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationFactory getInstance() {
        if (factories == null) {
            LOCK.lock();
            try {
                if (factories == null) {
                    ArrayList<ConfigurationFactory> arrayList = new ArrayList<ConfigurationFactory>();
                    PropertiesUtil propertiesUtil = PropertiesUtil.getProperties();
                    String string = propertiesUtil.getStringProperty(CONFIGURATION_FACTORY_PROPERTY);
                    if (string != null) {
                        ConfigurationFactory.addFactory(arrayList, string);
                    }
                    PluginManager pluginManager = new PluginManager(CATEGORY);
                    pluginManager.collectPlugins();
                    Map<String, PluginType<?>> map = pluginManager.getPlugins();
                    ArrayList<Class<ConfigurationFactory>> arrayList2 = new ArrayList<Class<ConfigurationFactory>>(map.size());
                    for (PluginType<?> object : map.values()) {
                        try {
                            arrayList2.add(object.getPluginClass().asSubclass(ConfigurationFactory.class));
                        }
                        catch (Exception exception) {
                            LOGGER.warn("Unable to add class {}", (Object)object.getPluginClass(), (Object)exception);
                        }
                    }
                    Collections.sort(arrayList2, OrderComparator.getInstance());
                    for (Class clazz : arrayList2) {
                        ConfigurationFactory.addFactory(arrayList, clazz);
                    }
                    factories = Collections.unmodifiableList(arrayList);
                    authorizationProvider = ConfigurationFactory.authorizationProvider(propertiesUtil);
                }
            }
            finally {
                LOCK.unlock();
            }
        }
        LOGGER.debug("Using configurationFactory {}", (Object)configFactory);
        return configFactory;
    }

    public static AuthorizationProvider authorizationProvider(PropertiesUtil propertiesUtil) {
        String string = propertiesUtil.getStringProperty(PREFIXES, AUTHORIZATION_PROVIDER, null);
        AuthorizationProvider authorizationProvider = null;
        if (string != null) {
            try {
                Object t = LoaderUtil.newInstanceOf(string);
                if (t instanceof AuthorizationProvider) {
                    authorizationProvider = (AuthorizationProvider)t;
                } else {
                    LOGGER.warn("{} is not an AuthorizationProvider, using default", (Object)t.getClass().getName());
                }
            }
            catch (Exception exception) {
                LOGGER.warn("Unable to create {}, using default: {}", (Object)string, (Object)exception.getMessage());
            }
        }
        if (authorizationProvider == null) {
            authorizationProvider = new BasicAuthorizationProvider(propertiesUtil);
        }
        return authorizationProvider;
    }

    public static AuthorizationProvider getAuthorizationProvider() {
        return authorizationProvider;
    }

    private static void addFactory(Collection<ConfigurationFactory> collection, String string) {
        try {
            ConfigurationFactory.addFactory(collection, Loader.loadClass(string).asSubclass(ConfigurationFactory.class));
        }
        catch (Exception exception) {
            LOGGER.error("Unable to load class {}", (Object)string, (Object)exception);
        }
    }

    private static void addFactory(Collection<ConfigurationFactory> collection, Class<? extends ConfigurationFactory> clazz) {
        try {
            collection.add(ReflectionUtil.instantiate(clazz));
        }
        catch (Exception exception) {
            LOGGER.error("Unable to create instance of {}", (Object)clazz.getName(), (Object)exception);
        }
    }

    public static void setConfigurationFactory(ConfigurationFactory configurationFactory) {
        configFactory = configurationFactory;
    }

    public static void resetConfigurationFactory() {
        configFactory = new ConfigurationFactory$Factory(null);
    }

    public static void removeConfigurationFactory(ConfigurationFactory configurationFactory) {
        if (configFactory == configurationFactory) {
            configFactory = new ConfigurationFactory$Factory(null);
        }
    }

    protected abstract String[] getSupportedTypes();

    protected String getTestPrefix() {
        return TEST_PREFIX;
    }

    protected String getDefaultPrefix() {
        return DEFAULT_PREFIX;
    }

    protected String getVersion() {
        return LOG4J2_VERSION;
    }

    protected boolean isActive() {
        return true;
    }

    public abstract Configuration getConfiguration(LoggerContext var1, ConfigurationSource var2);

    public Configuration getConfiguration(LoggerContext loggerContext, String string, URI uRI) {
        ConfigurationSource configurationSource;
        if (!this.isActive()) {
            return null;
        }
        if (uRI != null && (configurationSource = ConfigurationSource.fromUri(uRI)) != null) {
            return this.getConfiguration(loggerContext, configurationSource);
        }
        return null;
    }

    public Configuration getConfiguration(LoggerContext loggerContext, String string, URI uRI, ClassLoader classLoader) {
        Configuration configuration;
        String string2;
        ConfigurationSource configurationSource;
        if (!this.isActive()) {
            return null;
        }
        if (classLoader == null) {
            return this.getConfiguration(loggerContext, string, uRI);
        }
        if (ConfigurationFactory.isClassLoaderUri(uRI) && (configurationSource = ConfigurationSource.fromResource(string2 = ConfigurationFactory.extractClassLoaderUriPath(uRI), classLoader)) != null && (configuration = this.getConfiguration(loggerContext, configurationSource)) != null) {
            return configuration;
        }
        return this.getConfiguration(loggerContext, string, uRI);
    }

    static boolean isClassLoaderUri(URI uRI) {
        if (uRI == null) {
            return false;
        }
        String string = uRI.getScheme();
        return string == null || string.equals(CLASS_LOADER_SCHEME) || string.equals(CLASS_PATH_SCHEME);
    }

    static String extractClassLoaderUriPath(URI uRI) {
        return uRI.getScheme() == null ? uRI.getPath() : uRI.getSchemeSpecificPart();
    }

    @Deprecated
    protected ConfigurationSource getInputFromString(String string, ClassLoader classLoader) {
        return ConfigurationSource.fromUri(NetUtils.toURI(string));
    }

    static List<ConfigurationFactory> getFactories() {
        return factories;
    }

    static {
        configFactory = new ConfigurationFactory$Factory(null);
        LOCK = new ReentrantLock();
        PREFIXES = new String[]{"log4j2.", "log4j2.Configuration."};
    }
}

