/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.util.PerformanceSensitive;

@PerformanceSensitive
public class AppenderControlArraySet {
    private static final AtomicReferenceFieldUpdater<AppenderControlArraySet, AppenderControl[]> appenderArrayUpdater = AtomicReferenceFieldUpdater.newUpdater(AppenderControlArraySet.class, AppenderControl[].class, "appenderArray");
    private volatile AppenderControl[] appenderArray = AppenderControl.EMPTY_ARRAY;

    public boolean add(AppenderControl appenderControl) {
        AppenderControl[] appenderControlArray;
        AppenderControl[] appenderControlArray2;
        boolean bl;
        do {
            for (AppenderControl appenderControl2 : appenderControlArray2 = this.appenderArray) {
                if (!appenderControl2.equals(appenderControl)) continue;
                return false;
            }
            appenderControlArray = Arrays.copyOf(appenderControlArray2, appenderControlArray2.length + 1);
            appenderControlArray[appenderControlArray.length - 1] = appenderControl;
        } while (!(bl = appenderArrayUpdater.compareAndSet(this, appenderControlArray2, appenderControlArray)));
        return true;
    }

    public AppenderControl remove(String string) {
        boolean bl;
        block0: do {
            bl = true;
            AppenderControl[] appenderControlArray = this.appenderArray;
            for (int i = 0; i < appenderControlArray.length; ++i) {
                AppenderControl appenderControl = appenderControlArray[i];
                if (!Objects.equals(string, appenderControl.getAppenderName())) continue;
                AppenderControl[] appenderControlArray2 = this.removeElementAt(i, appenderControlArray);
                if (appenderArrayUpdater.compareAndSet(this, appenderControlArray, appenderControlArray2)) {
                    return appenderControl;
                }
                bl = false;
                continue block0;
            }
        } while (!bl);
        return null;
    }

    private AppenderControl[] removeElementAt(int n, AppenderControl[] appenderControlArray) {
        AppenderControl[] appenderControlArray2 = Arrays.copyOf(appenderControlArray, appenderControlArray.length - 1);
        System.arraycopy(appenderControlArray, n + 1, appenderControlArray2, n, appenderControlArray2.length - n);
        return appenderControlArray2;
    }

    public Map<String, Appender> asMap() {
        HashMap<String, Appender> hashMap = new HashMap<String, Appender>();
        for (AppenderControl appenderControl : this.appenderArray) {
            hashMap.put(appenderControl.getAppenderName(), appenderControl.getAppender());
        }
        return hashMap;
    }

    public AppenderControl[] clear() {
        return appenderArrayUpdater.getAndSet(this, AppenderControl.EMPTY_ARRAY);
    }

    public boolean isEmpty() {
        return this.appenderArray.length == 0;
    }

    public AppenderControl[] get() {
        return this.appenderArray;
    }

    public String toString() {
        return "AppenderControlArraySet [appenderArray=" + Arrays.toString(this.appenderArray) + "]";
    }
}

