/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.core.async.ThreadNameCachingStrategy$1;
import org.apache.logging.log4j.core.async.ThreadNameCachingStrategy$2;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Constants;
import org.apache.logging.log4j.util.PropertiesUtil;

public abstract class ThreadNameCachingStrategy
extends Enum<ThreadNameCachingStrategy> {
    public static final /* enum */ ThreadNameCachingStrategy CACHED = new ThreadNameCachingStrategy$1();
    public static final /* enum */ ThreadNameCachingStrategy UNCACHED = new ThreadNameCachingStrategy$2();
    private static final StatusLogger LOGGER;
    private static final ThreadLocal<String> THREADLOCAL_NAME;
    static final ThreadNameCachingStrategy DEFAULT_STRATEGY;
    private static final /* synthetic */ ThreadNameCachingStrategy[] $VALUES;

    public static ThreadNameCachingStrategy[] values() {
        return (ThreadNameCachingStrategy[])$VALUES.clone();
    }

    public static ThreadNameCachingStrategy valueOf(String string) {
        return Enum.valueOf(ThreadNameCachingStrategy.class, string);
    }

    private ThreadNameCachingStrategy() {
    }

    abstract String getThreadName();

    public static ThreadNameCachingStrategy create() {
        String string = PropertiesUtil.getProperties().getStringProperty("AsyncLogger.ThreadNameStrategy");
        try {
            ThreadNameCachingStrategy threadNameCachingStrategy = string != null ? ThreadNameCachingStrategy.valueOf(string) : DEFAULT_STRATEGY;
            LOGGER.debug("AsyncLogger.ThreadNameStrategy={} (user specified {}, default is {})", (Object)threadNameCachingStrategy.name(), (Object)string, (Object)DEFAULT_STRATEGY.name());
            return threadNameCachingStrategy;
        }
        catch (Exception exception) {
            LOGGER.debug("Using AsyncLogger.ThreadNameStrategy.{}: '{}' not valid: {}", (Object)DEFAULT_STRATEGY.name(), (Object)string, (Object)exception.toString());
            return DEFAULT_STRATEGY;
        }
    }

    static boolean isAllocatingThreadGetName() {
        if (Constants.JAVA_MAJOR_VERSION == 8) {
            try {
                Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)_(\\d+)");
                Matcher matcher = pattern.matcher(System.getProperty("java.version"));
                if (matcher.matches()) {
                    return Integers.parseInt(matcher.group(3)) == 0 && Integers.parseInt(matcher.group(4)) < 102;
                }
                return true;
            }
            catch (Exception exception) {
                return true;
            }
        }
        return Constants.JAVA_MAJOR_VERSION < 8;
    }

    /* synthetic */ ThreadNameCachingStrategy(String string, int n, ThreadNameCachingStrategy$1 threadNameCachingStrategy$1) {
        this();
    }

    static /* synthetic */ ThreadLocal access$100() {
        return THREADLOCAL_NAME;
    }

    static {
        $VALUES = new ThreadNameCachingStrategy[]{CACHED, UNCACHED};
        LOGGER = StatusLogger.getLogger();
        THREADLOCAL_NAME = new ThreadLocal();
        DEFAULT_STRATEGY = ThreadNameCachingStrategy.isAllocatingThreadGetName() ? CACHED : UNCACHED;
    }
}

