/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import com.lmax.disruptor.LifecycleAware;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceReportingEventHandler;
import org.apache.logging.log4j.core.async.RingBufferLogEvent;

public class RingBufferLogEventHandler
implements LifecycleAware,
SequenceReportingEventHandler<RingBufferLogEvent> {
    private static final int NOTIFY_PROGRESS_THRESHOLD = 50;
    private Sequence sequenceCallback;
    private int counter;
    private long threadId = -1L;

    public void setSequenceCallback(Sequence sequence) {
        this.sequenceCallback = sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(RingBufferLogEvent ringBufferLogEvent, long l, boolean bl) {
        try {
            if (ringBufferLogEvent.isPopulated()) {
                ringBufferLogEvent.execute(bl);
            }
        }
        finally {
            ringBufferLogEvent.clear();
            this.notifyCallback(l);
        }
    }

    private void notifyCallback(long l) {
        if (++this.counter > 50) {
            this.sequenceCallback.set(l);
            this.counter = 0;
        }
    }

    public long getThreadId() {
        return this.threadId;
    }

    public void onStart() {
        this.threadId = Thread.currentThread().getId();
    }

    public void onShutdown() {
    }
}

