/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.BusySpinWaitStrategy;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.YieldingWaitStrategy;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.async.AsyncWaitStrategyFactory;
import org.apache.logging.log4j.core.async.TimeoutBlockingWaitStrategy;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.Strings;

class DefaultAsyncWaitStrategyFactory
implements AsyncWaitStrategyFactory {
    static final String DEFAULT_WAIT_STRATEGY_CLASSNAME = TimeoutBlockingWaitStrategy.class.getName();
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final String propertyName;

    public DefaultAsyncWaitStrategyFactory(String string) {
        this.propertyName = string;
    }

    @Override
    public WaitStrategy createWaitStrategy() {
        String string;
        String string2 = PropertiesUtil.getProperties().getStringProperty(this.propertyName, "TIMEOUT");
        LOGGER.trace("DefaultAsyncWaitStrategyFactory property {}={}", (Object)this.propertyName, (Object)string2);
        switch (string = Strings.toRootUpperCase(string2)) {
            case "SLEEP": {
                long l = DefaultAsyncWaitStrategyFactory.parseAdditionalLongProperty(this.propertyName, "SleepTimeNs", 100L);
                String string3 = DefaultAsyncWaitStrategyFactory.getFullPropertyKey(this.propertyName, "Retries");
                int n = PropertiesUtil.getProperties().getIntegerProperty(string3, 200);
                LOGGER.trace("DefaultAsyncWaitStrategyFactory creating SleepingWaitStrategy(retries={}, sleepTimeNs={})", (Object)n, (Object)l);
                return new SleepingWaitStrategy(n, l);
            }
            case "YIELD": {
                LOGGER.trace("DefaultAsyncWaitStrategyFactory creating YieldingWaitStrategy");
                return new YieldingWaitStrategy();
            }
            case "BLOCK": {
                LOGGER.trace("DefaultAsyncWaitStrategyFactory creating BlockingWaitStrategy");
                return new BlockingWaitStrategy();
            }
            case "BUSYSPIN": {
                LOGGER.trace("DefaultAsyncWaitStrategyFactory creating BusySpinWaitStrategy");
                return new BusySpinWaitStrategy();
            }
            case "TIMEOUT": {
                return DefaultAsyncWaitStrategyFactory.createDefaultWaitStrategy(this.propertyName);
            }
        }
        return DefaultAsyncWaitStrategyFactory.createDefaultWaitStrategy(this.propertyName);
    }

    static WaitStrategy createDefaultWaitStrategy(String string) {
        long l = DefaultAsyncWaitStrategyFactory.parseAdditionalLongProperty(string, "Timeout", 10L);
        LOGGER.trace("DefaultAsyncWaitStrategyFactory creating TimeoutBlockingWaitStrategy(timeout={}, unit=MILLIS)", (Object)l);
        return new TimeoutBlockingWaitStrategy(l, TimeUnit.MILLISECONDS);
    }

    private static String getFullPropertyKey(String string, String string2) {
        if (string.startsWith("AsyncLogger.")) {
            return "AsyncLogger." + string2;
        }
        if (string.startsWith("AsyncLoggerConfig.")) {
            return "AsyncLoggerConfig." + string2;
        }
        return string + string2;
    }

    private static long parseAdditionalLongProperty(String string, String string2, long l) {
        String string3 = DefaultAsyncWaitStrategyFactory.getFullPropertyKey(string, string2);
        return PropertiesUtil.getProperties().getLongProperty(string3, l);
    }
}

